/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.worker;

import com.amazonaws.util.EC2MetadataUtils;
import com.netflix.conductor.client.config.PropertyFactory;
import com.netflix.conductor.client.worker.LoggerHolder;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;

public interface Worker {
    public String getTaskDefName();

    public TaskResult execute(Task var1);

    default public void onErrorUpdate(Task task) {
    }

    default public boolean paused() {
        return PropertyFactory.getBoolean(this.getTaskDefName(), "paused", false);
    }

    default public String getIdentity() {
        String serverId;
        try {
            serverId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            serverId = System.getenv("HOSTNAME");
        }
        if (serverId == null) {
            serverId = EC2MetadataUtils.getInstanceId() == null ? System.getProperty("user.name") : EC2MetadataUtils.getInstanceId();
        }
        LoggerHolder.logger.debug("Setting worker id to {}", (Object)serverId);
        return serverId;
    }

    default public int getPollingInterval() {
        return PropertyFactory.getInteger(this.getTaskDefName(), "pollInterval", 1000);
    }

    default public boolean leaseExtendEnabled() {
        return PropertyFactory.getBoolean(this.getTaskDefName(), "leaseExtendEnabled", false);
    }

    default public int getBatchPollTimeoutInMS() {
        return PropertyFactory.getInteger(this.getTaskDefName(), "batchPollTimeoutInMS", 1000);
    }

    public static Worker create(final String taskType, final Function<Task, TaskResult> executor) {
        return new Worker(){

            @Override
            public String getTaskDefName() {
                return taskType;
            }

            @Override
            public TaskResult execute(Task task) {
                return (TaskResult)executor.apply(task);
            }

            @Override
            public boolean paused() {
                return Worker.super.paused();
            }
        };
    }
}

