/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ClientRequestHandler;
import com.netflix.conductor.client.http.PayloadStorage;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.netflix.conductor.common.validation.ErrorResponse;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBase.class);
    protected ClientRequestHandler requestHandler;
    protected String root = "";
    protected ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    protected PayloadStorage payloadStorage;
    protected ConductorClientConfiguration conductorClientConfiguration;

    protected ClientBase(ClientRequestHandler requestHandler, ConductorClientConfiguration clientConfiguration) {
        if (this.isNewerJacksonVersion()) {
            this.objectMapper.registerModule((Module)new JavaTimeModule());
        }
        this.requestHandler = requestHandler;
        this.conductorClientConfiguration = (ConductorClientConfiguration)ObjectUtils.defaultIfNull((Object)clientConfiguration, (Object)new DefaultConductorClientConfiguration());
        this.payloadStorage = new PayloadStorage(this);
    }

    public void setRootURI(String root) {
        this.root = root;
    }

    protected void delete(String url, Object ... uriVariables) {
        this.deleteWithUriVariables(null, url, uriVariables);
    }

    protected void deleteWithUriVariables(Object[] queryParams, String url, Object ... uriVariables) {
        this.delete(queryParams, url, uriVariables);
    }

    private void delete(Object[] queryParams, String url, Object[] uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            Response response = this.requestHandler.delete(uri);
            if (response.getStatus() >= 300) {
                throw new UniformInterfaceException(response);
            }
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
    }

    protected void put(String url, Object[] queryParams, Object request, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            Entity entity = request != null ? Entity.json((Object)request) : Entity.text((Object)"");
            Response response = this.requestHandler.getWebResourceBuilder(uri).put(entity);
            if (response.getStatus() >= 300) {
                throw new UniformInterfaceException(response);
            }
        }
        catch (RuntimeException e) {
            this.handleException(e, uri);
        }
    }

    protected void postForEntityWithRequestOnly(String url, Object request) {
        Class type = null;
        this.postForEntity(url, request, null, type, new Object[0]);
    }

    protected void postForEntityWithUriVariablesOnly(String url, Object ... uriVariables) {
        Class type = null;
        this.postForEntity(url, null, null, type, uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, (Object)responseType, (Function<Invocation.Builder, T>)((Function<Invocation.Builder, Object>)builder -> builder.post(Entity.json((Object)request), responseType)), uriVariables);
    }

    protected <T> T postForEntity(String url, Object request, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.postForEntity(url, request, queryParams, responseType, (Invocation.Builder builder) -> builder.post(Entity.json((Object)request), responseType), uriVariables);
    }

    private <T> T postForEntity(String url, Object request, Object[] queryParams, Object responseType, Function<Invocation.Builder, T> postWithEntity, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            Invocation.Builder webResourceBuilder = this.requestHandler.getWebResourceBuilder(uri);
            if (responseType == null) {
                Response response = webResourceBuilder.post(Entity.json((Object)request));
                if (response.getStatus() >= 300) {
                    throw new UniformInterfaceException(response);
                }
                return null;
            }
            return postWithEntity.apply(webResourceBuilder);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    protected <T> T getForEntity(String url, Object[] queryParams, Class<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (Response response) -> response.readEntity(responseType), uriVariables);
    }

    protected <T> T getForEntity(String url, Object[] queryParams, GenericType<T> responseType, Object ... uriVariables) {
        return (T)this.getForEntity(url, queryParams, (Response response) -> response.readEntity(responseType), uriVariables);
    }

    private <T> T getForEntity(String url, Object[] queryParams, Function<Response, T> entityProvider, Object ... uriVariables) {
        URI uri = null;
        try {
            uri = this.getURIBuilder(this.root + url, queryParams).build(uriVariables);
            Response response = this.requestHandler.get(uri);
            if (response.getStatus() < 300) {
                return entityProvider.apply(response);
            }
            throw new UniformInterfaceException(response);
        }
        catch (UniformInterfaceException e) {
            this.handleUniformInterfaceException(e, uri);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
        }
        return null;
    }

    protected String uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType payloadType, byte[] payloadBytes, long payloadSize) {
        Validate.isTrue((payloadType.equals((Object)ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT) || payloadType.equals((Object)ExternalPayloadStorage.PayloadType.TASK_OUTPUT) ? 1 : 0) != 0, (String)"Payload type must be workflow input or task output", (Object[])new Object[0]);
        ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.WRITE, payloadType, "");
        this.payloadStorage.upload(externalStorageLocation.getUri(), new ByteArrayInputStream(payloadBytes), payloadSize);
        return externalStorageLocation.getPath();
    }

    protected Map<String, Object> downloadFromExternalStorage(ExternalPayloadStorage.PayloadType payloadType, String path) {
        Map map;
        block8: {
            Validate.notBlank((CharSequence)path, (String)"uri cannot be blank", (Object[])new Object[0]);
            ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.READ, payloadType, path);
            InputStream inputStream = this.payloadStorage.download(externalStorageLocation.getUri());
            try {
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMsg = String.format("Unable to download payload from external storage location: %s", path);
                    LOGGER.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(errorMsg, e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private UriBuilder getURIBuilder(String path, Object[] queryParams) {
        if (path == null) {
            path = "";
        }
        UriBuilder builder = UriBuilder.fromPath((String)path);
        if (queryParams != null) {
            for (int i = 0; i < queryParams.length; i += 2) {
                String param = queryParams[i].toString();
                Object value = queryParams[i + 1];
                if (value == null) continue;
                if (value instanceof Collection) {
                    Object[] values = ((Collection)value).toArray();
                    builder.queryParam(param, values);
                    continue;
                }
                builder.queryParam(param, new Object[]{value});
            }
        }
        return builder;
    }

    protected boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }

    private void handleRuntimeException(RuntimeException exception, URI uri) {
        String errorMessage = String.format("Unable to invoke Conductor API with uri: %s, runtime exception occurred", uri);
        LOGGER.error(errorMessage, (Throwable)exception);
        throw new ConductorClientException(errorMessage, exception);
    }

    private void handleUniformInterfaceException(UniformInterfaceException exception, URI uri) {
        Response response = exception.getResponse();
        try (Response response2 = response;){
            ErrorResponse errorResponse;
            if (response == null) {
                throw new ConductorClientException(String.format("Unable to invoke Conductor API with uri: %s", uri));
            }
            if (response.getStatus() < 300) {
                return;
            }
            String errorMessage = (String)response.readEntity(String.class);
            LOGGER.warn("Unable to invoke Conductor API with uri: {}, unexpected response from server: statusCode={}, responseBody='{}'.", new Object[]{uri, response.getStatus(), errorMessage});
            try {
                errorResponse = (ErrorResponse)this.objectMapper.readValue(errorMessage, ErrorResponse.class);
            }
            catch (IOException e) {
                throw new ConductorClientException(response.getStatus(), errorMessage);
            }
            throw new ConductorClientException(response.getStatus(), errorResponse);
        }
        catch (ConductorClientException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e, uri);
            return;
        }
    }

    private void handleException(RuntimeException e, URI uri) {
        if (e instanceof UniformInterfaceException) {
            this.handleUniformInterfaceException((UniformInterfaceException)e, uri);
        } else {
            this.handleRuntimeException(e, uri);
        }
    }

    static class UniformInterfaceException
    extends RuntimeException {
        private final Response response;

        public UniformInterfaceException(Response response) {
            this.response = response;
        }

        @Generated
        public Response getResponse() {
            return this.response;
        }
    }
}

