/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.glassfish.jersey.client.ClientConfig;

public class ClientRequestHandler {
    private final Client client;

    public ClientRequestHandler(ClientConfig config, ClientRequestFilter ... filters) {
        ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
        if (this.isNewerJacksonVersion()) {
            objectMapper.registerModule((Module)new JavaTimeModule());
        }
        JacksonJsonProvider provider = new JacksonJsonProvider(objectMapper);
        config.register((Object)provider);
        this.client = ClientBuilder.newClient((Configuration)config);
        for (ClientRequestFilter filter : filters) {
            this.client.register((Object)filter);
        }
    }

    public Response delete(URI uri) {
        return this.client.target(uri).request().delete();
    }

    public Response get(URI uri) {
        return this.client.target(uri).request(new String[]{"application/json", "text/plain"}).get();
    }

    public Invocation.Builder getWebResourceBuilder(URI uri) {
        return this.client.target(uri).request(new String[]{"application/json"}).accept(new String[]{"text/plain", "application/json"});
    }

    private boolean isNewerJacksonVersion() {
        Version version = PackageVersion.VERSION;
        return version.getMajorVersion() == 2 && version.getMinorVersion() >= 12;
    }
}

