/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.ClientRequestHandler;
import com.netflix.conductor.common.metadata.events.EventHandler;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.GenericType;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.glassfish.jersey.client.ClientConfig;

public class EventClient
extends ClientBase {
    private static final GenericType<List<EventHandler>> eventHandlerList = new GenericType<List<EventHandler>>(){};

    public EventClient() {
        this(new ClientConfig(), new DefaultConductorClientConfiguration(), new ClientRequestFilter[0]);
    }

    public EventClient(ClientConfig clientConfig) {
        this(clientConfig, new DefaultConductorClientConfiguration(), new ClientRequestFilter[0]);
    }

    public EventClient(ClientConfig config, ClientRequestFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), filters);
    }

    public EventClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientRequestFilter ... filters) {
        super(new ClientRequestHandler(config, filters), clientConfiguration);
    }

    EventClient(ClientRequestHandler requestHandler) {
        super(requestHandler, null);
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.postForEntityWithRequestOnly("event", eventHandler);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.put("event", null, eventHandler, new Object[0]);
    }

    public List<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Validate.notBlank((CharSequence)event, (String)"Event cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("event/{event}", new Object[]{"activeOnly", activeOnly}, eventHandlerList, event);
    }

    public void unregisterEventHandler(String name) {
        Validate.notBlank((CharSequence)name, (String)"Event handler name cannot be blank", (Object[])new Object[0]);
        this.delete("event/{name}", name);
    }
}

