/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskDef
extends Auditable {
    public static final int ONE_HOUR = 3600;
    private String name;
    private String description;
    private int retryCount;
    private long timeoutSeconds;
    private List<String> inputKeys;
    private List<String> outputKeys;
    private TimeoutPolicy timeoutPolicy;
    private RetryLogic retryLogic;
    private int retryDelaySeconds;
    private long responseTimeoutSeconds;
    private Integer concurrentExecLimit;
    private Map<String, Object> inputTemplate;
    private Integer rateLimitPerFrequency;
    private Integer rateLimitFrequencyInSeconds;
    private String isolationGroupId;
    private String executionNameSpace;
    private String ownerEmail;
    private Integer pollTimeoutSeconds;
    private Integer backoffScaleFactor;
    private String baseType;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema;
    private long totalTimeoutSeconds;

    public TaskDef(String name) {
        this(name, null);
    }

    public TaskDef(String name, String description) {
        this(name, description, 3, 0L);
    }

    public TaskDef(String name, String description, int retryCount, long timeoutSeconds) {
        this(name, description, null, retryCount, timeoutSeconds, 3600L);
    }

    public TaskDef(String name, String description, String ownerEmail, int retryCount, long timeoutSeconds, long responseTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.ownerEmail = ownerEmail;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.inputKeys = new ArrayList<String>();
        this.outputKeys = new ArrayList<String>();
        this.timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
        this.retryLogic = RetryLogic.FIXED;
        this.retryDelaySeconds = 60;
        this.inputTemplate = new HashMap<String, Object>();
        this.backoffScaleFactor = 1;
    }

    public Integer getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency == null ? 0 : this.rateLimitPerFrequency;
    }

    public Integer getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds == null ? 1 : this.rateLimitFrequencyInSeconds;
    }

    public int concurrencyLimit() {
        return this.concurrentExecLimit == null ? 0 : this.concurrentExecLimit;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDef taskDef = (TaskDef)o;
        return this.getRetryCount() == taskDef.getRetryCount() && this.getTimeoutSeconds() == taskDef.getTimeoutSeconds() && this.getRetryDelaySeconds() == taskDef.getRetryDelaySeconds() && this.getBackoffScaleFactor() == taskDef.getBackoffScaleFactor() && this.getResponseTimeoutSeconds() == taskDef.getResponseTimeoutSeconds() && Objects.equals(this.getName(), taskDef.getName()) && Objects.equals(this.getDescription(), taskDef.getDescription()) && Objects.equals(this.getInputKeys(), taskDef.getInputKeys()) && Objects.equals(this.getOutputKeys(), taskDef.getOutputKeys()) && this.getTimeoutPolicy() == taskDef.getTimeoutPolicy() && this.getRetryLogic() == taskDef.getRetryLogic() && Objects.equals(this.getConcurrentExecLimit(), taskDef.getConcurrentExecLimit()) && Objects.equals(this.getRateLimitPerFrequency(), taskDef.getRateLimitPerFrequency()) && Objects.equals(this.getInputTemplate(), taskDef.getInputTemplate()) && Objects.equals(this.getIsolationGroupId(), taskDef.getIsolationGroupId()) && Objects.equals(this.getExecutionNameSpace(), taskDef.getExecutionNameSpace()) && Objects.equals(this.getOwnerEmail(), taskDef.getOwnerEmail()) && Objects.equals(this.getBaseType(), taskDef.getBaseType()) && Objects.equals(this.getInputSchema(), taskDef.getInputSchema()) && Objects.equals(this.getOutputSchema(), taskDef.getOutputSchema()) && Objects.equals(this.getTotalTimeoutSeconds(), taskDef.getTotalTimeoutSeconds());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getRetryCount(), this.getTimeoutSeconds(), this.getInputKeys(), this.getOutputKeys(), this.getTimeoutPolicy(), this.getRetryLogic(), this.getRetryDelaySeconds(), this.getBackoffScaleFactor(), this.getResponseTimeoutSeconds(), this.getConcurrentExecLimit(), this.getRateLimitPerFrequency(), this.getInputTemplate(), this.getIsolationGroupId(), this.getExecutionNameSpace(), this.getOwnerEmail(), this.getBaseType(), this.getInputSchema(), this.getOutputSchema(), this.getTotalTimeoutSeconds()});
    }

    private static int $default$retryCount() {
        return 3;
    }

    private static List<String> $default$inputKeys() {
        return new ArrayList<String>();
    }

    private static List<String> $default$outputKeys() {
        return new ArrayList<String>();
    }

    private static TimeoutPolicy $default$timeoutPolicy() {
        return TimeoutPolicy.TIME_OUT_WF;
    }

    private static RetryLogic $default$retryLogic() {
        return RetryLogic.FIXED;
    }

    private static int $default$retryDelaySeconds() {
        return 60;
    }

    private static long $default$responseTimeoutSeconds() {
        return 3600L;
    }

    private static Map<String, Object> $default$inputTemplate() {
        return new HashMap<String, Object>();
    }

    private static Integer $default$backoffScaleFactor() {
        return 1;
    }

    public static TaskDefBuilder builder() {
        return new TaskDefBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    public List<String> getOutputKeys() {
        return this.outputKeys;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public RetryLogic getRetryLogic() {
        return this.retryLogic;
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public Integer getConcurrentExecLimit() {
        return this.concurrentExecLimit;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public Integer getPollTimeoutSeconds() {
        return this.pollTimeoutSeconds;
    }

    public Integer getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public long getTotalTimeoutSeconds() {
        return this.totalTimeoutSeconds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public void setOutputKeys(List<String> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setRetryLogic(RetryLogic retryLogic) {
        this.retryLogic = retryLogic;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setConcurrentExecLimit(Integer concurrentExecLimit) {
        this.concurrentExecLimit = concurrentExecLimit;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public void setRateLimitPerFrequency(Integer rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public void setRateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setPollTimeoutSeconds(Integer pollTimeoutSeconds) {
        this.pollTimeoutSeconds = pollTimeoutSeconds;
    }

    public void setBackoffScaleFactor(Integer backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public void setTotalTimeoutSeconds(long totalTimeoutSeconds) {
        this.totalTimeoutSeconds = totalTimeoutSeconds;
    }

    public TaskDef() {
        this.retryCount = TaskDef.$default$retryCount();
        this.inputKeys = TaskDef.$default$inputKeys();
        this.outputKeys = TaskDef.$default$outputKeys();
        this.timeoutPolicy = TaskDef.$default$timeoutPolicy();
        this.retryLogic = TaskDef.$default$retryLogic();
        this.retryDelaySeconds = TaskDef.$default$retryDelaySeconds();
        this.responseTimeoutSeconds = TaskDef.$default$responseTimeoutSeconds();
        this.inputTemplate = TaskDef.$default$inputTemplate();
        this.backoffScaleFactor = TaskDef.$default$backoffScaleFactor();
    }

    private TaskDef(String name, String description, int retryCount, long timeoutSeconds, List<String> inputKeys, List<String> outputKeys, TimeoutPolicy timeoutPolicy, RetryLogic retryLogic, int retryDelaySeconds, long responseTimeoutSeconds, Integer concurrentExecLimit, Map<String, Object> inputTemplate, Integer rateLimitPerFrequency, Integer rateLimitFrequencyInSeconds, String isolationGroupId, String executionNameSpace, String ownerEmail, Integer pollTimeoutSeconds, Integer backoffScaleFactor, String baseType, SchemaDef inputSchema, SchemaDef outputSchema, boolean enforceSchema, long totalTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.inputKeys = inputKeys;
        this.outputKeys = outputKeys;
        this.timeoutPolicy = timeoutPolicy;
        this.retryLogic = retryLogic;
        this.retryDelaySeconds = retryDelaySeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.concurrentExecLimit = concurrentExecLimit;
        this.inputTemplate = inputTemplate;
        this.rateLimitPerFrequency = rateLimitPerFrequency;
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
        this.isolationGroupId = isolationGroupId;
        this.executionNameSpace = executionNameSpace;
        this.ownerEmail = ownerEmail;
        this.pollTimeoutSeconds = pollTimeoutSeconds;
        this.backoffScaleFactor = backoffScaleFactor;
        this.baseType = baseType;
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.enforceSchema = enforceSchema;
        this.totalTimeoutSeconds = totalTimeoutSeconds;
    }

    public static enum TimeoutPolicy {
        RETRY,
        TIME_OUT_WF,
        ALERT_ONLY;

    }

    public static enum RetryLogic {
        FIXED,
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF;

    }

    public static class TaskDefBuilder {
        private String name;
        private String description;
        private boolean retryCount$set;
        private int retryCount$value;
        private long timeoutSeconds;
        private boolean inputKeys$set;
        private List<String> inputKeys$value;
        private boolean outputKeys$set;
        private List<String> outputKeys$value;
        private boolean timeoutPolicy$set;
        private TimeoutPolicy timeoutPolicy$value;
        private boolean retryLogic$set;
        private RetryLogic retryLogic$value;
        private boolean retryDelaySeconds$set;
        private int retryDelaySeconds$value;
        private boolean responseTimeoutSeconds$set;
        private long responseTimeoutSeconds$value;
        private Integer concurrentExecLimit;
        private boolean inputTemplate$set;
        private Map<String, Object> inputTemplate$value;
        private Integer rateLimitPerFrequency;
        private Integer rateLimitFrequencyInSeconds;
        private String isolationGroupId;
        private String executionNameSpace;
        private String ownerEmail;
        private Integer pollTimeoutSeconds;
        private boolean backoffScaleFactor$set;
        private Integer backoffScaleFactor$value;
        private String baseType;
        private SchemaDef inputSchema;
        private SchemaDef outputSchema;
        private boolean enforceSchema;
        private long totalTimeoutSeconds;

        TaskDefBuilder() {
        }

        public TaskDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TaskDefBuilder retryCount(int retryCount) {
            this.retryCount$value = retryCount;
            this.retryCount$set = true;
            return this;
        }

        public TaskDefBuilder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public TaskDefBuilder inputKeys(List<String> inputKeys) {
            this.inputKeys$value = inputKeys;
            this.inputKeys$set = true;
            return this;
        }

        public TaskDefBuilder outputKeys(List<String> outputKeys) {
            this.outputKeys$value = outputKeys;
            this.outputKeys$set = true;
            return this;
        }

        public TaskDefBuilder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy$value = timeoutPolicy;
            this.timeoutPolicy$set = true;
            return this;
        }

        public TaskDefBuilder retryLogic(RetryLogic retryLogic) {
            this.retryLogic$value = retryLogic;
            this.retryLogic$set = true;
            return this;
        }

        public TaskDefBuilder retryDelaySeconds(int retryDelaySeconds) {
            this.retryDelaySeconds$value = retryDelaySeconds;
            this.retryDelaySeconds$set = true;
            return this;
        }

        public TaskDefBuilder responseTimeoutSeconds(long responseTimeoutSeconds) {
            this.responseTimeoutSeconds$value = responseTimeoutSeconds;
            this.responseTimeoutSeconds$set = true;
            return this;
        }

        public TaskDefBuilder concurrentExecLimit(Integer concurrentExecLimit) {
            this.concurrentExecLimit = concurrentExecLimit;
            return this;
        }

        public TaskDefBuilder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate$value = inputTemplate;
            this.inputTemplate$set = true;
            return this;
        }

        public TaskDefBuilder rateLimitPerFrequency(Integer rateLimitPerFrequency) {
            this.rateLimitPerFrequency = rateLimitPerFrequency;
            return this;
        }

        public TaskDefBuilder rateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
            this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
            return this;
        }

        public TaskDefBuilder isolationGroupId(String isolationGroupId) {
            this.isolationGroupId = isolationGroupId;
            return this;
        }

        public TaskDefBuilder executionNameSpace(String executionNameSpace) {
            this.executionNameSpace = executionNameSpace;
            return this;
        }

        public TaskDefBuilder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public TaskDefBuilder pollTimeoutSeconds(Integer pollTimeoutSeconds) {
            this.pollTimeoutSeconds = pollTimeoutSeconds;
            return this;
        }

        public TaskDefBuilder backoffScaleFactor(Integer backoffScaleFactor) {
            this.backoffScaleFactor$value = backoffScaleFactor;
            this.backoffScaleFactor$set = true;
            return this;
        }

        public TaskDefBuilder baseType(String baseType) {
            this.baseType = baseType;
            return this;
        }

        public TaskDefBuilder inputSchema(SchemaDef inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public TaskDefBuilder outputSchema(SchemaDef outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public TaskDefBuilder enforceSchema(boolean enforceSchema) {
            this.enforceSchema = enforceSchema;
            return this;
        }

        public TaskDefBuilder totalTimeoutSeconds(long totalTimeoutSeconds) {
            this.totalTimeoutSeconds = totalTimeoutSeconds;
            return this;
        }

        public TaskDef build() {
            int retryCount$value = this.retryCount$value;
            if (!this.retryCount$set) {
                retryCount$value = TaskDef.$default$retryCount();
            }
            List<String> inputKeys$value = this.inputKeys$value;
            if (!this.inputKeys$set) {
                inputKeys$value = TaskDef.$default$inputKeys();
            }
            List<String> outputKeys$value = this.outputKeys$value;
            if (!this.outputKeys$set) {
                outputKeys$value = TaskDef.$default$outputKeys();
            }
            TimeoutPolicy timeoutPolicy$value = this.timeoutPolicy$value;
            if (!this.timeoutPolicy$set) {
                timeoutPolicy$value = TaskDef.$default$timeoutPolicy();
            }
            RetryLogic retryLogic$value = this.retryLogic$value;
            if (!this.retryLogic$set) {
                retryLogic$value = TaskDef.$default$retryLogic();
            }
            int retryDelaySeconds$value = this.retryDelaySeconds$value;
            if (!this.retryDelaySeconds$set) {
                retryDelaySeconds$value = TaskDef.$default$retryDelaySeconds();
            }
            long responseTimeoutSeconds$value = this.responseTimeoutSeconds$value;
            if (!this.responseTimeoutSeconds$set) {
                responseTimeoutSeconds$value = TaskDef.$default$responseTimeoutSeconds();
            }
            Map<String, Object> inputTemplate$value = this.inputTemplate$value;
            if (!this.inputTemplate$set) {
                inputTemplate$value = TaskDef.$default$inputTemplate();
            }
            Integer backoffScaleFactor$value = this.backoffScaleFactor$value;
            if (!this.backoffScaleFactor$set) {
                backoffScaleFactor$value = TaskDef.$default$backoffScaleFactor();
            }
            return new TaskDef(this.name, this.description, retryCount$value, this.timeoutSeconds, inputKeys$value, outputKeys$value, timeoutPolicy$value, retryLogic$value, retryDelaySeconds$value, responseTimeoutSeconds$value, this.concurrentExecLimit, inputTemplate$value, this.rateLimitPerFrequency, this.rateLimitFrequencyInSeconds, this.isolationGroupId, this.executionNameSpace, this.ownerEmail, this.pollTimeoutSeconds, backoffScaleFactor$value, this.baseType, this.inputSchema, this.outputSchema, this.enforceSchema, this.totalTimeoutSeconds);
        }

        public String toString() {
            return "TaskDef.TaskDefBuilder(name=" + this.name + ", description=" + this.description + ", retryCount$value=" + this.retryCount$value + ", timeoutSeconds=" + this.timeoutSeconds + ", inputKeys$value=" + String.valueOf(this.inputKeys$value) + ", outputKeys$value=" + String.valueOf(this.outputKeys$value) + ", timeoutPolicy$value=" + String.valueOf((Object)this.timeoutPolicy$value) + ", retryLogic$value=" + String.valueOf((Object)this.retryLogic$value) + ", retryDelaySeconds$value=" + this.retryDelaySeconds$value + ", responseTimeoutSeconds$value=" + this.responseTimeoutSeconds$value + ", concurrentExecLimit=" + this.concurrentExecLimit + ", inputTemplate$value=" + String.valueOf(this.inputTemplate$value) + ", rateLimitPerFrequency=" + this.rateLimitPerFrequency + ", rateLimitFrequencyInSeconds=" + this.rateLimitFrequencyInSeconds + ", isolationGroupId=" + this.isolationGroupId + ", executionNameSpace=" + this.executionNameSpace + ", ownerEmail=" + this.ownerEmail + ", pollTimeoutSeconds=" + this.pollTimeoutSeconds + ", backoffScaleFactor$value=" + this.backoffScaleFactor$value + ", baseType=" + this.baseType + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + ", totalTimeoutSeconds=" + this.totalTimeoutSeconds + ")";
        }
    }
}

