/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.RateLimitConfig;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowDef
extends Auditable {
    private String name;
    private String description;
    private int version;
    private List<WorkflowTask> tasks;
    private List<String> inputParameters;
    private Map<String, Object> outputParameters;
    private String failureWorkflow;
    private int schemaVersion;
    private boolean restartable;
    private boolean workflowStatusListenerEnabled;
    private String ownerEmail;
    private TimeoutPolicy timeoutPolicy;
    private long timeoutSeconds;
    private Map<String, Object> variables;
    private Map<String, Object> inputTemplate;
    private String workflowStatusListenerSink;
    private RateLimitConfig rateLimitConfig;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema;
    private Map<String, Object> metadata;

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public boolean containsType(String taskType) {
        return this.collectTasks().stream().anyMatch(t -> t.getType().equals(taskType));
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        WorkflowTask task;
        WorkflowTask workflowTask = this.getTaskByRefName(taskReferenceName);
        if (workflowTask != null && TaskType.TERMINATE.name().equals(workflowTask.getType())) {
            return null;
        }
        Iterator<WorkflowTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (TaskType.DO_WHILE.name().equals(task.getType()) && !task.getTaskReferenceName().equals(taskReferenceName) && task.has(taskReferenceName)) {
                return null;
            }
            if (!task.has(taskReferenceName)) continue;
            break;
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        return this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst().orElse(null);
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        for (WorkflowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDef that = (WorkflowDef)o;
        return this.version == that.version && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    @Override
    public String toString() {
        return "WorkflowDef{name='" + this.name + "', description='" + this.description + "', version=" + this.version + ", tasks=" + String.valueOf(this.tasks) + ", inputParameters=" + String.valueOf(this.inputParameters) + ", outputParameters=" + String.valueOf(this.outputParameters) + ", failureWorkflow='" + this.failureWorkflow + "', schemaVersion=" + this.schemaVersion + ", restartable=" + this.restartable + ", workflowStatusListenerEnabled=" + this.workflowStatusListenerEnabled + ", ownerEmail='" + this.ownerEmail + "', timeoutPolicy=" + String.valueOf((Object)this.timeoutPolicy) + ", timeoutSeconds=" + this.timeoutSeconds + ", variables=" + String.valueOf(this.variables) + ", inputTemplate=" + String.valueOf(this.inputTemplate) + ", workflowStatusListenerSink='" + this.workflowStatusListenerSink + "', rateLimitConfig=" + String.valueOf(this.rateLimitConfig) + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    private static int $default$version() {
        return 1;
    }

    private static List<WorkflowTask> $default$tasks() {
        return new LinkedList<WorkflowTask>();
    }

    private static List<String> $default$inputParameters() {
        return new LinkedList<String>();
    }

    private static Map<String, Object> $default$outputParameters() {
        return new HashMap<String, Object>();
    }

    private static int $default$schemaVersion() {
        return 2;
    }

    private static boolean $default$restartable() {
        return true;
    }

    private static boolean $default$workflowStatusListenerEnabled() {
        return false;
    }

    private static TimeoutPolicy $default$timeoutPolicy() {
        return TimeoutPolicy.ALERT_ONLY;
    }

    private static Map<String, Object> $default$variables() {
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> $default$inputTemplate() {
        return new HashMap<String, Object>();
    }

    private static boolean $default$enforceSchema() {
        return true;
    }

    private static Map<String, Object> $default$metadata() {
        return new HashMap<String, Object>();
    }

    public static WorkflowDefBuilder builder() {
        return new WorkflowDefBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public List<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isWorkflowStatusListenerEnabled() {
        return this.workflowStatusListenerEnabled;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public String getWorkflowStatusListenerSink() {
        return this.workflowStatusListenerSink;
    }

    public RateLimitConfig getRateLimitConfig() {
        return this.rateLimitConfig;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTasks(List<WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setWorkflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public void setWorkflowStatusListenerSink(String workflowStatusListenerSink) {
        this.workflowStatusListenerSink = workflowStatusListenerSink;
    }

    public void setRateLimitConfig(RateLimitConfig rateLimitConfig) {
        this.rateLimitConfig = rateLimitConfig;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public WorkflowDef() {
        this.version = WorkflowDef.$default$version();
        this.tasks = WorkflowDef.$default$tasks();
        this.inputParameters = WorkflowDef.$default$inputParameters();
        this.outputParameters = WorkflowDef.$default$outputParameters();
        this.schemaVersion = WorkflowDef.$default$schemaVersion();
        this.restartable = WorkflowDef.$default$restartable();
        this.workflowStatusListenerEnabled = WorkflowDef.$default$workflowStatusListenerEnabled();
        this.timeoutPolicy = WorkflowDef.$default$timeoutPolicy();
        this.variables = WorkflowDef.$default$variables();
        this.inputTemplate = WorkflowDef.$default$inputTemplate();
        this.enforceSchema = WorkflowDef.$default$enforceSchema();
        this.metadata = WorkflowDef.$default$metadata();
    }

    private WorkflowDef(String name, String description, int version, List<WorkflowTask> tasks, List<String> inputParameters, Map<String, Object> outputParameters, String failureWorkflow, int schemaVersion, boolean restartable, boolean workflowStatusListenerEnabled, String ownerEmail, TimeoutPolicy timeoutPolicy, long timeoutSeconds, Map<String, Object> variables, Map<String, Object> inputTemplate, String workflowStatusListenerSink, RateLimitConfig rateLimitConfig, SchemaDef inputSchema, SchemaDef outputSchema, boolean enforceSchema, Map<String, Object> metadata) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.tasks = tasks;
        this.inputParameters = inputParameters;
        this.outputParameters = outputParameters;
        this.failureWorkflow = failureWorkflow;
        this.schemaVersion = schemaVersion;
        this.restartable = restartable;
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
        this.ownerEmail = ownerEmail;
        this.timeoutPolicy = timeoutPolicy;
        this.timeoutSeconds = timeoutSeconds;
        this.variables = variables;
        this.inputTemplate = inputTemplate;
        this.workflowStatusListenerSink = workflowStatusListenerSink;
        this.rateLimitConfig = rateLimitConfig;
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.enforceSchema = enforceSchema;
        this.metadata = metadata;
    }

    public static enum TimeoutPolicy {
        TIME_OUT_WF,
        ALERT_ONLY;

    }

    public static class WorkflowDefBuilder {
        private String name;
        private String description;
        private boolean version$set;
        private int version$value;
        private boolean tasks$set;
        private List<WorkflowTask> tasks$value;
        private boolean inputParameters$set;
        private List<String> inputParameters$value;
        private boolean outputParameters$set;
        private Map<String, Object> outputParameters$value;
        private String failureWorkflow;
        private boolean schemaVersion$set;
        private int schemaVersion$value;
        private boolean restartable$set;
        private boolean restartable$value;
        private boolean workflowStatusListenerEnabled$set;
        private boolean workflowStatusListenerEnabled$value;
        private String ownerEmail;
        private boolean timeoutPolicy$set;
        private TimeoutPolicy timeoutPolicy$value;
        private long timeoutSeconds;
        private boolean variables$set;
        private Map<String, Object> variables$value;
        private boolean inputTemplate$set;
        private Map<String, Object> inputTemplate$value;
        private String workflowStatusListenerSink;
        private RateLimitConfig rateLimitConfig;
        private SchemaDef inputSchema;
        private SchemaDef outputSchema;
        private boolean enforceSchema$set;
        private boolean enforceSchema$value;
        private boolean metadata$set;
        private Map<String, Object> metadata$value;

        WorkflowDefBuilder() {
        }

        public WorkflowDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkflowDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WorkflowDefBuilder version(int version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public WorkflowDefBuilder tasks(List<WorkflowTask> tasks) {
            this.tasks$value = tasks;
            this.tasks$set = true;
            return this;
        }

        public WorkflowDefBuilder inputParameters(List<String> inputParameters) {
            this.inputParameters$value = inputParameters;
            this.inputParameters$set = true;
            return this;
        }

        public WorkflowDefBuilder outputParameters(Map<String, Object> outputParameters) {
            this.outputParameters$value = outputParameters;
            this.outputParameters$set = true;
            return this;
        }

        public WorkflowDefBuilder failureWorkflow(String failureWorkflow) {
            this.failureWorkflow = failureWorkflow;
            return this;
        }

        public WorkflowDefBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion$value = schemaVersion;
            this.schemaVersion$set = true;
            return this;
        }

        public WorkflowDefBuilder restartable(boolean restartable) {
            this.restartable$value = restartable;
            this.restartable$set = true;
            return this;
        }

        public WorkflowDefBuilder workflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
            this.workflowStatusListenerEnabled$value = workflowStatusListenerEnabled;
            this.workflowStatusListenerEnabled$set = true;
            return this;
        }

        public WorkflowDefBuilder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public WorkflowDefBuilder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy$value = timeoutPolicy;
            this.timeoutPolicy$set = true;
            return this;
        }

        public WorkflowDefBuilder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public WorkflowDefBuilder variables(Map<String, Object> variables) {
            this.variables$value = variables;
            this.variables$set = true;
            return this;
        }

        public WorkflowDefBuilder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate$value = inputTemplate;
            this.inputTemplate$set = true;
            return this;
        }

        public WorkflowDefBuilder workflowStatusListenerSink(String workflowStatusListenerSink) {
            this.workflowStatusListenerSink = workflowStatusListenerSink;
            return this;
        }

        public WorkflowDefBuilder rateLimitConfig(RateLimitConfig rateLimitConfig) {
            this.rateLimitConfig = rateLimitConfig;
            return this;
        }

        public WorkflowDefBuilder inputSchema(SchemaDef inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public WorkflowDefBuilder outputSchema(SchemaDef outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public WorkflowDefBuilder enforceSchema(boolean enforceSchema) {
            this.enforceSchema$value = enforceSchema;
            this.enforceSchema$set = true;
            return this;
        }

        public WorkflowDefBuilder metadata(Map<String, Object> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        public WorkflowDef build() {
            int version$value = this.version$value;
            if (!this.version$set) {
                version$value = WorkflowDef.$default$version();
            }
            List<WorkflowTask> tasks$value = this.tasks$value;
            if (!this.tasks$set) {
                tasks$value = WorkflowDef.$default$tasks();
            }
            List<String> inputParameters$value = this.inputParameters$value;
            if (!this.inputParameters$set) {
                inputParameters$value = WorkflowDef.$default$inputParameters();
            }
            Map<String, Object> outputParameters$value = this.outputParameters$value;
            if (!this.outputParameters$set) {
                outputParameters$value = WorkflowDef.$default$outputParameters();
            }
            int schemaVersion$value = this.schemaVersion$value;
            if (!this.schemaVersion$set) {
                schemaVersion$value = WorkflowDef.$default$schemaVersion();
            }
            boolean restartable$value = this.restartable$value;
            if (!this.restartable$set) {
                restartable$value = WorkflowDef.$default$restartable();
            }
            boolean workflowStatusListenerEnabled$value = this.workflowStatusListenerEnabled$value;
            if (!this.workflowStatusListenerEnabled$set) {
                workflowStatusListenerEnabled$value = WorkflowDef.$default$workflowStatusListenerEnabled();
            }
            TimeoutPolicy timeoutPolicy$value = this.timeoutPolicy$value;
            if (!this.timeoutPolicy$set) {
                timeoutPolicy$value = WorkflowDef.$default$timeoutPolicy();
            }
            Map<String, Object> variables$value = this.variables$value;
            if (!this.variables$set) {
                variables$value = WorkflowDef.$default$variables();
            }
            Map<String, Object> inputTemplate$value = this.inputTemplate$value;
            if (!this.inputTemplate$set) {
                inputTemplate$value = WorkflowDef.$default$inputTemplate();
            }
            boolean enforceSchema$value = this.enforceSchema$value;
            if (!this.enforceSchema$set) {
                enforceSchema$value = WorkflowDef.$default$enforceSchema();
            }
            Map<String, Object> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = WorkflowDef.$default$metadata();
            }
            return new WorkflowDef(this.name, this.description, version$value, tasks$value, inputParameters$value, outputParameters$value, this.failureWorkflow, schemaVersion$value, restartable$value, workflowStatusListenerEnabled$value, this.ownerEmail, timeoutPolicy$value, this.timeoutSeconds, variables$value, inputTemplate$value, this.workflowStatusListenerSink, this.rateLimitConfig, this.inputSchema, this.outputSchema, enforceSchema$value, metadata$value);
        }

        public String toString() {
            return "WorkflowDef.WorkflowDefBuilder(name=" + this.name + ", description=" + this.description + ", version$value=" + this.version$value + ", tasks$value=" + String.valueOf(this.tasks$value) + ", inputParameters$value=" + String.valueOf(this.inputParameters$value) + ", outputParameters$value=" + String.valueOf(this.outputParameters$value) + ", failureWorkflow=" + this.failureWorkflow + ", schemaVersion$value=" + this.schemaVersion$value + ", restartable$value=" + this.restartable$value + ", workflowStatusListenerEnabled$value=" + this.workflowStatusListenerEnabled$value + ", ownerEmail=" + this.ownerEmail + ", timeoutPolicy$value=" + String.valueOf((Object)this.timeoutPolicy$value) + ", timeoutSeconds=" + this.timeoutSeconds + ", variables$value=" + String.valueOf(this.variables$value) + ", inputTemplate$value=" + String.valueOf(this.inputTemplate$value) + ", workflowStatusListenerSink=" + this.workflowStatusListenerSink + ", rateLimitConfig=" + String.valueOf(this.rateLimitConfig) + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema$value=" + this.enforceSchema$value + ", metadata$value=" + String.valueOf(this.metadata$value) + ")";
        }
    }
}

