/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkResponse<T> {
    private Map<String, String> bulkErrorResults;
    private List<T> bulkSuccessfulResults;
    private String message;

    public BulkResponse() {
        this.bulkSuccessfulResults = new ArrayList<T>();
        this.bulkErrorResults = new HashMap<String, String>();
    }

    public void appendSuccessResponse(T result) {
        this.bulkSuccessfulResults.add(result);
    }

    public void appendFailedResponse(String id, String errorMessage) {
        this.bulkErrorResults.put(id, errorMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkResponse)) {
            return false;
        }
        BulkResponse that = (BulkResponse)o;
        return Objects.equals(this.bulkSuccessfulResults, that.bulkSuccessfulResults) && Objects.equals(this.bulkErrorResults, that.bulkErrorResults);
    }

    public int hashCode() {
        return Objects.hash(this.bulkSuccessfulResults, this.bulkErrorResults, this.message);
    }

    public String toString() {
        return "BulkResponse{bulkSuccessfulResults=" + String.valueOf(this.bulkSuccessfulResults) + ", bulkErrorResults=" + String.valueOf(this.bulkErrorResults) + ", message='" + this.message + "'}";
    }

    private static <T> String $default$message() {
        return "Bulk Request has been processed.";
    }

    public static <T> BulkResponseBuilder<T> builder() {
        return new BulkResponseBuilder();
    }

    public Map<String, String> getBulkErrorResults() {
        return this.bulkErrorResults;
    }

    public List<T> getBulkSuccessfulResults() {
        return this.bulkSuccessfulResults;
    }

    public String getMessage() {
        return this.message;
    }

    public void setBulkErrorResults(Map<String, String> bulkErrorResults) {
        this.bulkErrorResults = bulkErrorResults;
    }

    public void setBulkSuccessfulResults(List<T> bulkSuccessfulResults) {
        this.bulkSuccessfulResults = bulkSuccessfulResults;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private BulkResponse(Map<String, String> bulkErrorResults, List<T> bulkSuccessfulResults, String message) {
        this.bulkErrorResults = bulkErrorResults;
        this.bulkSuccessfulResults = bulkSuccessfulResults;
        this.message = message;
    }

    public static class BulkResponseBuilder<T> {
        private Map<String, String> bulkErrorResults;
        private List<T> bulkSuccessfulResults;
        private boolean message$set;
        private String message$value;

        BulkResponseBuilder() {
        }

        public BulkResponseBuilder<T> bulkErrorResults(Map<String, String> bulkErrorResults) {
            this.bulkErrorResults = bulkErrorResults;
            return this;
        }

        public BulkResponseBuilder<T> bulkSuccessfulResults(List<T> bulkSuccessfulResults) {
            this.bulkSuccessfulResults = bulkSuccessfulResults;
            return this;
        }

        public BulkResponseBuilder<T> message(String message) {
            this.message$value = message;
            this.message$set = true;
            return this;
        }

        public BulkResponse<T> build() {
            String message$value = this.message$value;
            if (!this.message$set) {
                message$value = BulkResponse.$default$message();
            }
            return new BulkResponse<T>(this.bulkErrorResults, this.bulkSuccessfulResults, message$value);
        }

        public String toString() {
            return "BulkResponse.BulkResponseBuilder(bulkErrorResults=" + String.valueOf(this.bulkErrorResults) + ", bulkSuccessfulResults=" + String.valueOf(this.bulkSuccessfulResults) + ", message$value=" + this.message$value + ")";
        }
    }
}

