/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.common.metadata.events.EventHandler;
import java.util.List;
import org.apache.commons.lang3.Validate;

public final class EventClient {
    private ConductorClient client;

    public EventClient() {
    }

    public EventClient(ConductorClient client) {
        this.client = client;
    }

    @Deprecated
    public void setRootURI(String rootUri) {
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = new ConductorClient(rootUri);
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Validate.notNull(eventHandler, "Event Handler definition cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/event").body(eventHandler).build();
        this.client.execute(request);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Validate.notNull(eventHandler, "Event Handler definition cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/event").body(eventHandler).build();
        this.client.execute(request);
    }

    public List<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Validate.notBlank(event, "Event cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/event/{name}").addPathParam("name", event).addQueryParam("activeOnly", activeOnly).build();
        ConductorClientResponse<List<EventHandler>> resp = this.client.execute(request, new TypeReference<List<EventHandler>>(){});
        return resp.getData();
    }

    public void unregisterEventHandler(String name) {
        Validate.notBlank(name, "Event handler name cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/event/{name}").addPathParam("name", name).build();
        this.client.execute(request);
    }
}

