/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.events;

import com.netflix.conductor.common.metadata.events.EventHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EventExecution {
    private String id;
    private String messageId;
    private String name;
    private String event;
    private long created;
    private Status status;
    private EventHandler.Action.Type action;
    private Map<String, Object> output;

    public EventExecution(String id, String messageId) {
        this.id = id;
        this.messageId = messageId;
        this.output = new HashMap<String, Object>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventExecution execution = (EventExecution)o;
        return this.created == execution.created && Objects.equals(this.id, execution.id) && Objects.equals(this.messageId, execution.messageId) && Objects.equals(this.name, execution.name) && Objects.equals(this.event, execution.event) && this.status == execution.status && this.action == execution.action && Objects.equals(this.output, execution.output);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.messageId, this.name, this.event, this.created, this.status, this.action, this.output});
    }

    private static Map<String, Object> $default$output() {
        return new HashMap<String, Object>();
    }

    public static EventExecutionBuilder builder() {
        return new EventExecutionBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getName() {
        return this.name;
    }

    public String getEvent() {
        return this.event;
    }

    public long getCreated() {
        return this.created;
    }

    public Status getStatus() {
        return this.status;
    }

    public EventHandler.Action.Type getAction() {
        return this.action;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setAction(EventHandler.Action.Type action) {
        this.action = action;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public String toString() {
        return "EventExecution(id=" + this.getId() + ", messageId=" + this.getMessageId() + ", name=" + this.getName() + ", event=" + this.getEvent() + ", created=" + this.getCreated() + ", status=" + String.valueOf((Object)this.getStatus()) + ", action=" + String.valueOf((Object)this.getAction()) + ", output=" + String.valueOf(this.getOutput()) + ")";
    }

    public EventExecution() {
        this.output = EventExecution.$default$output();
    }

    private EventExecution(String id, String messageId, String name, String event, long created, Status status, EventHandler.Action.Type action, Map<String, Object> output) {
        this.id = id;
        this.messageId = messageId;
        this.name = name;
        this.event = event;
        this.created = created;
        this.status = status;
        this.action = action;
        this.output = output;
    }

    public static enum Status {
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        SKIPPED;

    }

    public static class EventExecutionBuilder {
        private String id;
        private String messageId;
        private String name;
        private String event;
        private long created;
        private Status status;
        private EventHandler.Action.Type action;
        private boolean output$set;
        private Map<String, Object> output$value;

        EventExecutionBuilder() {
        }

        public EventExecutionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EventExecutionBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public EventExecutionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EventExecutionBuilder event(String event) {
            this.event = event;
            return this;
        }

        public EventExecutionBuilder created(long created) {
            this.created = created;
            return this;
        }

        public EventExecutionBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public EventExecutionBuilder action(EventHandler.Action.Type action) {
            this.action = action;
            return this;
        }

        public EventExecutionBuilder output(Map<String, Object> output) {
            this.output$value = output;
            this.output$set = true;
            return this;
        }

        public EventExecution build() {
            Map<String, Object> output$value = this.output$value;
            if (!this.output$set) {
                output$value = EventExecution.$default$output();
            }
            return new EventExecution(this.id, this.messageId, this.name, this.event, this.created, this.status, this.action, output$value);
        }

        public String toString() {
            return "EventExecution.EventExecutionBuilder(id=" + this.id + ", messageId=" + this.messageId + ", name=" + this.name + ", event=" + this.event + ", created=" + this.created + ", status=" + String.valueOf((Object)this.status) + ", action=" + String.valueOf((Object)this.action) + ", output$value=" + String.valueOf(this.output$value) + ")";
        }
    }
}

