/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.linker;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import jdk.dynalink.CallSiteDescriptor;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.openjdk.nashorn.api.scripting.ClassFilter;
import org.openjdk.nashorn.internal.objects.Global;
import org.openjdk.nashorn.internal.runtime.Context;
import org.openjdk.nashorn.internal.runtime.ECMAErrors;
import org.openjdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;

final class ReflectionCheckLinker
implements TypeBasedGuardingDynamicLinker {
    private static final Class<?> STATEMENT_CLASS = ReflectionCheckLinker.getBeanClass("Statement");
    private static final Class<?> XMLENCODER_CLASS = ReflectionCheckLinker.getBeanClass("XMLEncoder");
    private static final Class<?> XMLDECODER_CLASS = ReflectionCheckLinker.getBeanClass("XMLDecoder");

    ReflectionCheckLinker() {
    }

    private static Class<?> getBeanClass(String name) {
        try {
            return Class.forName("java.beans." + name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public boolean canLinkType(Class<?> type2) {
        return ReflectionCheckLinker.isReflectionClass(type2);
    }

    private static boolean isReflectionClass(Class<?> type2) {
        if (type2 == Class.class || ClassLoader.class.isAssignableFrom(type2)) {
            return true;
        }
        if (STATEMENT_CLASS != null && STATEMENT_CLASS.isAssignableFrom(type2) || XMLENCODER_CLASS != null && XMLENCODER_CLASS.isAssignableFrom(type2) || XMLDECODER_CLASS != null && XMLDECODER_CLASS.isAssignableFrom(type2)) {
            return true;
        }
        String name = type2.getName();
        return name.startsWith("java.lang.reflect.") || name.startsWith("java.lang.invoke.");
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest origRequest, LinkerServices linkerServices) {
        ReflectionCheckLinker.checkLinkRequest(origRequest);
        return null;
    }

    private static boolean isReflectiveCheckNeeded(Class<?> type2, boolean isStatic) {
        if (Proxy.class.isAssignableFrom(type2)) {
            if (Proxy.isProxyClass(type2)) {
                return isStatic;
            }
            return true;
        }
        return ReflectionCheckLinker.isReflectionClass(type2);
    }

    static void checkReflectionAccess(Class<?> clazz, boolean isStatic) {
        Global global = Context.getGlobal();
        ClassFilter cf = global.getClassFilter();
        if (cf != null && ReflectionCheckLinker.isReflectiveCheckNeeded(clazz, isStatic)) {
            throw ECMAErrors.typeError("no.reflection.with.classfilter", new String[0]);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && ReflectionCheckLinker.isReflectiveCheckNeeded(clazz, isStatic)) {
            ReflectionCheckLinker.checkReflectionPermission(sm);
        }
    }

    private static void checkLinkRequest(LinkRequest request) {
        Global global = Context.getGlobal();
        ClassFilter cf = global.getClassFilter();
        if (cf != null) {
            throw ECMAErrors.typeError("no.reflection.with.classfilter", new String[0]);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            CallSiteDescriptor desc;
            Object self = request.getReceiver();
            if (self instanceof Class && Modifier.isPublic(((Class)self).getModifiers()) && "static".equals(NashornCallSiteDescriptor.getOperand(desc = request.getCallSiteDescriptor())) && NashornCallSiteDescriptor.contains(desc, StandardOperation.GET, StandardNamespace.PROPERTY) && Context.isAccessibleClass((Class)self) && !ReflectionCheckLinker.isReflectionClass((Class)self)) {
                return;
            }
            ReflectionCheckLinker.checkReflectionPermission(sm);
        }
    }

    private static void checkReflectionPermission(SecurityManager sm) {
        sm.checkPermission(new RuntimePermission("nashorn.JavaReflection"));
    }
}

