/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import java.util.Objects;

public class WorkflowDefSummary
implements Comparable<WorkflowDefSummary> {
    private String name;
    private int version;
    private Long createTime;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDefSummary that = (WorkflowDefSummary)o;
        return this.getVersion() == that.getVersion() && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getVersion());
    }

    public String toString() {
        return "WorkflowDef{name='" + this.name + ", version=" + this.version + "}";
    }

    @Override
    public int compareTo(WorkflowDefSummary o) {
        int res = this.name.compareTo(o.name);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.version, o.version);
        return res;
    }

    private static int $default$version() {
        return 1;
    }

    public static WorkflowDefSummaryBuilder builder() {
        return new WorkflowDefSummaryBuilder();
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public WorkflowDefSummary() {
        this.version = WorkflowDefSummary.$default$version();
    }

    private WorkflowDefSummary(String name, int version, Long createTime) {
        this.name = name;
        this.version = version;
        this.createTime = createTime;
    }

    public static class WorkflowDefSummaryBuilder {
        private String name;
        private boolean version$set;
        private int version$value;
        private Long createTime;

        WorkflowDefSummaryBuilder() {
        }

        public WorkflowDefSummaryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkflowDefSummaryBuilder version(int version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public WorkflowDefSummaryBuilder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public WorkflowDefSummary build() {
            int version$value = this.version$value;
            if (!this.version$set) {
                version$value = WorkflowDefSummary.$default$version();
            }
            return new WorkflowDefSummary(this.name, version$value, this.createTime);
        }

        public String toString() {
            return "WorkflowDefSummary.WorkflowDefSummaryBuilder(name=" + this.name + ", version$value=" + this.version$value + ", createTime=" + this.createTime + ")";
        }
    }
}

