/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Workflow
extends Auditable {
    private WorkflowStatus status;
    private long endTime;
    private String workflowId;
    private String parentWorkflowId;
    private String parentWorkflowTaskId;
    private List<Task> tasks;
    private Map<String, Object> input;
    private Map<String, Object> output;
    private String correlationId;
    private String reRunFromWorkflowId;
    private String reasonForIncompletion;
    private String event;
    private Map<String, String> taskToDomain;
    private Set<String> failedReferenceTaskNames;
    private WorkflowDef workflowDefinition;
    private String externalInputPayloadStoragePath;
    private String externalOutputPayloadStoragePath;
    private int priority;
    private Map<String, Object> variables;
    private long lastRetriedTime;
    private Set<String> failedTaskNames;
    private List<Workflow> history;
    private String idempotencyKey;
    private String rateLimitKey;
    private boolean rateLimited;

    public long getStartTime() {
        return this.getCreateTime();
    }

    public void setStartTime(long startTime) {
        this.setCreateTime(startTime);
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        if (input == null) {
            input = new HashMap<String, Object>();
        }
        this.input = input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setOutput(Map<String, Object> output) {
        if (output == null) {
            output = new HashMap<String, Object>();
        }
        this.output = output;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("priority MUST be between 0 and 99 (inclusive)");
        }
        this.priority = priority;
    }

    public String getWorkflowName() {
        if (this.workflowDefinition == null) {
            throw new NullPointerException("Workflow definition is null");
        }
        return this.workflowDefinition.getName();
    }

    public int getWorkflowVersion() {
        if (this.workflowDefinition == null) {
            throw new NullPointerException("Workflow definition is null");
        }
        return this.workflowDefinition.getVersion();
    }

    public boolean hasParent() {
        return StringUtils.isNotEmpty((CharSequence)this.parentWorkflowId);
    }

    public Task getTaskByRefName(String refName) {
        if (refName == null) {
            throw new RuntimeException("refName passed is null.  Check the workflow execution.  For dynamic tasks, make sure referenceTaskName is set to a not null value");
        }
        LinkedList<Task> found = new LinkedList<Task>();
        for (Task t : this.tasks) {
            if (t.getReferenceTaskName() == null) {
                throw new RuntimeException("Task " + t.getTaskDefName() + ", seq=" + t.getSeq() + " does not have reference name specified.");
            }
            if (!t.getReferenceTaskName().equals(refName)) continue;
            found.add(t);
        }
        if (found.isEmpty()) {
            return null;
        }
        return (Task)found.getLast();
    }

    public Workflow copy() {
        Workflow copy = new Workflow();
        copy.setInput(this.input);
        copy.setOutput(this.output);
        copy.setStatus(this.status);
        copy.setWorkflowId(this.workflowId);
        copy.setParentWorkflowId(this.parentWorkflowId);
        copy.setParentWorkflowTaskId(this.parentWorkflowTaskId);
        copy.setReRunFromWorkflowId(this.reRunFromWorkflowId);
        copy.setCorrelationId(this.correlationId);
        copy.setEvent(this.event);
        copy.setReasonForIncompletion(this.reasonForIncompletion);
        copy.setWorkflowDefinition(this.workflowDefinition);
        copy.setPriority(this.priority);
        copy.setTasks(this.tasks.stream().map(Task::deepCopy).collect(Collectors.toList()));
        copy.setVariables(this.variables);
        copy.setEndTime(this.endTime);
        copy.setLastRetriedTime(this.lastRetriedTime);
        copy.setTaskToDomain(this.taskToDomain);
        copy.setFailedReferenceTaskNames(this.failedReferenceTaskNames);
        copy.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
        copy.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        return copy;
    }

    @Override
    public String toString() {
        String name = this.workflowDefinition != null ? this.workflowDefinition.getName() : null;
        Integer version = this.workflowDefinition != null ? Integer.valueOf(this.workflowDefinition.getVersion()) : null;
        return String.format("%s.%s/%s.%s", new Object[]{name, version, this.workflowId, this.status});
    }

    public String toShortString() {
        String name = this.workflowDefinition != null ? this.workflowDefinition.getName() : null;
        Integer version = this.workflowDefinition != null ? Integer.valueOf(this.workflowDefinition.getVersion()) : null;
        return String.format("%s.%s/%s", name, version, this.workflowId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals(this.getWorkflowId(), workflow.getWorkflowId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getWorkflowId());
    }

    private static WorkflowStatus $default$status() {
        return WorkflowStatus.RUNNING;
    }

    private static List<Task> $default$tasks() {
        return new LinkedList<Task>();
    }

    private static Map<String, Object> $default$input() {
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> $default$output() {
        return new HashMap<String, Object>();
    }

    private static Map<String, String> $default$taskToDomain() {
        return new HashMap<String, String>();
    }

    private static Set<String> $default$failedReferenceTaskNames() {
        return new HashSet<String>();
    }

    private static Map<String, Object> $default$variables() {
        return new HashMap<String, Object>();
    }

    private static Set<String> $default$failedTaskNames() {
        return new HashSet<String>();
    }

    private static List<Workflow> $default$history() {
        return new LinkedList<Workflow>();
    }

    public static WorkflowBuilder builder() {
        return new WorkflowBuilder();
    }

    public WorkflowStatus getStatus() {
        return this.status;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getParentWorkflowId() {
        return this.parentWorkflowId;
    }

    public String getParentWorkflowTaskId() {
        return this.parentWorkflowTaskId;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getReRunFromWorkflowId() {
        return this.reRunFromWorkflowId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public String getEvent() {
        return this.event;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public Set<String> getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public WorkflowDef getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public long getLastRetriedTime() {
        return this.lastRetriedTime;
    }

    public Set<String> getFailedTaskNames() {
        return this.failedTaskNames;
    }

    public List<Workflow> getHistory() {
        return this.history;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public String getRateLimitKey() {
        return this.rateLimitKey;
    }

    public boolean isRateLimited() {
        return this.rateLimited;
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setParentWorkflowId(String parentWorkflowId) {
        this.parentWorkflowId = parentWorkflowId;
    }

    public void setParentWorkflowTaskId(String parentWorkflowTaskId) {
        this.parentWorkflowTaskId = parentWorkflowTaskId;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setReRunFromWorkflowId(String reRunFromWorkflowId) {
        this.reRunFromWorkflowId = reRunFromWorkflowId;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public void setFailedReferenceTaskNames(Set<String> failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public void setWorkflowDefinition(WorkflowDef workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setLastRetriedTime(long lastRetriedTime) {
        this.lastRetriedTime = lastRetriedTime;
    }

    public void setFailedTaskNames(Set<String> failedTaskNames) {
        this.failedTaskNames = failedTaskNames;
    }

    public void setHistory(List<Workflow> history) {
        this.history = history;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public void setRateLimitKey(String rateLimitKey) {
        this.rateLimitKey = rateLimitKey;
    }

    public void setRateLimited(boolean rateLimited) {
        this.rateLimited = rateLimited;
    }

    public Workflow() {
        this.status = Workflow.$default$status();
        this.tasks = Workflow.$default$tasks();
        this.input = Workflow.$default$input();
        this.output = Workflow.$default$output();
        this.taskToDomain = Workflow.$default$taskToDomain();
        this.failedReferenceTaskNames = Workflow.$default$failedReferenceTaskNames();
        this.variables = Workflow.$default$variables();
        this.failedTaskNames = Workflow.$default$failedTaskNames();
        this.history = Workflow.$default$history();
    }

    private Workflow(WorkflowStatus status, long endTime, String workflowId, String parentWorkflowId, String parentWorkflowTaskId, List<Task> tasks, Map<String, Object> input, Map<String, Object> output, String correlationId, String reRunFromWorkflowId, String reasonForIncompletion, String event, Map<String, String> taskToDomain, Set<String> failedReferenceTaskNames, WorkflowDef workflowDefinition, String externalInputPayloadStoragePath, String externalOutputPayloadStoragePath, int priority, Map<String, Object> variables, long lastRetriedTime, Set<String> failedTaskNames, List<Workflow> history, String idempotencyKey, String rateLimitKey, boolean rateLimited) {
        this.status = status;
        this.endTime = endTime;
        this.workflowId = workflowId;
        this.parentWorkflowId = parentWorkflowId;
        this.parentWorkflowTaskId = parentWorkflowTaskId;
        this.tasks = tasks;
        this.input = input;
        this.output = output;
        this.correlationId = correlationId;
        this.reRunFromWorkflowId = reRunFromWorkflowId;
        this.reasonForIncompletion = reasonForIncompletion;
        this.event = event;
        this.taskToDomain = taskToDomain;
        this.failedReferenceTaskNames = failedReferenceTaskNames;
        this.workflowDefinition = workflowDefinition;
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
        this.priority = priority;
        this.variables = variables;
        this.lastRetriedTime = lastRetriedTime;
        this.failedTaskNames = failedTaskNames;
        this.history = history;
        this.idempotencyKey = idempotencyKey;
        this.rateLimitKey = rateLimitKey;
        this.rateLimited = rateLimited;
    }

    public static enum WorkflowStatus {
        RUNNING(false, false),
        COMPLETED(true, true),
        FAILED(true, false),
        TIMED_OUT(true, false),
        TERMINATED(true, false),
        PAUSED(false, true);

        private final boolean terminal;
        private final boolean successful;

        private WorkflowStatus(boolean terminal, boolean successful) {
            this.terminal = terminal;
            this.successful = successful;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }

    public static class WorkflowBuilder {
        private boolean status$set;
        private WorkflowStatus status$value;
        private long endTime;
        private String workflowId;
        private String parentWorkflowId;
        private String parentWorkflowTaskId;
        private boolean tasks$set;
        private List<Task> tasks$value;
        private boolean input$set;
        private Map<String, Object> input$value;
        private boolean output$set;
        private Map<String, Object> output$value;
        private String correlationId;
        private String reRunFromWorkflowId;
        private String reasonForIncompletion;
        private String event;
        private boolean taskToDomain$set;
        private Map<String, String> taskToDomain$value;
        private boolean failedReferenceTaskNames$set;
        private Set<String> failedReferenceTaskNames$value;
        private WorkflowDef workflowDefinition;
        private String externalInputPayloadStoragePath;
        private String externalOutputPayloadStoragePath;
        private int priority;
        private boolean variables$set;
        private Map<String, Object> variables$value;
        private long lastRetriedTime;
        private boolean failedTaskNames$set;
        private Set<String> failedTaskNames$value;
        private boolean history$set;
        private List<Workflow> history$value;
        private String idempotencyKey;
        private String rateLimitKey;
        private boolean rateLimited;

        WorkflowBuilder() {
        }

        public WorkflowBuilder status(WorkflowStatus status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        public WorkflowBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public WorkflowBuilder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public WorkflowBuilder parentWorkflowId(String parentWorkflowId) {
            this.parentWorkflowId = parentWorkflowId;
            return this;
        }

        public WorkflowBuilder parentWorkflowTaskId(String parentWorkflowTaskId) {
            this.parentWorkflowTaskId = parentWorkflowTaskId;
            return this;
        }

        public WorkflowBuilder tasks(List<Task> tasks) {
            this.tasks$value = tasks;
            this.tasks$set = true;
            return this;
        }

        public WorkflowBuilder input(Map<String, Object> input) {
            this.input$value = input;
            this.input$set = true;
            return this;
        }

        public WorkflowBuilder output(Map<String, Object> output) {
            this.output$value = output;
            this.output$set = true;
            return this;
        }

        public WorkflowBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public WorkflowBuilder reRunFromWorkflowId(String reRunFromWorkflowId) {
            this.reRunFromWorkflowId = reRunFromWorkflowId;
            return this;
        }

        public WorkflowBuilder reasonForIncompletion(String reasonForIncompletion) {
            this.reasonForIncompletion = reasonForIncompletion;
            return this;
        }

        public WorkflowBuilder event(String event) {
            this.event = event;
            return this;
        }

        public WorkflowBuilder taskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain$value = taskToDomain;
            this.taskToDomain$set = true;
            return this;
        }

        public WorkflowBuilder failedReferenceTaskNames(Set<String> failedReferenceTaskNames) {
            this.failedReferenceTaskNames$value = failedReferenceTaskNames;
            this.failedReferenceTaskNames$set = true;
            return this;
        }

        public WorkflowBuilder workflowDefinition(WorkflowDef workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
            return this;
        }

        public WorkflowBuilder externalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
            this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
            return this;
        }

        public WorkflowBuilder externalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
            this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
            return this;
        }

        public WorkflowBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public WorkflowBuilder variables(Map<String, Object> variables) {
            this.variables$value = variables;
            this.variables$set = true;
            return this;
        }

        public WorkflowBuilder lastRetriedTime(long lastRetriedTime) {
            this.lastRetriedTime = lastRetriedTime;
            return this;
        }

        public WorkflowBuilder failedTaskNames(Set<String> failedTaskNames) {
            this.failedTaskNames$value = failedTaskNames;
            this.failedTaskNames$set = true;
            return this;
        }

        public WorkflowBuilder history(List<Workflow> history) {
            this.history$value = history;
            this.history$set = true;
            return this;
        }

        public WorkflowBuilder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public WorkflowBuilder rateLimitKey(String rateLimitKey) {
            this.rateLimitKey = rateLimitKey;
            return this;
        }

        public WorkflowBuilder rateLimited(boolean rateLimited) {
            this.rateLimited = rateLimited;
            return this;
        }

        public Workflow build() {
            WorkflowStatus status$value = this.status$value;
            if (!this.status$set) {
                status$value = Workflow.$default$status();
            }
            List<Task> tasks$value = this.tasks$value;
            if (!this.tasks$set) {
                tasks$value = Workflow.$default$tasks();
            }
            Map<String, Object> input$value = this.input$value;
            if (!this.input$set) {
                input$value = Workflow.$default$input();
            }
            Map<String, Object> output$value = this.output$value;
            if (!this.output$set) {
                output$value = Workflow.$default$output();
            }
            Map<String, String> taskToDomain$value = this.taskToDomain$value;
            if (!this.taskToDomain$set) {
                taskToDomain$value = Workflow.$default$taskToDomain();
            }
            Set<String> failedReferenceTaskNames$value = this.failedReferenceTaskNames$value;
            if (!this.failedReferenceTaskNames$set) {
                failedReferenceTaskNames$value = Workflow.$default$failedReferenceTaskNames();
            }
            Map<String, Object> variables$value = this.variables$value;
            if (!this.variables$set) {
                variables$value = Workflow.$default$variables();
            }
            Set<String> failedTaskNames$value = this.failedTaskNames$value;
            if (!this.failedTaskNames$set) {
                failedTaskNames$value = Workflow.$default$failedTaskNames();
            }
            List<Workflow> history$value = this.history$value;
            if (!this.history$set) {
                history$value = Workflow.$default$history();
            }
            return new Workflow(status$value, this.endTime, this.workflowId, this.parentWorkflowId, this.parentWorkflowTaskId, tasks$value, input$value, output$value, this.correlationId, this.reRunFromWorkflowId, this.reasonForIncompletion, this.event, taskToDomain$value, failedReferenceTaskNames$value, this.workflowDefinition, this.externalInputPayloadStoragePath, this.externalOutputPayloadStoragePath, this.priority, variables$value, this.lastRetriedTime, failedTaskNames$value, history$value, this.idempotencyKey, this.rateLimitKey, this.rateLimited);
        }

        public String toString() {
            return "Workflow.WorkflowBuilder(status$value=" + String.valueOf((Object)this.status$value) + ", endTime=" + this.endTime + ", workflowId=" + this.workflowId + ", parentWorkflowId=" + this.parentWorkflowId + ", parentWorkflowTaskId=" + this.parentWorkflowTaskId + ", tasks$value=" + String.valueOf(this.tasks$value) + ", input$value=" + String.valueOf(this.input$value) + ", output$value=" + String.valueOf(this.output$value) + ", correlationId=" + this.correlationId + ", reRunFromWorkflowId=" + this.reRunFromWorkflowId + ", reasonForIncompletion=" + this.reasonForIncompletion + ", event=" + this.event + ", taskToDomain$value=" + String.valueOf(this.taskToDomain$value) + ", failedReferenceTaskNames$value=" + String.valueOf(this.failedReferenceTaskNames$value) + ", workflowDefinition=" + String.valueOf(this.workflowDefinition) + ", externalInputPayloadStoragePath=" + this.externalInputPayloadStoragePath + ", externalOutputPayloadStoragePath=" + this.externalOutputPayloadStoragePath + ", priority=" + this.priority + ", variables$value=" + String.valueOf(this.variables$value) + ", lastRetriedTime=" + this.lastRetriedTime + ", failedTaskNames$value=" + String.valueOf(this.failedTaskNames$value) + ", history$value=" + String.valueOf(this.history$value) + ", idempotencyKey=" + this.idempotencyKey + ", rateLimitKey=" + this.rateLimitKey + ", rateLimited=" + this.rateLimited + ")";
        }
    }
}

