/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.utils.SummaryUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WorkflowSummary {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private String workflowType;
    private int version;
    private String workflowId;
    private String correlationId;
    private String startTime;
    private String updateTime;
    private String endTime;
    private Workflow.WorkflowStatus status;
    private String input;
    private String output;
    private String reasonForIncompletion;
    private long executionTime;
    private String event;
    private String failedReferenceTaskNames;
    private String externalInputPayloadStoragePath;
    private String externalOutputPayloadStoragePath;
    private int priority;
    private Set<String> failedTaskNames;
    private String createdBy;
    private Map<String, String> taskToDomain;

    public WorkflowSummary(Workflow workflow) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(GMT);
        this.workflowType = workflow.getWorkflowName();
        this.version = workflow.getWorkflowVersion();
        this.workflowId = workflow.getWorkflowId();
        this.priority = workflow.getPriority();
        this.correlationId = workflow.getCorrelationId();
        if (workflow.getCreateTime() != null) {
            this.startTime = sdf.format(new Date(workflow.getCreateTime()));
        }
        if (workflow.getEndTime() > 0L) {
            this.endTime = sdf.format(new Date(workflow.getEndTime()));
        }
        if (workflow.getUpdateTime() != null) {
            this.updateTime = sdf.format(new Date(workflow.getUpdateTime()));
        }
        this.status = workflow.getStatus();
        if (workflow.getInput() != null) {
            this.input = SummaryUtil.serializeInputOutput(workflow.getInput());
        }
        if (workflow.getOutput() != null) {
            this.output = SummaryUtil.serializeInputOutput(workflow.getOutput());
        }
        this.reasonForIncompletion = workflow.getReasonForIncompletion();
        if (workflow.getEndTime() > 0L) {
            this.executionTime = workflow.getEndTime() - workflow.getStartTime();
        }
        this.event = workflow.getEvent();
        this.failedReferenceTaskNames = workflow.getFailedReferenceTaskNames().stream().collect(Collectors.joining(","));
        this.failedTaskNames = workflow.getFailedTaskNames();
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalInputPayloadStoragePath())) {
            this.externalInputPayloadStoragePath = workflow.getExternalInputPayloadStoragePath();
        }
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalOutputPayloadStoragePath())) {
            this.externalOutputPayloadStoragePath = workflow.getExternalOutputPayloadStoragePath();
        }
        if (workflow.getTaskToDomain() != null) {
            this.taskToDomain = workflow.getTaskToDomain();
        }
        this.createdBy = workflow.getCreatedBy();
    }

    public long getInputSize() {
        return this.input != null ? (long)this.input.length() : 0L;
    }

    public long getOutputSize() {
        return this.output != null ? (long)this.output.length() : 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSummary that = (WorkflowSummary)o;
        return this.getVersion() == that.getVersion() && this.getExecutionTime() == that.getExecutionTime() && this.getPriority() == that.getPriority() && this.getWorkflowType().equals(that.getWorkflowType()) && this.getWorkflowId().equals(that.getWorkflowId()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && StringUtils.equals((CharSequence)this.getStartTime(), (CharSequence)that.getStartTime()) && StringUtils.equals((CharSequence)this.getUpdateTime(), (CharSequence)that.getUpdateTime()) && StringUtils.equals((CharSequence)this.getEndTime(), (CharSequence)that.getEndTime()) && this.getStatus() == that.getStatus() && Objects.equals(this.getReasonForIncompletion(), that.getReasonForIncompletion()) && Objects.equals(this.getEvent(), that.getEvent()) && Objects.equals(this.getCreatedBy(), that.getCreatedBy()) && Objects.equals(this.getTaskToDomain(), that.getTaskToDomain());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getWorkflowType(), this.getVersion(), this.getWorkflowId(), this.getCorrelationId(), this.getStartTime(), this.getUpdateTime(), this.getEndTime(), this.getStatus(), this.getReasonForIncompletion(), this.getExecutionTime(), this.getEvent(), this.getPriority(), this.getCreatedBy(), this.getTaskToDomain()});
    }

    private static String $default$failedReferenceTaskNames() {
        return "";
    }

    private static Set<String> $default$failedTaskNames() {
        return new HashSet<String>();
    }

    private static Map<String, String> $default$taskToDomain() {
        return new HashMap<String, String>();
    }

    public static WorkflowSummaryBuilder builder() {
        return new WorkflowSummaryBuilder();
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Workflow.WorkflowStatus getStatus() {
        return this.status;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getEvent() {
        return this.event;
    }

    public String getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getFailedTaskNames() {
        return this.failedTaskNames;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Workflow.WorkflowStatus status) {
        this.status = status;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setFailedReferenceTaskNames(String failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setFailedTaskNames(Set<String> failedTaskNames) {
        this.failedTaskNames = failedTaskNames;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public String toString() {
        return "WorkflowSummary(workflowType=" + this.getWorkflowType() + ", version=" + this.getVersion() + ", workflowId=" + this.getWorkflowId() + ", correlationId=" + this.getCorrelationId() + ", startTime=" + this.getStartTime() + ", updateTime=" + this.getUpdateTime() + ", endTime=" + this.getEndTime() + ", status=" + String.valueOf((Object)this.getStatus()) + ", input=" + this.getInput() + ", output=" + this.getOutput() + ", reasonForIncompletion=" + this.getReasonForIncompletion() + ", executionTime=" + this.getExecutionTime() + ", event=" + this.getEvent() + ", failedReferenceTaskNames=" + this.getFailedReferenceTaskNames() + ", externalInputPayloadStoragePath=" + this.getExternalInputPayloadStoragePath() + ", externalOutputPayloadStoragePath=" + this.getExternalOutputPayloadStoragePath() + ", priority=" + this.getPriority() + ", failedTaskNames=" + String.valueOf(this.getFailedTaskNames()) + ", createdBy=" + this.getCreatedBy() + ", taskToDomain=" + String.valueOf(this.getTaskToDomain()) + ")";
    }

    public WorkflowSummary() {
        this.failedReferenceTaskNames = WorkflowSummary.$default$failedReferenceTaskNames();
        this.failedTaskNames = WorkflowSummary.$default$failedTaskNames();
        this.taskToDomain = WorkflowSummary.$default$taskToDomain();
    }

    private WorkflowSummary(String workflowType, int version, String workflowId, String correlationId, String startTime, String updateTime, String endTime, Workflow.WorkflowStatus status, String input, String output, String reasonForIncompletion, long executionTime, String event, String failedReferenceTaskNames, String externalInputPayloadStoragePath, String externalOutputPayloadStoragePath, int priority, Set<String> failedTaskNames, String createdBy, Map<String, String> taskToDomain) {
        this.workflowType = workflowType;
        this.version = version;
        this.workflowId = workflowId;
        this.correlationId = correlationId;
        this.startTime = startTime;
        this.updateTime = updateTime;
        this.endTime = endTime;
        this.status = status;
        this.input = input;
        this.output = output;
        this.reasonForIncompletion = reasonForIncompletion;
        this.executionTime = executionTime;
        this.event = event;
        this.failedReferenceTaskNames = failedReferenceTaskNames;
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
        this.priority = priority;
        this.failedTaskNames = failedTaskNames;
        this.createdBy = createdBy;
        this.taskToDomain = taskToDomain;
    }

    public static class WorkflowSummaryBuilder {
        private String workflowType;
        private int version;
        private String workflowId;
        private String correlationId;
        private String startTime;
        private String updateTime;
        private String endTime;
        private Workflow.WorkflowStatus status;
        private String input;
        private String output;
        private String reasonForIncompletion;
        private long executionTime;
        private String event;
        private boolean failedReferenceTaskNames$set;
        private String failedReferenceTaskNames$value;
        private String externalInputPayloadStoragePath;
        private String externalOutputPayloadStoragePath;
        private int priority;
        private boolean failedTaskNames$set;
        private Set<String> failedTaskNames$value;
        private String createdBy;
        private boolean taskToDomain$set;
        private Map<String, String> taskToDomain$value;

        WorkflowSummaryBuilder() {
        }

        public WorkflowSummaryBuilder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public WorkflowSummaryBuilder version(int version) {
            this.version = version;
            return this;
        }

        public WorkflowSummaryBuilder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public WorkflowSummaryBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public WorkflowSummaryBuilder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public WorkflowSummaryBuilder updateTime(String updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public WorkflowSummaryBuilder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public WorkflowSummaryBuilder status(Workflow.WorkflowStatus status) {
            this.status = status;
            return this;
        }

        public WorkflowSummaryBuilder input(String input) {
            this.input = input;
            return this;
        }

        public WorkflowSummaryBuilder output(String output) {
            this.output = output;
            return this;
        }

        public WorkflowSummaryBuilder reasonForIncompletion(String reasonForIncompletion) {
            this.reasonForIncompletion = reasonForIncompletion;
            return this;
        }

        public WorkflowSummaryBuilder executionTime(long executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public WorkflowSummaryBuilder event(String event) {
            this.event = event;
            return this;
        }

        public WorkflowSummaryBuilder failedReferenceTaskNames(String failedReferenceTaskNames) {
            this.failedReferenceTaskNames$value = failedReferenceTaskNames;
            this.failedReferenceTaskNames$set = true;
            return this;
        }

        public WorkflowSummaryBuilder externalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
            this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
            return this;
        }

        public WorkflowSummaryBuilder externalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
            this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
            return this;
        }

        public WorkflowSummaryBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public WorkflowSummaryBuilder failedTaskNames(Set<String> failedTaskNames) {
            this.failedTaskNames$value = failedTaskNames;
            this.failedTaskNames$set = true;
            return this;
        }

        public WorkflowSummaryBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WorkflowSummaryBuilder taskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain$value = taskToDomain;
            this.taskToDomain$set = true;
            return this;
        }

        public WorkflowSummary build() {
            String failedReferenceTaskNames$value = this.failedReferenceTaskNames$value;
            if (!this.failedReferenceTaskNames$set) {
                failedReferenceTaskNames$value = WorkflowSummary.$default$failedReferenceTaskNames();
            }
            Set<String> failedTaskNames$value = this.failedTaskNames$value;
            if (!this.failedTaskNames$set) {
                failedTaskNames$value = WorkflowSummary.$default$failedTaskNames();
            }
            Map<String, String> taskToDomain$value = this.taskToDomain$value;
            if (!this.taskToDomain$set) {
                taskToDomain$value = WorkflowSummary.$default$taskToDomain();
            }
            return new WorkflowSummary(this.workflowType, this.version, this.workflowId, this.correlationId, this.startTime, this.updateTime, this.endTime, this.status, this.input, this.output, this.reasonForIncompletion, this.executionTime, this.event, failedReferenceTaskNames$value, this.externalInputPayloadStoragePath, this.externalOutputPayloadStoragePath, this.priority, failedTaskNames$value, this.createdBy, taskToDomain$value);
        }

        public String toString() {
            return "WorkflowSummary.WorkflowSummaryBuilder(workflowType=" + this.workflowType + ", version=" + this.version + ", workflowId=" + this.workflowId + ", correlationId=" + this.correlationId + ", startTime=" + this.startTime + ", updateTime=" + this.updateTime + ", endTime=" + this.endTime + ", status=" + String.valueOf((Object)this.status) + ", input=" + this.input + ", output=" + this.output + ", reasonForIncompletion=" + this.reasonForIncompletion + ", executionTime=" + this.executionTime + ", event=" + this.event + ", failedReferenceTaskNames$value=" + this.failedReferenceTaskNames$value + ", externalInputPayloadStoragePath=" + this.externalInputPayloadStoragePath + ", externalOutputPayloadStoragePath=" + this.externalOutputPayloadStoragePath + ", priority=" + this.priority + ", failedTaskNames$value=" + String.valueOf(this.failedTaskNames$value) + ", createdBy=" + this.createdBy + ", taskToDomain$value=" + String.valueOf(this.taskToDomain$value) + ")";
        }
    }
}

