/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.exception;

import com.netflix.conductor.common.validation.ValidationError;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConductorClientException
extends RuntimeException {
    private int status;
    private String instance;
    private String code;
    private boolean retryable;
    private List<ValidationError> validationErrors;
    private Map<String, List<String>> responseHeaders;
    private String responseBody;

    public ConductorClientException(String message) {
        super(message);
        this.responseBody = message;
    }

    public ConductorClientException(int statusCode, String message) {
        super(message);
        this.status = statusCode;
        this.responseBody = message;
    }

    public ConductorClientException(Throwable t2) {
        super(t2.getMessage(), t2);
        this.responseBody = t2.getMessage();
    }

    public ConductorClientException(String message, Throwable t2) {
        super(message, t2);
        this.responseBody = message;
    }

    public ConductorClientException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ConductorClientException(String message, Throwable t2, int code, Map<String, List<String>> responseHeaders) {
        this(message, t2, code, responseHeaders, message);
    }

    public ConductorClientException(String message, Throwable t2, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, t2);
        this.code = String.valueOf(code);
        this.status = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public boolean isClientError() {
        return this.getStatus() > 399 && this.getStatus() < 499;
    }

    public int getStatusCode() {
        return this.getStatus();
    }

    @Override
    public String getMessage() {
        return StringUtils.isNotBlank(super.getMessage()) ? super.getMessage() : this.responseBody;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(": ");
        if (this.getMessage() != null) {
            builder.append(this.getMessage());
        }
        if (this.status > 0) {
            builder.append(" {status=").append(this.status);
            if (this.code != null) {
                builder.append(", code='").append(this.code).append("'");
            }
            builder.append(", retryable: ").append(this.retryable);
        }
        if (this.instance != null) {
            builder.append(", instance: ").append(this.instance);
        }
        if (this.validationErrors != null) {
            builder.append(", validationErrors: ").append(this.validationErrors);
        }
        builder.append("}");
        return builder.toString();
    }

    public int getStatus() {
        return this.status;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConductorClientException)) {
            return false;
        }
        ConductorClientException other = (ConductorClientException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.isRetryable() != other.isRetryable()) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<ValidationError> this$validationErrors = this.getValidationErrors();
        List<ValidationError> other$validationErrors = other.getValidationErrors();
        if (this$validationErrors == null ? other$validationErrors != null : !((Object)this$validationErrors).equals(other$validationErrors)) {
            return false;
        }
        Map<String, List<String>> this$responseHeaders = this.getResponseHeaders();
        Map<String, List<String>> other$responseHeaders = other.getResponseHeaders();
        if (this$responseHeaders == null ? other$responseHeaders != null : !((Object)this$responseHeaders).equals(other$responseHeaders)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        return !(this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConductorClientException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getStatus();
        result2 = result2 * 59 + (this.isRetryable() ? 79 : 97);
        String $instance = this.getInstance();
        result2 = result2 * 59 + ($instance == null ? 43 : $instance.hashCode());
        String $code = this.getCode();
        result2 = result2 * 59 + ($code == null ? 43 : $code.hashCode());
        List<ValidationError> $validationErrors = this.getValidationErrors();
        result2 = result2 * 59 + ($validationErrors == null ? 43 : ((Object)$validationErrors).hashCode());
        Map<String, List<String>> $responseHeaders = this.getResponseHeaders();
        result2 = result2 * 59 + ($responseHeaders == null ? 43 : ((Object)$responseHeaders).hashCode());
        String $responseBody = this.getResponseBody();
        result2 = result2 * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        return result2;
    }

    public void setRetryable(boolean retryable) {
        this.retryable = retryable;
    }
}

