/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.regexp.joni;

import org.openjdk.nashorn.internal.runtime.regexp.joni.EncodingHelper;
import org.openjdk.nashorn.internal.runtime.regexp.joni.Regex;

public abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "NONE";
        }

        @Override
        public final int search(Regex regex, char[] text, int textP, int textEnd, int textRange) {
            return textP;
        }

        @Override
        public final int searchBackward(Regex regex, char[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return textP;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT";
        }

        @Override
        public final int search(Regex regex, char[] text, int textP, int textEnd, int textRange) {
            char[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t2;
                if (text[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t2 = targetP + 1; t2 < targetEnd && target[t2] == text[p++]; ++t2) {
                }
                if (t2 != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Regex regex, char[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            char[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t2;
                    int p = s2 + 1;
                    for (t2 = targetP + 1; t2 < targetEnd && target[t2] == text[p++]; ++t2) {
                    }
                    if (t2 == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        @Override
        public final String getName() {
            return "EXACT_BM";
        }

        @Override
        public final int search(Regex regex, char[] text, int textP, int textEnd, int textRange) {
            int s2;
            char[] target = regex.exact;
            int targetEnd = regex.exactEnd;
            int targetP = regex.exactP;
            int end = textRange + (targetEnd - targetP) - 1;
            if (end > textEnd) {
                end = textEnd;
            }
            int tail = targetEnd - 1;
            if (regex.intMap == null) {
                for (s2 = textP + (targetEnd - targetP) - 1; s2 < end; s2 += regex.map[text[s2] & 0xFF]) {
                    int p = s2;
                    int t2 = tail;
                    while (text[p] == target[t2]) {
                        if (t2 == targetP) {
                            return p;
                        }
                        --p;
                        --t2;
                    }
                }
            } else {
                while (s2 < end) {
                    int p = s2;
                    int t3 = tail;
                    while (text[p] == target[t3]) {
                        if (t3 == targetP) {
                            return p;
                        }
                        --p;
                        --t3;
                    }
                    s2 += regex.intMap[text[s2] & 0xFF];
                }
            }
            return -1;
        }

        @Override
        public final int searchBackward(Regex regex, char[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            int s2;
            char[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (s_ - range_ < 100) {
                    return SLOW.searchBackward(regex, text, textP, adjustText, textEnd, textStart, s_, range_);
                }
                this.setBmBackwardSkip(regex, target, targetP, targetEnd);
            }
            if (textStart < (s2 = textEnd - (targetEnd - targetP))) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                int t2;
                int p = s2;
                for (t2 = targetP; t2 < targetEnd && text[p] == target[t2]; ++t2) {
                    ++p;
                }
                if (t2 == targetEnd) {
                    return s2;
                }
                s2 -= regex.intMapBackward[text[s2] & 0xFF];
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, char[] chars, int p, int end) {
            int i;
            int[] skip;
            if (regex.intMapBackward == null) {
                skip = new int[256];
                regex.intMapBackward = skip;
            } else {
                skip = regex.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < 256; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[chars[i] & 0xFF] = i;
            }
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "MAP";
        }

        @Override
        public final int search(Regex regex, char[] text, int textP, int textEnd, int textRange) {
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (text[s2] <= '\u00ff' && map[text[s2]] == 0) continue;
                return s2;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Regex regex, char[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (text[s2] > '\u00ff' || map[text[s2]] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    public abstract String getName();

    public abstract int search(Regex var1, char[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Regex var1, char[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static final class SLOW_IC
    extends SearchAlgorithm {
        public SLOW_IC(Regex regex) {
        }

        @Override
        public final String getName() {
            return "EXACT_IC";
        }

        @Override
        public final int search(Regex regex, char[] text, int textP, int textEnd, int textRange) {
            char[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                if (!SLOW_IC.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd)) continue;
                return s2;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Regex regex, char[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            char[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (SLOW_IC.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd)) {
                    return s2;
                }
                s2 = EncodingHelper.prevCharHead(adjustText, s2);
            }
            return -1;
        }

        private static boolean lowerCaseMatch(char[] t2, int tPp, int tEnd, char[] chars, int pp, int end) {
            int tP = tPp;
            int p = pp;
            while (tP < tEnd) {
                if (t2[tP++] == EncodingHelper.toLowerCase(chars[p++])) continue;
                return false;
            }
            return true;
        }
    }
}

