/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata;

import com.netflix.conductor.common.metadata.Auditable;
import java.util.Map;

public class SchemaDef
extends Auditable {
    private String name;
    private final int version = 1;
    private Type type;
    private Map<String, Object> data;
    private String externalRef;

    public static SchemaDefBuilder builder() {
        return new SchemaDefBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaDef)) {
            return false;
        }
        SchemaDef other = (SchemaDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$externalRef = this.getExternalRef();
        String other$externalRef = other.getExternalRef();
        return !(this$externalRef == null ? other$externalRef != null : !this$externalRef.equals(other$externalRef));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SchemaDef;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVersion();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $externalRef = this.getExternalRef();
        result = result * 59 + ($externalRef == null ? 43 : $externalRef.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    @Override
    public String toString() {
        return "SchemaDef(name=" + this.getName() + ", version=" + this.getVersion() + ", type=" + String.valueOf((Object)this.getType()) + ", data=" + String.valueOf(this.getData()) + ", externalRef=" + this.getExternalRef() + ")";
    }

    public SchemaDef() {
    }

    public SchemaDef(String name, Type type, Map<String, Object> data, String externalRef) {
        this.name = name;
        this.type = type;
        this.data = data;
        this.externalRef = externalRef;
    }

    public static class SchemaDefBuilder {
        private String name;
        private Type type;
        private Map<String, Object> data;
        private String externalRef;

        SchemaDefBuilder() {
        }

        public SchemaDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaDefBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public SchemaDefBuilder data(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public SchemaDefBuilder externalRef(String externalRef) {
            this.externalRef = externalRef;
            return this;
        }

        public SchemaDef build() {
            return new SchemaDef(this.name, this.type, this.data, this.externalRef);
        }

        public String toString() {
            return "SchemaDef.SchemaDefBuilder(name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", data=" + String.valueOf(this.data) + ", externalRef=" + this.externalRef + ")";
        }
    }

    public static enum Type {
        JSON,
        AVRO,
        PROTOBUF;

    }
}

