/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskDef
extends Auditable {
    public static final int ONE_HOUR = 3600;
    private String name;
    private String description;
    private int retryCount = 3;
    private long timeoutSeconds;
    private List<String> inputKeys = new ArrayList<String>();
    private List<String> outputKeys = new ArrayList<String>();
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
    private RetryLogic retryLogic = RetryLogic.FIXED;
    private int retryDelaySeconds = 60;
    private long responseTimeoutSeconds = 3600L;
    private Integer concurrentExecLimit;
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    private Integer rateLimitPerFrequency;
    private Integer rateLimitFrequencyInSeconds;
    private String isolationGroupId;
    private String executionNameSpace;
    private String ownerEmail;
    private Integer pollTimeoutSeconds;
    private Integer backoffScaleFactor = 1;
    private String baseType;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema;
    private long totalTimeoutSeconds;

    public TaskDef(String name) {
        this.name = name;
    }

    public TaskDef(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public TaskDef(String name, String description, int retryCount, long timeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
    }

    public TaskDef(String name, String description, String ownerEmail, int retryCount, long timeoutSeconds, long responseTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.ownerEmail = ownerEmail;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public Integer getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency == null ? 0 : this.rateLimitPerFrequency;
    }

    public Integer getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds == null ? 1 : this.rateLimitFrequencyInSeconds;
    }

    public int concurrencyLimit() {
        return this.concurrentExecLimit == null ? 0 : this.concurrentExecLimit;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDef taskDef = (TaskDef)o;
        return this.getRetryCount() == taskDef.getRetryCount() && this.getTimeoutSeconds() == taskDef.getTimeoutSeconds() && this.getRetryDelaySeconds() == taskDef.getRetryDelaySeconds() && this.getBackoffScaleFactor() == taskDef.getBackoffScaleFactor() && this.getResponseTimeoutSeconds() == taskDef.getResponseTimeoutSeconds() && Objects.equals(this.getName(), taskDef.getName()) && Objects.equals(this.getDescription(), taskDef.getDescription()) && Objects.equals(this.getInputKeys(), taskDef.getInputKeys()) && Objects.equals(this.getOutputKeys(), taskDef.getOutputKeys()) && this.getTimeoutPolicy() == taskDef.getTimeoutPolicy() && this.getRetryLogic() == taskDef.getRetryLogic() && Objects.equals(this.getConcurrentExecLimit(), taskDef.getConcurrentExecLimit()) && Objects.equals(this.getRateLimitPerFrequency(), taskDef.getRateLimitPerFrequency()) && Objects.equals(this.getInputTemplate(), taskDef.getInputTemplate()) && Objects.equals(this.getIsolationGroupId(), taskDef.getIsolationGroupId()) && Objects.equals(this.getExecutionNameSpace(), taskDef.getExecutionNameSpace()) && Objects.equals(this.getOwnerEmail(), taskDef.getOwnerEmail()) && Objects.equals(this.getBaseType(), taskDef.getBaseType()) && Objects.equals(this.getInputSchema(), taskDef.getInputSchema()) && Objects.equals(this.getOutputSchema(), taskDef.getOutputSchema()) && Objects.equals(this.getTotalTimeoutSeconds(), taskDef.getTotalTimeoutSeconds());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getRetryCount(), this.getTimeoutSeconds(), this.getInputKeys(), this.getOutputKeys(), this.getTimeoutPolicy(), this.getRetryLogic(), this.getRetryDelaySeconds(), this.getBackoffScaleFactor(), this.getResponseTimeoutSeconds(), this.getConcurrentExecLimit(), this.getRateLimitPerFrequency(), this.getInputTemplate(), this.getIsolationGroupId(), this.getExecutionNameSpace(), this.getOwnerEmail(), this.getBaseType(), this.getInputSchema(), this.getOutputSchema(), this.getTotalTimeoutSeconds()});
    }

    public static TaskDefBuilder builder() {
        return new TaskDefBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    public List<String> getOutputKeys() {
        return this.outputKeys;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public RetryLogic getRetryLogic() {
        return this.retryLogic;
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public Integer getConcurrentExecLimit() {
        return this.concurrentExecLimit;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public Integer getPollTimeoutSeconds() {
        return this.pollTimeoutSeconds;
    }

    public Integer getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public long getTotalTimeoutSeconds() {
        return this.totalTimeoutSeconds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public void setOutputKeys(List<String> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setRetryLogic(RetryLogic retryLogic) {
        this.retryLogic = retryLogic;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setConcurrentExecLimit(Integer concurrentExecLimit) {
        this.concurrentExecLimit = concurrentExecLimit;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public void setRateLimitPerFrequency(Integer rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public void setRateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setPollTimeoutSeconds(Integer pollTimeoutSeconds) {
        this.pollTimeoutSeconds = pollTimeoutSeconds;
    }

    public void setBackoffScaleFactor(Integer backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public void setTotalTimeoutSeconds(long totalTimeoutSeconds) {
        this.totalTimeoutSeconds = totalTimeoutSeconds;
    }

    public TaskDef() {
    }

    private TaskDef(String name, String description, int retryCount, long timeoutSeconds, List<String> inputKeys, List<String> outputKeys, TimeoutPolicy timeoutPolicy, RetryLogic retryLogic, int retryDelaySeconds, long responseTimeoutSeconds, Integer concurrentExecLimit, Map<String, Object> inputTemplate, Integer rateLimitPerFrequency, Integer rateLimitFrequencyInSeconds, String isolationGroupId, String executionNameSpace, String ownerEmail, Integer pollTimeoutSeconds, Integer backoffScaleFactor, String baseType, SchemaDef inputSchema, SchemaDef outputSchema, boolean enforceSchema, long totalTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.inputKeys = inputKeys;
        this.outputKeys = outputKeys;
        this.timeoutPolicy = timeoutPolicy;
        this.retryLogic = retryLogic;
        this.retryDelaySeconds = retryDelaySeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.concurrentExecLimit = concurrentExecLimit;
        this.inputTemplate = inputTemplate;
        this.rateLimitPerFrequency = rateLimitPerFrequency;
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
        this.isolationGroupId = isolationGroupId;
        this.executionNameSpace = executionNameSpace;
        this.ownerEmail = ownerEmail;
        this.pollTimeoutSeconds = pollTimeoutSeconds;
        this.backoffScaleFactor = backoffScaleFactor;
        this.baseType = baseType;
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.enforceSchema = enforceSchema;
        this.totalTimeoutSeconds = totalTimeoutSeconds;
    }

    public static enum TimeoutPolicy {
        RETRY,
        TIME_OUT_WF,
        ALERT_ONLY;

    }

    public static enum RetryLogic {
        FIXED,
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF;

    }

    public static class TaskDefBuilder {
        private String name;
        private String description;
        private int retryCount;
        private long timeoutSeconds;
        private List<String> inputKeys;
        private List<String> outputKeys;
        private TimeoutPolicy timeoutPolicy;
        private RetryLogic retryLogic;
        private int retryDelaySeconds;
        private long responseTimeoutSeconds;
        private Integer concurrentExecLimit;
        private Map<String, Object> inputTemplate;
        private Integer rateLimitPerFrequency;
        private Integer rateLimitFrequencyInSeconds;
        private String isolationGroupId;
        private String executionNameSpace;
        private String ownerEmail;
        private Integer pollTimeoutSeconds;
        private Integer backoffScaleFactor;
        private String baseType;
        private SchemaDef inputSchema;
        private SchemaDef outputSchema;
        private boolean enforceSchema;
        private long totalTimeoutSeconds;

        TaskDefBuilder() {
        }

        public TaskDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TaskDefBuilder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public TaskDefBuilder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public TaskDefBuilder inputKeys(List<String> inputKeys) {
            this.inputKeys = inputKeys;
            return this;
        }

        public TaskDefBuilder outputKeys(List<String> outputKeys) {
            this.outputKeys = outputKeys;
            return this;
        }

        public TaskDefBuilder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public TaskDefBuilder retryLogic(RetryLogic retryLogic) {
            this.retryLogic = retryLogic;
            return this;
        }

        public TaskDefBuilder retryDelaySeconds(int retryDelaySeconds) {
            this.retryDelaySeconds = retryDelaySeconds;
            return this;
        }

        public TaskDefBuilder responseTimeoutSeconds(long responseTimeoutSeconds) {
            this.responseTimeoutSeconds = responseTimeoutSeconds;
            return this;
        }

        public TaskDefBuilder concurrentExecLimit(Integer concurrentExecLimit) {
            this.concurrentExecLimit = concurrentExecLimit;
            return this;
        }

        public TaskDefBuilder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public TaskDefBuilder rateLimitPerFrequency(Integer rateLimitPerFrequency) {
            this.rateLimitPerFrequency = rateLimitPerFrequency;
            return this;
        }

        public TaskDefBuilder rateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
            this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
            return this;
        }

        public TaskDefBuilder isolationGroupId(String isolationGroupId) {
            this.isolationGroupId = isolationGroupId;
            return this;
        }

        public TaskDefBuilder executionNameSpace(String executionNameSpace) {
            this.executionNameSpace = executionNameSpace;
            return this;
        }

        public TaskDefBuilder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public TaskDefBuilder pollTimeoutSeconds(Integer pollTimeoutSeconds) {
            this.pollTimeoutSeconds = pollTimeoutSeconds;
            return this;
        }

        public TaskDefBuilder backoffScaleFactor(Integer backoffScaleFactor) {
            this.backoffScaleFactor = backoffScaleFactor;
            return this;
        }

        public TaskDefBuilder baseType(String baseType) {
            this.baseType = baseType;
            return this;
        }

        public TaskDefBuilder inputSchema(SchemaDef inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public TaskDefBuilder outputSchema(SchemaDef outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public TaskDefBuilder enforceSchema(boolean enforceSchema) {
            this.enforceSchema = enforceSchema;
            return this;
        }

        public TaskDefBuilder totalTimeoutSeconds(long totalTimeoutSeconds) {
            this.totalTimeoutSeconds = totalTimeoutSeconds;
            return this;
        }

        public TaskDef build() {
            return new TaskDef(this.name, this.description, this.retryCount, this.timeoutSeconds, this.inputKeys, this.outputKeys, this.timeoutPolicy, this.retryLogic, this.retryDelaySeconds, this.responseTimeoutSeconds, this.concurrentExecLimit, this.inputTemplate, this.rateLimitPerFrequency, this.rateLimitFrequencyInSeconds, this.isolationGroupId, this.executionNameSpace, this.ownerEmail, this.pollTimeoutSeconds, this.backoffScaleFactor, this.baseType, this.inputSchema, this.outputSchema, this.enforceSchema, this.totalTimeoutSeconds);
        }

        public String toString() {
            return "TaskDef.TaskDefBuilder(name=" + this.name + ", description=" + this.description + ", retryCount=" + this.retryCount + ", timeoutSeconds=" + this.timeoutSeconds + ", inputKeys=" + String.valueOf(this.inputKeys) + ", outputKeys=" + String.valueOf(this.outputKeys) + ", timeoutPolicy=" + String.valueOf((Object)this.timeoutPolicy) + ", retryLogic=" + String.valueOf((Object)this.retryLogic) + ", retryDelaySeconds=" + this.retryDelaySeconds + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", concurrentExecLimit=" + this.concurrentExecLimit + ", inputTemplate=" + String.valueOf(this.inputTemplate) + ", rateLimitPerFrequency=" + this.rateLimitPerFrequency + ", rateLimitFrequencyInSeconds=" + this.rateLimitFrequencyInSeconds + ", isolationGroupId=" + this.isolationGroupId + ", executionNameSpace=" + this.executionNameSpace + ", ownerEmail=" + this.ownerEmail + ", pollTimeoutSeconds=" + this.pollTimeoutSeconds + ", backoffScaleFactor=" + this.backoffScaleFactor + ", baseType=" + this.baseType + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + ", totalTimeoutSeconds=" + this.totalTimeoutSeconds + ")";
        }
    }
}

