/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.config;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyFactory {
    private static final Properties PROPERTIES = PropertyFactory.loadProperties("conductor-workers.properties");
    private static final String PROPERTY_PREFIX = "conductor.worker";
    private final WorkerProperty global;
    private final WorkerProperty local;
    private static final ConcurrentHashMap<String, PropertyFactory> PROPERTY_FACTORY_MAP = new ConcurrentHashMap();

    private PropertyFactory(String prefix, String propName, String workerName) {
        this.global = new WorkerProperty(prefix + "." + propName);
        this.local = new WorkerProperty(prefix + "." + workerName + "." + propName);
    }

    public Integer getInteger(int defaultValue) {
        Integer value = this.local.getInteger();
        if (value == null) {
            value = this.global.getInteger(defaultValue);
        }
        return value;
    }

    public String getString(String defaultValue) {
        String value = this.local.getString();
        if (value == null) {
            value = this.global.getString(defaultValue);
        }
        return value;
    }

    public Boolean getBoolean(Boolean defaultValue) {
        Boolean value = this.local.getBoolean();
        if (value == null) {
            value = this.global.getBoolean(defaultValue);
        }
        return value;
    }

    public static Integer getInteger(String workerName, String property, Integer defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getInteger(defaultValue);
    }

    public static Boolean getBoolean(String workerName, String property, Boolean defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getBoolean(defaultValue);
    }

    public static String getString(String workerName, String property, String defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getString(defaultValue);
    }

    private static PropertyFactory getPropertyFactory(String workerName, String property) {
        String key = property + "." + workerName;
        return PROPERTY_FACTORY_MAP.computeIfAbsent(key, t2 -> new PropertyFactory(PROPERTY_PREFIX, property, workerName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(String file) {
        Properties properties2 = new Properties();
        try (InputStream input = PropertyFactory.class.getClassLoader().getResourceAsStream(file);){
            if (input == null) {
                Properties properties3 = null;
                return properties3;
            }
            properties2.load(input);
            return properties2;
        }
    }

    private static class WorkerProperty {
        final String key;

        String getString() {
            if (PROPERTIES == null) {
                return null;
            }
            return PROPERTIES.getProperty(this.key);
        }

        Integer getInteger() {
            String value = this.getString();
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }

        Boolean getBoolean() {
            String value = this.getString();
            return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
        }

        String getString(String defaultValue) {
            String value = this.getString();
            return value == null ? defaultValue : value;
        }

        Integer getInteger(Integer defaultValue) {
            String value = this.getString();
            return value == null ? defaultValue : Integer.parseInt(value);
        }

        Boolean getBoolean(Boolean defaultValue) {
            String value = this.getString();
            return value == null ? defaultValue : Boolean.parseBoolean(value);
        }

        public WorkerProperty(String key) {
            this.key = key;
        }
    }
}

