/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.http.Param;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConductorClientRequest {
    private final Method method;
    private final String path;
    private final List<Param> pathParams;
    private final List<Param> queryParams;
    private final Map<String, String> headerParams;
    private final Object body;

    private ConductorClientRequest(Builder builder) {
        this.method = builder.method;
        this.path = builder.path;
        this.pathParams = builder.pathParams;
        this.queryParams = builder.queryParams;
        this.headerParams = builder.headerParams;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public List<Param> getPathParams() {
        return this.pathParams;
    }

    public List<Param> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public Object getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConductorClientRequest)) {
            return false;
        }
        ConductorClientRequest other = (ConductorClientRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<Param> this$pathParams = this.getPathParams();
        List<Param> other$pathParams = other.getPathParams();
        if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
            return false;
        }
        List<Param> this$queryParams = this.getQueryParams();
        List<Param> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        Map<String, String> this$headerParams = this.getHeaderParams();
        Map<String, String> other$headerParams = other.getHeaderParams();
        if (this$headerParams == null ? other$headerParams != null : !((Object)this$headerParams).equals(other$headerParams)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConductorClientRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Method $method = this.getMethod();
        result2 = result2 * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $path = this.getPath();
        result2 = result2 * 59 + ($path == null ? 43 : $path.hashCode());
        List<Param> $pathParams = this.getPathParams();
        result2 = result2 * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        List<Param> $queryParams = this.getQueryParams();
        result2 = result2 * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        Map<String, String> $headerParams = this.getHeaderParams();
        result2 = result2 * 59 + ($headerParams == null ? 43 : ((Object)$headerParams).hashCode());
        Object $body = this.getBody();
        result2 = result2 * 59 + ($body == null ? 43 : $body.hashCode());
        return result2;
    }

    public static class Builder {
        private Method method;
        private String path;
        private final List<Param> pathParams = new ArrayList<Param>();
        private final List<Param> queryParams = new ArrayList<Param>();
        private final Map<String, String> headerParams = new HashMap<String, String>();
        private Object body;

        public Builder method(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("Method cannot be null");
            }
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be null or empty");
            }
            this.path = path;
            return this;
        }

        public Builder addPathParam(String name, Integer value) {
            return this.addPathParam(name, Integer.toString(value));
        }

        public Builder addPathParam(String name, String value) {
            if (name == null || name.isEmpty() || value == null) {
                throw new IllegalArgumentException("Path parameter name and value cannot be null or empty");
            }
            this.pathParams.add(new Param(name, value));
            return this;
        }

        public Builder addQueryParam(String name, Long value) {
            if (value == null) {
                return this;
            }
            this.addQueryParam(name, Long.toString(value));
            return this;
        }

        public Builder addQueryParam(String name, Integer value) {
            if (value == null) {
                return this;
            }
            this.addQueryParam(name, Integer.toString(value));
            return this;
        }

        public Builder addQueryParam(String name, Boolean value) {
            if (value == null) {
                return this;
            }
            this.addQueryParam(name, Boolean.toString(value));
            return this;
        }

        public Builder addQueryParams(String name, List<String> values2) {
            values2.forEach(it -> this.addQueryParam(name, (String)it));
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            if (value == null) {
                return this;
            }
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Query parameter name cannot be null or empty");
            }
            this.queryParams.add(new Param(name, value));
            return this;
        }

        public Builder addHeaderParam(String name, String value) {
            if (name == null || name.isEmpty() || value == null) {
                throw new IllegalArgumentException("Header parameter name and value cannot be null or empty");
            }
            this.headerParams.put(name, value);
            return this;
        }

        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        public ConductorClientRequest build() {
            return new ConductorClientRequest(this);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

