/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.tasks.ExecutionMetadata;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public class TaskResult {
    private String workflowInstanceId;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Status status;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private List<TaskExecLog> logs = new CopyOnWriteArrayList<TaskExecLog>();
    private String externalOutputPayloadStoragePath;
    private String subWorkflowId;
    private boolean extendLease;
    private ExecutionMetadata executionMetadata;

    public TaskResult(Task task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.callbackAfterSeconds = task.getCallbackAfterSeconds();
        this.workerId = task.getWorkerId();
        this.outputData = task.getOutputData();
        this.externalOutputPayloadStoragePath = task.getExternalOutputPayloadStoragePath();
        this.subWorkflowId = task.getSubWorkflowId();
        this.executionMetadata = task.getExecutionMetadata();
        switch (task.getStatus()) {
            case CANCELED: 
            case COMPLETED_WITH_ERRORS: 
            case TIMED_OUT: 
            case SKIPPED: {
                this.status = Status.FAILED;
                break;
            }
            case SCHEDULED: {
                this.status = Status.IN_PROGRESS;
                break;
            }
            default: {
                this.status = Status.valueOf(task.getStatus().name());
            }
        }
    }

    public ExecutionMetadata getExecutionMetadata() {
        if (this.executionMetadata == null) {
            this.executionMetadata = new ExecutionMetadata();
        }
        return this.executionMetadata;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = StringUtils.substring(reasonForIncompletion, 0, 500);
    }

    public TaskResult addOutputData(String key, Object value) {
        this.outputData.put(key, value);
        return this;
    }

    public TaskResult log(String log) {
        this.logs.add(new TaskExecLog(log));
        return this;
    }

    public String toString() {
        return "TaskResult{workflowInstanceId='" + this.workflowInstanceId + "', taskId='" + this.taskId + "', reasonForIncompletion='" + this.reasonForIncompletion + "', callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId='" + this.workerId + "', status=" + String.valueOf((Object)this.status) + ", outputData=" + String.valueOf(this.outputData) + ", logs=" + String.valueOf(this.logs) + ", externalOutputPayloadStoragePath='" + this.externalOutputPayloadStoragePath + "', subWorkflowId='" + this.subWorkflowId + "', extendLease='" + this.extendLease + "'}";
    }

    public static TaskResult complete() {
        return TaskResult.newTaskResult(Status.COMPLETED);
    }

    public static TaskResult failed() {
        return TaskResult.newTaskResult(Status.FAILED);
    }

    public static TaskResult failed(String failureReason) {
        TaskResult result2 = TaskResult.newTaskResult(Status.FAILED);
        result2.setReasonForIncompletion(failureReason);
        return result2;
    }

    public static TaskResult inProgress() {
        return TaskResult.newTaskResult(Status.IN_PROGRESS);
    }

    public static TaskResult newTaskResult(Status status) {
        TaskResult result2 = new TaskResult();
        result2.setStatus(status);
        return result2;
    }

    public static TaskResultBuilder builder() {
        return new TaskResultBuilder();
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public List<TaskExecLog> getLogs() {
        return this.logs;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public String getSubWorkflowId() {
        return this.subWorkflowId;
    }

    public boolean isExtendLease() {
        return this.extendLease;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public void setLogs(List<TaskExecLog> logs) {
        this.logs = logs;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setSubWorkflowId(String subWorkflowId) {
        this.subWorkflowId = subWorkflowId;
    }

    public void setExtendLease(boolean extendLease) {
        this.extendLease = extendLease;
    }

    public void setExecutionMetadata(ExecutionMetadata executionMetadata) {
        this.executionMetadata = executionMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskResult)) {
            return false;
        }
        TaskResult other = (TaskResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCallbackAfterSeconds() != other.getCallbackAfterSeconds()) {
            return false;
        }
        if (this.isExtendLease() != other.isExtendLease()) {
            return false;
        }
        String this$workflowInstanceId = this.getWorkflowInstanceId();
        String other$workflowInstanceId = other.getWorkflowInstanceId();
        if (this$workflowInstanceId == null ? other$workflowInstanceId != null : !this$workflowInstanceId.equals(other$workflowInstanceId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$reasonForIncompletion = this.getReasonForIncompletion();
        String other$reasonForIncompletion = other.getReasonForIncompletion();
        if (this$reasonForIncompletion == null ? other$reasonForIncompletion != null : !this$reasonForIncompletion.equals(other$reasonForIncompletion)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Map<String, Object> this$outputData = this.getOutputData();
        Map<String, Object> other$outputData = other.getOutputData();
        if (this$outputData == null ? other$outputData != null : !((Object)this$outputData).equals(other$outputData)) {
            return false;
        }
        List<TaskExecLog> this$logs = this.getLogs();
        List<TaskExecLog> other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        String this$externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        String other$externalOutputPayloadStoragePath = other.getExternalOutputPayloadStoragePath();
        if (this$externalOutputPayloadStoragePath == null ? other$externalOutputPayloadStoragePath != null : !this$externalOutputPayloadStoragePath.equals(other$externalOutputPayloadStoragePath)) {
            return false;
        }
        String this$subWorkflowId = this.getSubWorkflowId();
        String other$subWorkflowId = other.getSubWorkflowId();
        if (this$subWorkflowId == null ? other$subWorkflowId != null : !this$subWorkflowId.equals(other$subWorkflowId)) {
            return false;
        }
        ExecutionMetadata this$executionMetadata = this.getExecutionMetadata();
        ExecutionMetadata other$executionMetadata = other.getExecutionMetadata();
        return !(this$executionMetadata == null ? other$executionMetadata != null : !((Object)this$executionMetadata).equals(other$executionMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $callbackAfterSeconds = this.getCallbackAfterSeconds();
        result2 = result2 * 59 + (int)($callbackAfterSeconds >>> 32 ^ $callbackAfterSeconds);
        result2 = result2 * 59 + (this.isExtendLease() ? 79 : 97);
        String $workflowInstanceId = this.getWorkflowInstanceId();
        result2 = result2 * 59 + ($workflowInstanceId == null ? 43 : $workflowInstanceId.hashCode());
        String $taskId = this.getTaskId();
        result2 = result2 * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $reasonForIncompletion = this.getReasonForIncompletion();
        result2 = result2 * 59 + ($reasonForIncompletion == null ? 43 : $reasonForIncompletion.hashCode());
        String $workerId = this.getWorkerId();
        result2 = result2 * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        Status $status = this.getStatus();
        result2 = result2 * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Map<String, Object> $outputData = this.getOutputData();
        result2 = result2 * 59 + ($outputData == null ? 43 : ((Object)$outputData).hashCode());
        List<TaskExecLog> $logs = this.getLogs();
        result2 = result2 * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        String $externalOutputPayloadStoragePath = this.getExternalOutputPayloadStoragePath();
        result2 = result2 * 59 + ($externalOutputPayloadStoragePath == null ? 43 : $externalOutputPayloadStoragePath.hashCode());
        String $subWorkflowId = this.getSubWorkflowId();
        result2 = result2 * 59 + ($subWorkflowId == null ? 43 : $subWorkflowId.hashCode());
        ExecutionMetadata $executionMetadata = this.getExecutionMetadata();
        result2 = result2 * 59 + ($executionMetadata == null ? 43 : ((Object)$executionMetadata).hashCode());
        return result2;
    }

    public TaskResult() {
    }

    private TaskResult(String workflowInstanceId, String taskId, String reasonForIncompletion, long callbackAfterSeconds, String workerId, Status status, Map<String, Object> outputData, List<TaskExecLog> logs, String externalOutputPayloadStoragePath, String subWorkflowId, boolean extendLease, ExecutionMetadata executionMetadata) {
        this.workflowInstanceId = workflowInstanceId;
        this.taskId = taskId;
        this.reasonForIncompletion = reasonForIncompletion;
        this.callbackAfterSeconds = callbackAfterSeconds;
        this.workerId = workerId;
        this.status = status;
        this.outputData = outputData;
        this.logs = logs;
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
        this.subWorkflowId = subWorkflowId;
        this.extendLease = extendLease;
        this.executionMetadata = executionMetadata;
    }

    public static enum Status {
        IN_PROGRESS,
        FAILED,
        FAILED_WITH_TERMINAL_ERROR,
        COMPLETED;

    }

    public static class TaskResultBuilder {
        private String workflowInstanceId;
        private String taskId;
        private String reasonForIncompletion;
        private long callbackAfterSeconds;
        private String workerId;
        private Status status;
        private Map<String, Object> outputData;
        private List<TaskExecLog> logs;
        private String externalOutputPayloadStoragePath;
        private String subWorkflowId;
        private boolean extendLease;
        private ExecutionMetadata executionMetadata;

        TaskResultBuilder() {
        }

        public TaskResultBuilder workflowInstanceId(String workflowInstanceId) {
            this.workflowInstanceId = workflowInstanceId;
            return this;
        }

        public TaskResultBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskResultBuilder reasonForIncompletion(String reasonForIncompletion) {
            this.reasonForIncompletion = reasonForIncompletion;
            return this;
        }

        public TaskResultBuilder callbackAfterSeconds(long callbackAfterSeconds) {
            this.callbackAfterSeconds = callbackAfterSeconds;
            return this;
        }

        public TaskResultBuilder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public TaskResultBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public TaskResultBuilder outputData(Map<String, Object> outputData) {
            this.outputData = outputData;
            return this;
        }

        public TaskResultBuilder logs(List<TaskExecLog> logs) {
            this.logs = logs;
            return this;
        }

        public TaskResultBuilder externalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
            this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
            return this;
        }

        public TaskResultBuilder subWorkflowId(String subWorkflowId) {
            this.subWorkflowId = subWorkflowId;
            return this;
        }

        public TaskResultBuilder extendLease(boolean extendLease) {
            this.extendLease = extendLease;
            return this;
        }

        public TaskResultBuilder executionMetadata(ExecutionMetadata executionMetadata) {
            this.executionMetadata = executionMetadata;
            return this;
        }

        public TaskResult build() {
            return new TaskResult(this.workflowInstanceId, this.taskId, this.reasonForIncompletion, this.callbackAfterSeconds, this.workerId, this.status, this.outputData, this.logs, this.externalOutputPayloadStoragePath, this.subWorkflowId, this.extendLease, this.executionMetadata);
        }

        public String toString() {
            return "TaskResult.TaskResultBuilder(workflowInstanceId=" + this.workflowInstanceId + ", taskId=" + this.taskId + ", reasonForIncompletion=" + this.reasonForIncompletion + ", callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId=" + this.workerId + ", status=" + String.valueOf((Object)this.status) + ", outputData=" + String.valueOf(this.outputData) + ", logs=" + String.valueOf(this.logs) + ", externalOutputPayloadStoragePath=" + this.externalOutputPayloadStoragePath + ", subWorkflowId=" + this.subWorkflowId + ", extendLease=" + this.extendLease + ", executionMetadata=" + String.valueOf(this.executionMetadata) + ")";
        }
    }
}

