/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.util.logging.Level;
import org.openjdk.nashorn.internal.codegen.ObjectClassGenerator;
import org.openjdk.nashorn.internal.codegen.types.Type;
import org.openjdk.nashorn.internal.lookup.Lookup;
import org.openjdk.nashorn.internal.lookup.MethodHandleFactory;
import org.openjdk.nashorn.internal.objects.Global;
import org.openjdk.nashorn.internal.runtime.Context;
import org.openjdk.nashorn.internal.runtime.Debug;
import org.openjdk.nashorn.internal.runtime.ECMAErrors;
import org.openjdk.nashorn.internal.runtime.JSType;
import org.openjdk.nashorn.internal.runtime.OptimisticReturnFilters;
import org.openjdk.nashorn.internal.runtime.Property;
import org.openjdk.nashorn.internal.runtime.PropertyMap;
import org.openjdk.nashorn.internal.runtime.ScriptObject;
import org.openjdk.nashorn.internal.runtime.StructureLoader;

public class AccessorProperty
extends Property {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle REPLACE_MAP = AccessorProperty.findOwnMH_S("replaceMap", Object.class, Object.class, PropertyMap.class);
    private static final MethodHandle INVALIDATE_SP = AccessorProperty.findOwnMH_S("invalidateSwitchPoint", Object.class, AccessorProperty.class, Object.class);
    private static final int NOOF_TYPES = JSType.getNumberOfAccessorTypes();
    private static final long serialVersionUID = 3371720170182154920L;
    private static final ClassValue<Accessors> GETTERS_SETTERS = new ClassValue<Accessors>(){

        @Override
        protected Accessors computeValue(Class<?> structure) {
            return new Accessors(structure);
        }
    };
    private transient MethodHandle[] GETTER_CACHE = new MethodHandle[NOOF_TYPES];
    transient MethodHandle primitiveGetter;
    transient MethodHandle primitiveSetter;
    transient MethodHandle objectGetter;
    transient MethodHandle objectSetter;

    public static AccessorProperty create(Object key, int propertyFlags, MethodHandle getter, MethodHandle setter) {
        return new AccessorProperty(key, propertyFlags, -1, getter, setter);
    }

    AccessorProperty(AccessorProperty property, Object delegate) {
        super(property, property.getFlags() | 0x100);
        this.primitiveGetter = AccessorProperty.bindTo(property.primitiveGetter, delegate);
        this.primitiveSetter = AccessorProperty.bindTo(property.primitiveSetter, delegate);
        this.objectGetter = AccessorProperty.bindTo(property.objectGetter, delegate);
        this.objectSetter = AccessorProperty.bindTo(property.objectSetter, delegate);
        property.GETTER_CACHE = new MethodHandle[NOOF_TYPES];
        this.setType(property.getType());
    }

    protected AccessorProperty(Object key, int flags, int slot, MethodHandle primitiveGetter, MethodHandle primitiveSetter, MethodHandle objectGetter, MethodHandle objectSetter) {
        super(key, flags, slot);
        assert (this.getClass() != AccessorProperty.class);
        this.primitiveGetter = primitiveGetter;
        this.primitiveSetter = primitiveSetter;
        this.objectGetter = objectGetter;
        this.objectSetter = objectSetter;
        this.initializeType();
    }

    private AccessorProperty(Object key, int flags, int slot, MethodHandle getter, MethodHandle setter) {
        super(key, flags | 0x80 | 0x800 | (((Class)getter.type().returnType()).isPrimitive() ? 64 : 0), slot);
        TypeDescriptor.OfField setterType;
        assert (!this.isSpill());
        TypeDescriptor.OfField getterType = getter.type().returnType();
        TypeDescriptor.OfField ofField = setterType = setter == null ? null : setter.type().parameterType(1);
        assert (setterType == null || setterType == getterType);
        if (getterType == Integer.TYPE) {
            this.primitiveGetter = Lookup.MH.asType(getter, Lookup.GET_PRIMITIVE_TYPE);
            this.primitiveSetter = setter == null ? null : Lookup.MH.asType(setter, Lookup.SET_PRIMITIVE_TYPE);
        } else if (getterType == Double.TYPE) {
            this.primitiveGetter = Lookup.MH.asType(Lookup.MH.filterReturnValue(getter, ObjectClassGenerator.PACK_DOUBLE), Lookup.GET_PRIMITIVE_TYPE);
            this.primitiveSetter = setter == null ? null : Lookup.MH.asType(Lookup.MH.filterArguments(setter, 1, ObjectClassGenerator.UNPACK_DOUBLE), Lookup.SET_PRIMITIVE_TYPE);
        } else {
            this.primitiveSetter = null;
            this.primitiveGetter = null;
        }
        assert (this.primitiveGetter == null || this.primitiveGetter.type() == Lookup.GET_PRIMITIVE_TYPE) : this.primitiveGetter + "!=" + Lookup.GET_PRIMITIVE_TYPE;
        assert (this.primitiveSetter == null || this.primitiveSetter.type() == Lookup.SET_PRIMITIVE_TYPE) : this.primitiveSetter;
        this.objectGetter = getter.type() != Lookup.GET_OBJECT_TYPE ? Lookup.MH.asType(getter, Lookup.GET_OBJECT_TYPE) : getter;
        this.objectSetter = setter != null && setter.type() != Lookup.SET_OBJECT_TYPE ? Lookup.MH.asType(setter, Lookup.SET_OBJECT_TYPE) : setter;
        this.setType((Class<?>)getterType);
    }

    public AccessorProperty(Object key, int flags, Class<?> structure, int slot) {
        super(key, flags, slot);
        this.initGetterSetter(structure);
        this.initializeType();
    }

    private void initGetterSetter(Class<?> structure) {
        int slot = this.getSlot();
        if (this.isParameter() && this.hasArguments()) {
            MethodHandle arguments2 = Lookup.MH.getter(LOOKUP, structure, "arguments", ScriptObject.class);
            this.objectGetter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.GET_ARGUMENT.methodHandle(), 0, arguments2), 1, slot), Lookup.GET_OBJECT_TYPE);
            this.objectSetter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.SET_ARGUMENT.methodHandle(), 0, arguments2), 1, slot), Lookup.SET_OBJECT_TYPE);
            this.primitiveGetter = null;
            this.primitiveSetter = null;
        } else {
            Accessors gs = GETTERS_SETTERS.get(structure);
            this.objectGetter = gs.objectGetters[slot];
            this.primitiveGetter = gs.primitiveGetters[slot];
            this.objectSetter = gs.objectSetters[slot];
            this.primitiveSetter = gs.primitiveSetters[slot];
        }
        assert (this.hasDualFields() != StructureLoader.isSingleFieldStructure(structure.getName()));
    }

    protected AccessorProperty(Object key, int flags, int slot, ScriptObject owner, Object initialValue) {
        this(key, flags, owner.getClass(), slot);
        this.setInitialValue(owner, initialValue);
    }

    public AccessorProperty(Object key, int flags, Class<?> structure, int slot, Class<?> initialType) {
        this(key, flags, structure, slot);
        this.setType(this.hasDualFields() ? initialType : Object.class);
    }

    protected AccessorProperty(AccessorProperty property, Class<?> newType) {
        super(property, property.getFlags());
        this.GETTER_CACHE = newType != property.getLocalType() ? new MethodHandle[NOOF_TYPES] : property.GETTER_CACHE;
        this.primitiveGetter = property.primitiveGetter;
        this.primitiveSetter = property.primitiveSetter;
        this.objectGetter = property.objectGetter;
        this.objectSetter = property.objectSetter;
        this.setType(newType);
    }

    protected AccessorProperty(AccessorProperty property) {
        this(property, property.getLocalType());
    }

    protected final void setInitialValue(ScriptObject owner, Object initialValue) {
        this.setType(this.hasDualFields() ? JSType.unboxedFieldType(initialValue) : Object.class);
        if (initialValue instanceof Integer) {
            this.invokeSetter(owner, (Integer)initialValue);
        } else if (initialValue instanceof Double) {
            this.invokeSetter(owner, (Double)initialValue);
        } else {
            this.invokeSetter(owner, initialValue);
        }
    }

    protected final void initializeType() {
        this.setType(!this.hasDualFields() ? Object.class : null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.GETTER_CACHE = new MethodHandle[NOOF_TYPES];
    }

    private static MethodHandle bindTo(MethodHandle mh, Object receiver) {
        if (mh == null) {
            return null;
        }
        return Lookup.MH.dropArguments(Lookup.MH.bindTo(mh, receiver), 0, Object.class);
    }

    @Override
    public Property copy() {
        return new AccessorProperty(this);
    }

    @Override
    public Property copy(Class<?> newType) {
        return new AccessorProperty(this, newType);
    }

    @Override
    public int getIntValue(ScriptObject self, ScriptObject owner) {
        try {
            return this.getGetter(Integer.TYPE).invokeExact(self);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getDoubleValue(ScriptObject self, ScriptObject owner) {
        try {
            return this.getGetter(Double.TYPE).invokeExact(self);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getObjectValue(ScriptObject self, ScriptObject owner) {
        try {
            return this.getGetter(Object.class).invokeExact(self);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected final void invokeSetter(ScriptObject self, int value) {
        try {
            this.getSetter(Integer.TYPE, self.getMap()).invokeExact(self, value);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected final void invokeSetter(ScriptObject self, double value) {
        try {
            this.getSetter(Double.TYPE, self.getMap()).invokeExact(self, value);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected final void invokeSetter(ScriptObject self, Object value) {
        try {
            this.getSetter(Object.class, self.getMap()).invokeExact(self, value);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(ScriptObject self, ScriptObject owner, int value, boolean strict) {
        assert (this.isConfigurable() || this.isWritable()) : this.getKey() + " is not writable or configurable";
        this.invokeSetter(self, value);
    }

    @Override
    public void setValue(ScriptObject self, ScriptObject owner, double value, boolean strict) {
        assert (this.isConfigurable() || this.isWritable()) : this.getKey() + " is not writable or configurable";
        this.invokeSetter(self, value);
    }

    @Override
    public void setValue(ScriptObject self, ScriptObject owner, Object value, boolean strict) {
        this.invokeSetter(self, value);
    }

    @Override
    void initMethodHandles(Class<?> structure) {
        if (!ScriptObject.class.isAssignableFrom(structure) || !StructureLoader.isStructureClass(structure.getName())) {
            throw new IllegalArgumentException();
        }
        assert (!this.isSpill());
        this.initGetterSetter(structure);
    }

    @Override
    public MethodHandle getGetter(Class<?> type2) {
        MethodHandle getter;
        int i = JSType.getAccessorTypeIndex(type2);
        assert (type2 == Integer.TYPE || type2 == Double.TYPE || type2 == Object.class) : "invalid getter type " + type2 + " for " + this.getKey();
        this.checkUndeclared();
        MethodHandle[] getterCache = this.GETTER_CACHE;
        MethodHandle cachedGetter = getterCache[i];
        if (cachedGetter != null) {
            getter = cachedGetter;
        } else {
            getterCache[i] = getter = this.debug(ObjectClassGenerator.createGetter(this.getLocalType(), type2, this.primitiveGetter, this.objectGetter, -1), this.getLocalType(), type2, "get");
        }
        assert (getter.type().returnType() == type2 && getter.type().parameterType(0) == Object.class);
        return getter;
    }

    @Override
    public MethodHandle getOptimisticGetter(Class<?> type2, int programPoint) {
        if (this.objectGetter == null) {
            return this.getOptimisticPrimitiveGetter(type2, programPoint);
        }
        this.checkUndeclared();
        return this.debug(ObjectClassGenerator.createGetter(this.getLocalType(), type2, this.primitiveGetter, this.objectGetter, programPoint), this.getLocalType(), type2, "get");
    }

    private MethodHandle getOptimisticPrimitiveGetter(Class<?> type2, int programPoint) {
        MethodHandle g2 = this.getGetter(this.getLocalType());
        return Lookup.MH.asType(OptimisticReturnFilters.filterOptimisticReturnValue(g2, type2, programPoint), g2.type().changeReturnType(type2));
    }

    private Property getWiderProperty(Class<?> type2) {
        return this.copy(type2);
    }

    private PropertyMap getWiderMap(PropertyMap oldMap, Property newProperty) {
        PropertyMap newMap = oldMap.replaceProperty(this, newProperty);
        assert (oldMap.size() > 0);
        assert (newMap.size() == oldMap.size());
        return newMap;
    }

    private void checkUndeclared() {
        if ((this.getFlags() & 0x200) != 0) {
            throw ECMAErrors.referenceError("not.defined", this.getKey().toString());
        }
    }

    private static Object replaceMap(Object sobj, PropertyMap newMap) {
        ((ScriptObject)sobj).setMap(newMap);
        return sobj;
    }

    private static Object invalidateSwitchPoint(AccessorProperty property, Object obj) {
        if (!property.builtinSwitchPoint.hasBeenInvalidated()) {
            SwitchPoint.invalidateAll(new SwitchPoint[]{property.builtinSwitchPoint});
        }
        return obj;
    }

    private MethodHandle generateSetter(Class<?> forType, Class<?> type2) {
        return this.debug(ObjectClassGenerator.createSetter(forType, type2, this.primitiveSetter, this.objectSetter), this.getLocalType(), type2, "set");
    }

    protected final boolean isUndefined() {
        return this.getLocalType() == null;
    }

    @Override
    public boolean hasNativeSetter() {
        return this.objectSetter != null;
    }

    @Override
    public MethodHandle getSetter(Class<?> type2, PropertyMap currentMap) {
        MethodHandle mh;
        this.checkUndeclared();
        int typeIndex = JSType.getAccessorTypeIndex(type2);
        int currentTypeIndex = JSType.getAccessorTypeIndex(this.getLocalType());
        if (this.needsInvalidator(typeIndex, currentTypeIndex)) {
            Property newProperty = this.getWiderProperty(type2);
            PropertyMap newMap = this.getWiderMap(currentMap, newProperty);
            MethodHandle widerSetter = newProperty.getSetter(type2, newMap);
            Class<?> ct = this.getLocalType();
            mh = Lookup.MH.filterArguments(widerSetter, 0, Lookup.MH.insertArguments(this.debugReplace(ct, type2, currentMap, newMap), 1, newMap));
            if (ct != null && ct.isPrimitive() && !type2.isPrimitive()) {
                mh = ObjectClassGenerator.createGuardBoxedPrimitiveSetter(ct, this.generateSetter(ct, ct), mh);
            }
        } else {
            Class<?> forType = this.isUndefined() ? type2 : this.getLocalType();
            mh = this.generateSetter(!forType.isPrimitive() ? Object.class : forType, type2);
        }
        if (this.isBuiltin()) {
            mh = Lookup.MH.filterArguments(mh, 0, AccessorProperty.debugInvalidate(Lookup.MH.insertArguments(INVALIDATE_SP, 0, this), this.getKey().toString()));
        }
        assert (mh.type().returnType() == Void.TYPE) : mh.type();
        return mh;
    }

    @Override
    public final boolean canChangeType() {
        if (!this.hasDualFields()) {
            return false;
        }
        return this.getLocalType() == null || this.getLocalType() != Object.class && (this.isConfigurable() || this.isWritable());
    }

    private boolean needsInvalidator(int typeIndex, int currentTypeIndex) {
        return this.canChangeType() && typeIndex > currentTypeIndex;
    }

    private MethodHandle debug(MethodHandle mh, Class<?> forType, Class<?> type2, String tag) {
        if (!Context.DEBUG || !Global.hasInstance()) {
            return mh;
        }
        Context context = Context.getContextTrusted();
        assert (context != null);
        return context.addLoggingToHandle(ObjectClassGenerator.class, Level.INFO, mh, 0, true, () -> tag + " '" + this.getKey() + "' (property=" + Debug.id(this) + ", slot=" + this.getSlot() + " " + this.getClass().getSimpleName() + " forType=" + MethodHandleFactory.stripName(forType) + ", type=" + MethodHandleFactory.stripName(type2) + ")");
    }

    private MethodHandle debugReplace(Class<?> oldType, Class<?> newType, PropertyMap oldMap, PropertyMap newMap) {
        if (!Context.DEBUG || !Global.hasInstance()) {
            return REPLACE_MAP;
        }
        Context context = Context.getContextTrusted();
        assert (context != null);
        MethodHandle mh = context.addLoggingToHandle(ObjectClassGenerator.class, REPLACE_MAP, () -> "Type change for '" + this.getKey() + "' " + oldType + "=>" + newType);
        mh = context.addLoggingToHandle(ObjectClassGenerator.class, Level.FINEST, mh, Integer.MAX_VALUE, false, () -> "Setting map " + Debug.id(oldMap) + " => " + Debug.id(newMap) + " " + oldMap + " => " + newMap);
        return mh;
    }

    private static MethodHandle debugInvalidate(MethodHandle invalidator, String key) {
        if (!Context.DEBUG || !Global.hasInstance()) {
            return invalidator;
        }
        Context context = Context.getContextTrusted();
        assert (context != null);
        return context.addLoggingToHandle(ObjectClassGenerator.class, invalidator, () -> "Field change callback for " + key + " triggered ");
    }

    private static MethodHandle findOwnMH_S(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(LOOKUP, AccessorProperty.class, name, Lookup.MH.type(rtype, types));
    }

    private static class Accessors {
        final MethodHandle[] objectGetters;
        final MethodHandle[] objectSetters;
        final MethodHandle[] primitiveGetters;
        final MethodHandle[] primitiveSetters;

        Accessors(Class<?> structure) {
            Class<?> typeClass;
            int i;
            int fieldCount = ObjectClassGenerator.getFieldCount(structure);
            this.objectGetters = new MethodHandle[fieldCount];
            this.objectSetters = new MethodHandle[fieldCount];
            this.primitiveGetters = new MethodHandle[fieldCount];
            this.primitiveSetters = new MethodHandle[fieldCount];
            for (i = 0; i < fieldCount; ++i) {
                String fieldName = ObjectClassGenerator.getFieldName(i, Type.OBJECT);
                typeClass = Type.OBJECT.getTypeClass();
                this.objectGetters[i] = Lookup.MH.asType(Lookup.MH.getter(LOOKUP, structure, fieldName, typeClass), Lookup.GET_OBJECT_TYPE);
                this.objectSetters[i] = Lookup.MH.asType(Lookup.MH.setter(LOOKUP, structure, fieldName, typeClass), Lookup.SET_OBJECT_TYPE);
            }
            if (!StructureLoader.isSingleFieldStructure(structure.getName())) {
                for (i = 0; i < fieldCount; ++i) {
                    String fieldNamePrimitive = ObjectClassGenerator.getFieldName(i, ObjectClassGenerator.PRIMITIVE_FIELD_TYPE);
                    typeClass = ObjectClassGenerator.PRIMITIVE_FIELD_TYPE.getTypeClass();
                    this.primitiveGetters[i] = Lookup.MH.asType(Lookup.MH.getter(LOOKUP, structure, fieldNamePrimitive, typeClass), Lookup.GET_PRIMITIVE_TYPE);
                    this.primitiveSetters[i] = Lookup.MH.asType(Lookup.MH.setter(LOOKUP, structure, fieldNamePrimitive, typeClass), Lookup.SET_PRIMITIVE_TYPE);
                }
            }
        }
    }
}

