/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.RateLimitConfig;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowDef
extends Auditable {
    private String name;
    private String description;
    private int version = 1;
    private List<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
    private List<String> inputParameters = new LinkedList<String>();
    private Map<String, Object> outputParameters = new HashMap<String, Object>();
    private String failureWorkflow;
    private int schemaVersion = 2;
    private boolean restartable = true;
    private boolean workflowStatusListenerEnabled = false;
    private String ownerEmail;
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.ALERT_ONLY;
    private long timeoutSeconds;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    private String workflowStatusListenerSink;
    private RateLimitConfig rateLimitConfig;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema = true;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public boolean containsType(String taskType) {
        return this.collectTasks().stream().anyMatch(t -> t.getType().equals(taskType));
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        WorkflowTask task;
        WorkflowTask workflowTask = this.getTaskByRefName(taskReferenceName);
        if (workflowTask != null && TaskType.TERMINATE.name().equals(workflowTask.getType())) {
            return null;
        }
        Iterator<WorkflowTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (TaskType.DO_WHILE.name().equals(task.getType()) && !task.getTaskReferenceName().equals(taskReferenceName) && task.has(taskReferenceName)) {
                return null;
            }
            if (!task.has(taskReferenceName)) continue;
            break;
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        return this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst().orElse(null);
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        for (WorkflowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDef that = (WorkflowDef)o;
        return this.version == that.version && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    @Override
    public String toString() {
        return "WorkflowDef{name='" + this.name + "', description='" + this.description + "', version=" + this.version + ", tasks=" + String.valueOf(this.tasks) + ", inputParameters=" + String.valueOf(this.inputParameters) + ", outputParameters=" + String.valueOf(this.outputParameters) + ", failureWorkflow='" + this.failureWorkflow + "', schemaVersion=" + this.schemaVersion + ", restartable=" + this.restartable + ", workflowStatusListenerEnabled=" + this.workflowStatusListenerEnabled + ", ownerEmail='" + this.ownerEmail + "', timeoutPolicy=" + String.valueOf((Object)this.timeoutPolicy) + ", timeoutSeconds=" + this.timeoutSeconds + ", variables=" + String.valueOf(this.variables) + ", inputTemplate=" + String.valueOf(this.inputTemplate) + ", workflowStatusListenerSink='" + this.workflowStatusListenerSink + "', rateLimitConfig=" + String.valueOf(this.rateLimitConfig) + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public static WorkflowDefBuilder builder() {
        return new WorkflowDefBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public List<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isWorkflowStatusListenerEnabled() {
        return this.workflowStatusListenerEnabled;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public String getWorkflowStatusListenerSink() {
        return this.workflowStatusListenerSink;
    }

    public RateLimitConfig getRateLimitConfig() {
        return this.rateLimitConfig;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTasks(List<WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setWorkflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public void setWorkflowStatusListenerSink(String workflowStatusListenerSink) {
        this.workflowStatusListenerSink = workflowStatusListenerSink;
    }

    public void setRateLimitConfig(RateLimitConfig rateLimitConfig) {
        this.rateLimitConfig = rateLimitConfig;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public WorkflowDef() {
    }

    private WorkflowDef(String name, String description, int version, List<WorkflowTask> tasks, List<String> inputParameters, Map<String, Object> outputParameters, String failureWorkflow, int schemaVersion, boolean restartable, boolean workflowStatusListenerEnabled, String ownerEmail, TimeoutPolicy timeoutPolicy, long timeoutSeconds, Map<String, Object> variables, Map<String, Object> inputTemplate, String workflowStatusListenerSink, RateLimitConfig rateLimitConfig, SchemaDef inputSchema, SchemaDef outputSchema, boolean enforceSchema, Map<String, Object> metadata) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.tasks = tasks;
        this.inputParameters = inputParameters;
        this.outputParameters = outputParameters;
        this.failureWorkflow = failureWorkflow;
        this.schemaVersion = schemaVersion;
        this.restartable = restartable;
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
        this.ownerEmail = ownerEmail;
        this.timeoutPolicy = timeoutPolicy;
        this.timeoutSeconds = timeoutSeconds;
        this.variables = variables;
        this.inputTemplate = inputTemplate;
        this.workflowStatusListenerSink = workflowStatusListenerSink;
        this.rateLimitConfig = rateLimitConfig;
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.enforceSchema = enforceSchema;
        this.metadata = metadata;
    }

    public static enum TimeoutPolicy {
        TIME_OUT_WF,
        ALERT_ONLY;

    }

    public static class WorkflowDefBuilder {
        private String name;
        private String description;
        private int version;
        private List<WorkflowTask> tasks;
        private List<String> inputParameters;
        private Map<String, Object> outputParameters;
        private String failureWorkflow;
        private int schemaVersion;
        private boolean restartable;
        private boolean workflowStatusListenerEnabled;
        private String ownerEmail;
        private TimeoutPolicy timeoutPolicy;
        private long timeoutSeconds;
        private Map<String, Object> variables;
        private Map<String, Object> inputTemplate;
        private String workflowStatusListenerSink;
        private RateLimitConfig rateLimitConfig;
        private SchemaDef inputSchema;
        private SchemaDef outputSchema;
        private boolean enforceSchema;
        private Map<String, Object> metadata;

        WorkflowDefBuilder() {
        }

        public WorkflowDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkflowDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WorkflowDefBuilder version(int version) {
            this.version = version;
            return this;
        }

        public WorkflowDefBuilder tasks(List<WorkflowTask> tasks) {
            this.tasks = tasks;
            return this;
        }

        public WorkflowDefBuilder inputParameters(List<String> inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public WorkflowDefBuilder outputParameters(Map<String, Object> outputParameters) {
            this.outputParameters = outputParameters;
            return this;
        }

        public WorkflowDefBuilder failureWorkflow(String failureWorkflow) {
            this.failureWorkflow = failureWorkflow;
            return this;
        }

        public WorkflowDefBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public WorkflowDefBuilder restartable(boolean restartable) {
            this.restartable = restartable;
            return this;
        }

        public WorkflowDefBuilder workflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
            this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
            return this;
        }

        public WorkflowDefBuilder ownerEmail(String ownerEmail) {
            this.ownerEmail = ownerEmail;
            return this;
        }

        public WorkflowDefBuilder timeoutPolicy(TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public WorkflowDefBuilder timeoutSeconds(long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public WorkflowDefBuilder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public WorkflowDefBuilder inputTemplate(Map<String, Object> inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public WorkflowDefBuilder workflowStatusListenerSink(String workflowStatusListenerSink) {
            this.workflowStatusListenerSink = workflowStatusListenerSink;
            return this;
        }

        public WorkflowDefBuilder rateLimitConfig(RateLimitConfig rateLimitConfig) {
            this.rateLimitConfig = rateLimitConfig;
            return this;
        }

        public WorkflowDefBuilder inputSchema(SchemaDef inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public WorkflowDefBuilder outputSchema(SchemaDef outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public WorkflowDefBuilder enforceSchema(boolean enforceSchema) {
            this.enforceSchema = enforceSchema;
            return this;
        }

        public WorkflowDefBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public WorkflowDef build() {
            return new WorkflowDef(this.name, this.description, this.version, this.tasks, this.inputParameters, this.outputParameters, this.failureWorkflow, this.schemaVersion, this.restartable, this.workflowStatusListenerEnabled, this.ownerEmail, this.timeoutPolicy, this.timeoutSeconds, this.variables, this.inputTemplate, this.workflowStatusListenerSink, this.rateLimitConfig, this.inputSchema, this.outputSchema, this.enforceSchema, this.metadata);
        }

        public String toString() {
            return "WorkflowDef.WorkflowDefBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", tasks=" + String.valueOf(this.tasks) + ", inputParameters=" + String.valueOf(this.inputParameters) + ", outputParameters=" + String.valueOf(this.outputParameters) + ", failureWorkflow=" + this.failureWorkflow + ", schemaVersion=" + this.schemaVersion + ", restartable=" + this.restartable + ", workflowStatusListenerEnabled=" + this.workflowStatusListenerEnabled + ", ownerEmail=" + this.ownerEmail + ", timeoutPolicy=" + String.valueOf((Object)this.timeoutPolicy) + ", timeoutSeconds=" + this.timeoutSeconds + ", variables=" + String.valueOf(this.variables) + ", inputTemplate=" + String.valueOf(this.inputTemplate) + ", workflowStatusListenerSink=" + this.workflowStatusListenerSink + ", rateLimitConfig=" + String.valueOf(this.rateLimitConfig) + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }
}

