/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.worker;

import com.netflix.conductor.client.config.PropertyFactory;
import com.netflix.conductor.client.worker.LoggerHolder;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;

public interface Worker {
    public static final String PROP_DOMAIN = "domain";
    public static final String PROP_ALL_WORKERS = "all";
    public static final String PROP_LOG_INTERVAL = "log_interval";
    public static final String PROP_POLL_INTERVAL = "poll_interval";
    public static final String PROP_POLL_TIMEOUT = "poll_timeout";
    public static final String PROP_LEASE_EXTEND_ENABLED = "leaseExtendEnabled";
    public static final String PROP_PAUSED = "paused";

    public String getTaskDefName();

    public TaskResult execute(Task var1);

    default public void onErrorUpdate(Task task) {
    }

    default public boolean paused() {
        return PropertyFactory.getBoolean(this.getTaskDefName(), PROP_PAUSED, false);
    }

    default public String getIdentity() {
        String serverId;
        try {
            serverId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            serverId = System.getenv("HOSTNAME");
        }
        LoggerHolder.logger.debug("Setting worker id to {}", (Object)serverId);
        return serverId;
    }

    default public int getPollingInterval() {
        return PropertyFactory.getInteger(this.getTaskDefName(), PROP_POLL_INTERVAL, 1000);
    }

    default public boolean leaseExtendEnabled() {
        return PropertyFactory.getBoolean(this.getTaskDefName(), PROP_LEASE_EXTEND_ENABLED, false);
    }

    public static Worker create(final String taskType, final Function<Task, TaskResult> executor) {
        return new Worker(){

            @Override
            public String getTaskDefName() {
                return taskType;
            }

            @Override
            public TaskResult execute(Task task) {
                return (TaskResult)executor.apply(task);
            }

            @Override
            public boolean paused() {
                return Worker.super.paused();
            }
        };
    }
}

