/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.tasks.ExecutionMetadata;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Task {
    private String taskType;
    private Status status;
    private Map<String, Object> inputData = new HashMap<String, Object>();
    private String referenceTaskName;
    private int retryCount;
    private int seq;
    private String correlationId;
    private int pollCount;
    private String taskDefName;
    private long scheduledTime;
    private long startTime;
    private long endTime;
    private long updateTime;
    private int startDelayInSeconds;
    private String retriedTaskId;
    private boolean retried;
    private boolean executed;
    private boolean callbackFromWorker = true;
    private long responseTimeoutSeconds;
    private String workflowInstanceId;
    private String workflowType;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private WorkflowTask workflowTask;
    private String domain;
    private int rateLimitPerFrequency;
    private int rateLimitFrequencyInSeconds;
    private String externalInputPayloadStoragePath;
    private String externalOutputPayloadStoragePath;
    private int workflowPriority;
    private String executionNameSpace;
    private String isolationGroupId;
    private int iteration;
    private String subWorkflowId;
    private ExecutionMetadata executionMetadata;
    private boolean subworkflowChanged;
    private String parentTaskId;
    private long firstStartTime;

    public void setInputData(Map<String, Object> inputData) {
        if (inputData == null) {
            inputData = new HashMap<String, Object>();
        }
        this.inputData = inputData;
    }

    public long getQueueWaitTime() {
        if (this.startTime > 0L && this.scheduledTime > 0L) {
            if (this.updateTime > 0L && this.getCallbackAfterSeconds() > 0L) {
                long waitTime = System.currentTimeMillis() - (this.updateTime + this.getCallbackAfterSeconds() * 1000L);
                return waitTime > 0L ? waitTime : 0L;
            }
            return this.startTime - this.scheduledTime;
        }
        return 0L;
    }

    public void incrementPollCount() {
        ++this.pollCount;
    }

    public String getTaskDefName() {
        if (this.taskDefName == null || "".equals(this.taskDefName)) {
            this.taskDefName = this.taskType;
        }
        return this.taskDefName;
    }

    public Task setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = StringUtils.substring((String)reasonForIncompletion, (int)0, (int)500);
    }

    public void setOutputData(Map<String, Object> outputData) {
        if (outputData == null) {
            outputData = new HashMap<String, Object>();
        }
        this.outputData = outputData;
    }

    public Optional<TaskDef> getTaskDefinition() {
        return Optional.ofNullable(this.getWorkflowTask()).map(WorkflowTask::getTaskDefinition);
    }

    public boolean isLoopOverTask() {
        return this.iteration > 0;
    }

    public ExecutionMetadata getExecutionMetadata() {
        if (this.executionMetadata == null) {
            this.executionMetadata = new ExecutionMetadata();
        }
        return this.executionMetadata;
    }

    public String getSubWorkflowId() {
        if (StringUtils.isNotBlank((CharSequence)this.subWorkflowId)) {
            return this.subWorkflowId;
        }
        return this.getOutputData() != null && this.getOutputData().get("subWorkflowId") != null ? (String)this.getOutputData().get("subWorkflowId") : (this.getInputData() != null ? (String)this.getInputData().get("subWorkflowId") : null);
    }

    public void setSubWorkflowId(String subWorkflowId) {
        this.subWorkflowId = subWorkflowId;
        if (this.getOutputData() != null && this.getOutputData().containsKey("subWorkflowId")) {
            this.getOutputData().put("subWorkflowId", subWorkflowId);
        }
    }

    public Task copy() {
        Task copy = new Task();
        copy.setCallbackAfterSeconds(this.callbackAfterSeconds);
        copy.setCallbackFromWorker(this.callbackFromWorker);
        copy.setCorrelationId(this.correlationId);
        copy.setInputData(this.inputData);
        copy.setOutputData(this.outputData);
        copy.setReferenceTaskName(this.referenceTaskName);
        copy.setStartDelayInSeconds(this.startDelayInSeconds);
        copy.setTaskDefName(this.taskDefName);
        copy.setTaskType(this.taskType);
        copy.setWorkflowInstanceId(this.workflowInstanceId);
        copy.setWorkflowType(this.workflowType);
        copy.setResponseTimeoutSeconds(this.responseTimeoutSeconds);
        copy.setStatus(this.status);
        copy.setRetryCount(this.retryCount);
        copy.setPollCount(this.pollCount);
        copy.setTaskId(this.taskId);
        copy.setWorkflowTask(this.workflowTask);
        copy.setDomain(this.domain);
        copy.setRateLimitPerFrequency(this.rateLimitPerFrequency);
        copy.setRateLimitFrequencyInSeconds(this.rateLimitFrequencyInSeconds);
        copy.setExternalInputPayloadStoragePath(this.externalInputPayloadStoragePath);
        copy.setExternalOutputPayloadStoragePath(this.externalOutputPayloadStoragePath);
        copy.setWorkflowPriority(this.workflowPriority);
        copy.setIteration(this.iteration);
        copy.setExecutionNameSpace(this.executionNameSpace);
        copy.setIsolationGroupId(this.isolationGroupId);
        copy.setSubWorkflowId(this.getSubWorkflowId());
        copy.setSubworkflowChanged(this.subworkflowChanged);
        copy.setParentTaskId(this.parentTaskId);
        copy.setFirstStartTime(this.firstStartTime);
        return copy;
    }

    public Task deepCopy() {
        Task deepCopy = this.copy();
        deepCopy.setStartTime(this.startTime);
        deepCopy.setScheduledTime(this.scheduledTime);
        deepCopy.setEndTime(this.endTime);
        deepCopy.setWorkerId(this.workerId);
        deepCopy.setReasonForIncompletion(this.reasonForIncompletion);
        deepCopy.setSeq(this.seq);
        deepCopy.setParentTaskId(this.parentTaskId);
        return deepCopy;
    }

    public String toString() {
        return "Task{taskType='" + this.taskType + "', status=" + String.valueOf((Object)this.status) + ", inputData=" + String.valueOf(this.inputData) + ", referenceTaskName='" + this.referenceTaskName + "', retryCount=" + this.retryCount + ", seq=" + this.seq + ", correlationId='" + this.correlationId + "', pollCount=" + this.pollCount + ", taskDefName='" + this.taskDefName + "', scheduledTime=" + this.scheduledTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", updateTime=" + this.updateTime + ", startDelayInSeconds=" + this.startDelayInSeconds + ", retriedTaskId='" + this.retriedTaskId + "', retried=" + this.retried + ", executed=" + this.executed + ", callbackFromWorker=" + this.callbackFromWorker + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", workflowInstanceId='" + this.workflowInstanceId + "', workflowType='" + this.workflowType + "', taskId='" + this.taskId + "', reasonForIncompletion='" + this.reasonForIncompletion + "', callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId='" + this.workerId + "', outputData=" + String.valueOf(this.outputData) + ", workflowTask=" + String.valueOf(this.workflowTask) + ", domain='" + this.domain + "', rateLimitPerFrequency=" + this.rateLimitPerFrequency + ", rateLimitFrequencyInSeconds=" + this.rateLimitFrequencyInSeconds + ", workflowPriority=" + this.workflowPriority + ", externalInputPayloadStoragePath='" + this.externalInputPayloadStoragePath + "', externalOutputPayloadStoragePath='" + this.externalOutputPayloadStoragePath + "', isolationGroupId='" + this.isolationGroupId + "', executionNameSpace='" + this.executionNameSpace + "', subworkflowChanged='" + this.subworkflowChanged + "', firstStartTime='" + this.firstStartTime + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return this.getRetryCount() == task.getRetryCount() && this.getSeq() == task.getSeq() && this.getPollCount() == task.getPollCount() && this.getScheduledTime() == task.getScheduledTime() && this.getStartTime() == task.getStartTime() && this.getEndTime() == task.getEndTime() && this.getUpdateTime() == task.getUpdateTime() && this.getStartDelayInSeconds() == task.getStartDelayInSeconds() && this.isRetried() == task.isRetried() && this.isExecuted() == task.isExecuted() && this.isCallbackFromWorker() == task.isCallbackFromWorker() && this.getResponseTimeoutSeconds() == task.getResponseTimeoutSeconds() && this.getCallbackAfterSeconds() == task.getCallbackAfterSeconds() && this.getRateLimitPerFrequency() == task.getRateLimitPerFrequency() && this.getRateLimitFrequencyInSeconds() == task.getRateLimitFrequencyInSeconds() && Objects.equals(this.getTaskType(), task.getTaskType()) && this.getStatus() == task.getStatus() && this.getIteration() == task.getIteration() && this.getWorkflowPriority() == task.getWorkflowPriority() && Objects.equals(this.getInputData(), task.getInputData()) && Objects.equals(this.getReferenceTaskName(), task.getReferenceTaskName()) && Objects.equals(this.getCorrelationId(), task.getCorrelationId()) && Objects.equals(this.getTaskDefName(), task.getTaskDefName()) && Objects.equals(this.getRetriedTaskId(), task.getRetriedTaskId()) && Objects.equals(this.getWorkflowInstanceId(), task.getWorkflowInstanceId()) && Objects.equals(this.getWorkflowType(), task.getWorkflowType()) && Objects.equals(this.getTaskId(), task.getTaskId()) && Objects.equals(this.getReasonForIncompletion(), task.getReasonForIncompletion()) && Objects.equals(this.getWorkerId(), task.getWorkerId()) && Objects.equals(this.getOutputData(), task.getOutputData()) && Objects.equals(this.getWorkflowTask(), task.getWorkflowTask()) && Objects.equals(this.getDomain(), task.getDomain()) && Objects.equals(this.getExternalInputPayloadStoragePath(), task.getExternalInputPayloadStoragePath()) && Objects.equals(this.getExternalOutputPayloadStoragePath(), task.getExternalOutputPayloadStoragePath()) && Objects.equals(this.getIsolationGroupId(), task.getIsolationGroupId()) && Objects.equals(this.getExecutionNameSpace(), task.getExecutionNameSpace()) && Objects.equals(this.getParentTaskId(), task.getParentTaskId()) && Objects.equals(this.getFirstStartTime(), task.getFirstStartTime());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTaskType(), this.getStatus(), this.getInputData(), this.getReferenceTaskName(), this.getWorkflowPriority(), this.getRetryCount(), this.getSeq(), this.getCorrelationId(), this.getPollCount(), this.getTaskDefName(), this.getScheduledTime(), this.getStartTime(), this.getEndTime(), this.getUpdateTime(), this.getStartDelayInSeconds(), this.getRetriedTaskId(), this.isRetried(), this.isExecuted(), this.isCallbackFromWorker(), this.getResponseTimeoutSeconds(), this.getWorkflowInstanceId(), this.getWorkflowType(), this.getTaskId(), this.getReasonForIncompletion(), this.getCallbackAfterSeconds(), this.getWorkerId(), this.getOutputData(), this.getWorkflowTask(), this.getDomain(), this.getRateLimitPerFrequency(), this.getRateLimitFrequencyInSeconds(), this.getExternalInputPayloadStoragePath(), this.getExternalOutputPayloadStoragePath(), this.getIsolationGroupId(), this.getExecutionNameSpace(), this.getParentTaskId(), this.getFirstStartTime()});
    }

    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    public String getTaskType() {
        return this.taskType;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, Object> getInputData() {
        return this.inputData;
    }

    public String getReferenceTaskName() {
        return this.referenceTaskName;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getStartDelayInSeconds() {
        return this.startDelayInSeconds;
    }

    public String getRetriedTaskId() {
        return this.retriedTaskId;
    }

    public boolean isRetried() {
        return this.retried;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isCallbackFromWorker() {
        return this.callbackFromWorker;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public WorkflowTask getWorkflowTask() {
        return this.workflowTask;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency;
    }

    public int getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public int getWorkflowPriority() {
        return this.workflowPriority;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public int getIteration() {
        return this.iteration;
    }

    public boolean isSubworkflowChanged() {
        return this.subworkflowChanged;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public long getFirstStartTime() {
        return this.firstStartTime;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setReferenceTaskName(String referenceTaskName) {
        this.referenceTaskName = referenceTaskName;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setPollCount(int pollCount) {
        this.pollCount = pollCount;
    }

    public void setTaskDefName(String taskDefName) {
        this.taskDefName = taskDefName;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setStartDelayInSeconds(int startDelayInSeconds) {
        this.startDelayInSeconds = startDelayInSeconds;
    }

    public void setRetriedTaskId(String retriedTaskId) {
        this.retriedTaskId = retriedTaskId;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public void setCallbackFromWorker(boolean callbackFromWorker) {
        this.callbackFromWorker = callbackFromWorker;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setWorkflowTask(WorkflowTask workflowTask) {
        this.workflowTask = workflowTask;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setRateLimitPerFrequency(int rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public void setRateLimitFrequencyInSeconds(int rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public void setWorkflowPriority(int workflowPriority) {
        this.workflowPriority = workflowPriority;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setExecutionMetadata(ExecutionMetadata executionMetadata) {
        this.executionMetadata = executionMetadata;
    }

    public void setSubworkflowChanged(boolean subworkflowChanged) {
        this.subworkflowChanged = subworkflowChanged;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setFirstStartTime(long firstStartTime) {
        this.firstStartTime = firstStartTime;
    }

    public Task() {
    }

    private Task(String taskType, Status status, Map<String, Object> inputData, String referenceTaskName, int retryCount, int seq, String correlationId, int pollCount, String taskDefName, long scheduledTime, long startTime, long endTime, long updateTime, int startDelayInSeconds, String retriedTaskId, boolean retried, boolean executed, boolean callbackFromWorker, long responseTimeoutSeconds, String workflowInstanceId, String workflowType, String taskId, String reasonForIncompletion, long callbackAfterSeconds, String workerId, Map<String, Object> outputData, WorkflowTask workflowTask, String domain, int rateLimitPerFrequency, int rateLimitFrequencyInSeconds, String externalInputPayloadStoragePath, String externalOutputPayloadStoragePath, int workflowPriority, String executionNameSpace, String isolationGroupId, int iteration, String subWorkflowId, ExecutionMetadata executionMetadata, boolean subworkflowChanged, String parentTaskId, long firstStartTime) {
        this.taskType = taskType;
        this.status = status;
        this.inputData = inputData;
        this.referenceTaskName = referenceTaskName;
        this.retryCount = retryCount;
        this.seq = seq;
        this.correlationId = correlationId;
        this.pollCount = pollCount;
        this.taskDefName = taskDefName;
        this.scheduledTime = scheduledTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.updateTime = updateTime;
        this.startDelayInSeconds = startDelayInSeconds;
        this.retriedTaskId = retriedTaskId;
        this.retried = retried;
        this.executed = executed;
        this.callbackFromWorker = callbackFromWorker;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.workflowInstanceId = workflowInstanceId;
        this.workflowType = workflowType;
        this.taskId = taskId;
        this.reasonForIncompletion = reasonForIncompletion;
        this.callbackAfterSeconds = callbackAfterSeconds;
        this.workerId = workerId;
        this.outputData = outputData;
        this.workflowTask = workflowTask;
        this.domain = domain;
        this.rateLimitPerFrequency = rateLimitPerFrequency;
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
        this.workflowPriority = workflowPriority;
        this.executionNameSpace = executionNameSpace;
        this.isolationGroupId = isolationGroupId;
        this.iteration = iteration;
        this.subWorkflowId = subWorkflowId;
        this.executionMetadata = executionMetadata;
        this.subworkflowChanged = subworkflowChanged;
        this.parentTaskId = parentTaskId;
        this.firstStartTime = firstStartTime;
    }

    public static enum Status {
        IN_PROGRESS(false, true, true),
        CANCELED(true, false, false),
        FAILED(true, false, true),
        FAILED_WITH_TERMINAL_ERROR(true, false, false),
        COMPLETED(true, true, true),
        COMPLETED_WITH_ERRORS(true, true, true),
        SCHEDULED(false, true, true),
        TIMED_OUT(true, false, true),
        SKIPPED(true, true, false);

        private final boolean terminal;
        private final boolean successful;
        private final boolean retriable;

        private Status(boolean terminal, boolean successful, boolean retriable) {
            this.terminal = terminal;
            this.successful = successful;
            this.retriable = retriable;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isRetriable() {
            return this.retriable;
        }
    }

    public static class TaskBuilder {
        private String taskType;
        private Status status;
        private Map<String, Object> inputData;
        private String referenceTaskName;
        private int retryCount;
        private int seq;
        private String correlationId;
        private int pollCount;
        private String taskDefName;
        private long scheduledTime;
        private long startTime;
        private long endTime;
        private long updateTime;
        private int startDelayInSeconds;
        private String retriedTaskId;
        private boolean retried;
        private boolean executed;
        private boolean callbackFromWorker;
        private long responseTimeoutSeconds;
        private String workflowInstanceId;
        private String workflowType;
        private String taskId;
        private String reasonForIncompletion;
        private long callbackAfterSeconds;
        private String workerId;
        private Map<String, Object> outputData;
        private WorkflowTask workflowTask;
        private String domain;
        private int rateLimitPerFrequency;
        private int rateLimitFrequencyInSeconds;
        private String externalInputPayloadStoragePath;
        private String externalOutputPayloadStoragePath;
        private int workflowPriority;
        private String executionNameSpace;
        private String isolationGroupId;
        private int iteration;
        private String subWorkflowId;
        private ExecutionMetadata executionMetadata;
        private boolean subworkflowChanged;
        private String parentTaskId;
        private long firstStartTime;

        TaskBuilder() {
        }

        public TaskBuilder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public TaskBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public TaskBuilder inputData(Map<String, Object> inputData) {
            this.inputData = inputData;
            return this;
        }

        public TaskBuilder referenceTaskName(String referenceTaskName) {
            this.referenceTaskName = referenceTaskName;
            return this;
        }

        public TaskBuilder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public TaskBuilder seq(int seq) {
            this.seq = seq;
            return this;
        }

        public TaskBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public TaskBuilder pollCount(int pollCount) {
            this.pollCount = pollCount;
            return this;
        }

        public TaskBuilder taskDefName(String taskDefName) {
            this.taskDefName = taskDefName;
            return this;
        }

        public TaskBuilder scheduledTime(long scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public TaskBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public TaskBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public TaskBuilder updateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public TaskBuilder startDelayInSeconds(int startDelayInSeconds) {
            this.startDelayInSeconds = startDelayInSeconds;
            return this;
        }

        public TaskBuilder retriedTaskId(String retriedTaskId) {
            this.retriedTaskId = retriedTaskId;
            return this;
        }

        public TaskBuilder retried(boolean retried) {
            this.retried = retried;
            return this;
        }

        public TaskBuilder executed(boolean executed) {
            this.executed = executed;
            return this;
        }

        public TaskBuilder callbackFromWorker(boolean callbackFromWorker) {
            this.callbackFromWorker = callbackFromWorker;
            return this;
        }

        public TaskBuilder responseTimeoutSeconds(long responseTimeoutSeconds) {
            this.responseTimeoutSeconds = responseTimeoutSeconds;
            return this;
        }

        public TaskBuilder workflowInstanceId(String workflowInstanceId) {
            this.workflowInstanceId = workflowInstanceId;
            return this;
        }

        public TaskBuilder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public TaskBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskBuilder reasonForIncompletion(String reasonForIncompletion) {
            this.reasonForIncompletion = reasonForIncompletion;
            return this;
        }

        public TaskBuilder callbackAfterSeconds(long callbackAfterSeconds) {
            this.callbackAfterSeconds = callbackAfterSeconds;
            return this;
        }

        public TaskBuilder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public TaskBuilder outputData(Map<String, Object> outputData) {
            this.outputData = outputData;
            return this;
        }

        public TaskBuilder workflowTask(WorkflowTask workflowTask) {
            this.workflowTask = workflowTask;
            return this;
        }

        public TaskBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public TaskBuilder rateLimitPerFrequency(int rateLimitPerFrequency) {
            this.rateLimitPerFrequency = rateLimitPerFrequency;
            return this;
        }

        public TaskBuilder rateLimitFrequencyInSeconds(int rateLimitFrequencyInSeconds) {
            this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
            return this;
        }

        public TaskBuilder externalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
            this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
            return this;
        }

        public TaskBuilder externalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
            this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
            return this;
        }

        public TaskBuilder workflowPriority(int workflowPriority) {
            this.workflowPriority = workflowPriority;
            return this;
        }

        public TaskBuilder executionNameSpace(String executionNameSpace) {
            this.executionNameSpace = executionNameSpace;
            return this;
        }

        public TaskBuilder isolationGroupId(String isolationGroupId) {
            this.isolationGroupId = isolationGroupId;
            return this;
        }

        public TaskBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public TaskBuilder subWorkflowId(String subWorkflowId) {
            this.subWorkflowId = subWorkflowId;
            return this;
        }

        public TaskBuilder executionMetadata(ExecutionMetadata executionMetadata) {
            this.executionMetadata = executionMetadata;
            return this;
        }

        public TaskBuilder subworkflowChanged(boolean subworkflowChanged) {
            this.subworkflowChanged = subworkflowChanged;
            return this;
        }

        public TaskBuilder parentTaskId(String parentTaskId) {
            this.parentTaskId = parentTaskId;
            return this;
        }

        public TaskBuilder firstStartTime(long firstStartTime) {
            this.firstStartTime = firstStartTime;
            return this;
        }

        public Task build() {
            return new Task(this.taskType, this.status, this.inputData, this.referenceTaskName, this.retryCount, this.seq, this.correlationId, this.pollCount, this.taskDefName, this.scheduledTime, this.startTime, this.endTime, this.updateTime, this.startDelayInSeconds, this.retriedTaskId, this.retried, this.executed, this.callbackFromWorker, this.responseTimeoutSeconds, this.workflowInstanceId, this.workflowType, this.taskId, this.reasonForIncompletion, this.callbackAfterSeconds, this.workerId, this.outputData, this.workflowTask, this.domain, this.rateLimitPerFrequency, this.rateLimitFrequencyInSeconds, this.externalInputPayloadStoragePath, this.externalOutputPayloadStoragePath, this.workflowPriority, this.executionNameSpace, this.isolationGroupId, this.iteration, this.subWorkflowId, this.executionMetadata, this.subworkflowChanged, this.parentTaskId, this.firstStartTime);
        }

        public String toString() {
            return "Task.TaskBuilder(taskType=" + this.taskType + ", status=" + String.valueOf((Object)this.status) + ", inputData=" + String.valueOf(this.inputData) + ", referenceTaskName=" + this.referenceTaskName + ", retryCount=" + this.retryCount + ", seq=" + this.seq + ", correlationId=" + this.correlationId + ", pollCount=" + this.pollCount + ", taskDefName=" + this.taskDefName + ", scheduledTime=" + this.scheduledTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", updateTime=" + this.updateTime + ", startDelayInSeconds=" + this.startDelayInSeconds + ", retriedTaskId=" + this.retriedTaskId + ", retried=" + this.retried + ", executed=" + this.executed + ", callbackFromWorker=" + this.callbackFromWorker + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", workflowInstanceId=" + this.workflowInstanceId + ", workflowType=" + this.workflowType + ", taskId=" + this.taskId + ", reasonForIncompletion=" + this.reasonForIncompletion + ", callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId=" + this.workerId + ", outputData=" + String.valueOf(this.outputData) + ", workflowTask=" + String.valueOf(this.workflowTask) + ", domain=" + this.domain + ", rateLimitPerFrequency=" + this.rateLimitPerFrequency + ", rateLimitFrequencyInSeconds=" + this.rateLimitFrequencyInSeconds + ", externalInputPayloadStoragePath=" + this.externalInputPayloadStoragePath + ", externalOutputPayloadStoragePath=" + this.externalOutputPayloadStoragePath + ", workflowPriority=" + this.workflowPriority + ", executionNameSpace=" + this.executionNameSpace + ", isolationGroupId=" + this.isolationGroupId + ", iteration=" + this.iteration + ", subWorkflowId=" + this.subWorkflowId + ", executionMetadata=" + String.valueOf(this.executionMetadata) + ", subworkflowChanged=" + this.subworkflowChanged + ", parentTaskId=" + this.parentTaskId + ", firstStartTime=" + this.firstStartTime + ")";
        }
    }
}

