/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.util;

import java.util.zip.Adler32;

public class ClassName {
    public static final String TEMPLATE_SUFFIX = ClassName.actualClassName("", 0L);
    protected final String _dottedBase;
    protected String _slashedBase;
    protected String _dottedName;
    protected String _slashedName;
    protected long _checksum;

    private ClassName(String dottedBase) {
        this._dottedBase = dottedBase;
    }

    public static ClassName constructFor(Class<?> baseClass, String suffix) {
        return new ClassName(baseClass.getName() + suffix);
    }

    public void assignChecksum(byte[] data2) {
        long l = ClassName.adler32(data2);
        if (this._checksum != 0L) {
            throw new IllegalStateException("Trying to re-assign checksum as 0x" + Long.toHexString(l) + " (had 0x" + Long.toHexString(this._checksum) + ")");
        }
        if (l == 0L) {
            l = 1L;
        }
        this._checksum = l;
    }

    public String getDottedTemplate() {
        return this._dottedBase + TEMPLATE_SUFFIX;
    }

    public String getSlashedTemplate() {
        return this.getSlashedBase() + TEMPLATE_SUFFIX;
    }

    public String getDottedName() {
        if (this._dottedName == null) {
            if (this._checksum == 0L) {
                throw new IllegalStateException("No checksum assigned yet");
            }
            this._dottedName = String.format("%s%08x", this.getDottedBase(), (int)this._checksum);
        }
        return this._dottedName;
    }

    public String getSlashedName() {
        if (this._slashedName == null) {
            if (this._checksum == 0L) {
                throw new IllegalStateException("No checksum assigned yet");
            }
            this._slashedName = String.format("%s%08x", this.getSlashedBase(), (int)this._checksum);
        }
        return this._slashedName;
    }

    public String getSourceFilename() {
        return this.getSlashedBase() + ".java";
    }

    public String getDottedBase() {
        return this._dottedBase;
    }

    public String getSlashedBase() {
        if (this._slashedBase == null) {
            this._slashedBase = ClassName.dotsToSlashes(this._dottedBase);
        }
        return this._slashedBase;
    }

    public String toString() {
        return this.getDottedName();
    }

    private static String actualClassName(String base, long checksum) {
        return String.format("%s%08x", base, (int)checksum);
    }

    protected static String dotsToSlashes(String className) {
        return className.replace(".", "/");
    }

    protected static long adler32(byte[] data2) {
        Adler32 adler = new Adler32();
        adler.update(data2);
        return adler.getValue();
    }
}

