/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import java.util.List;
import org.apache.commons.lang3.Validate;

public final class MetadataClient {
    private ConductorClient client;

    public MetadataClient() {
    }

    public MetadataClient(ConductorClient client) {
        this.client = client;
    }

    @Deprecated
    public void setRootURI(String rootUri) {
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = new ConductorClient(rootUri);
    }

    public void registerWorkflowDef(WorkflowDef workflowDef) {
        Validate.notNull(workflowDef, "WorkflowDef cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/metadata/workflow").body(workflowDef).build();
        this.client.execute(request);
    }

    public void updateWorkflowDefs(List<WorkflowDef> workflowDefs) {
        Validate.notEmpty(workflowDefs, "Workflow definitions cannot be null or empty", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/metadata/workflow").body(workflowDefs).build();
        this.client.execute(request);
    }

    public WorkflowDef getWorkflowDef(String name, Integer version) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/metadata/workflow/{name}").addPathParam("name", name).addQueryParam("version", version).build();
        ConductorClientResponse<WorkflowDef> resp = this.client.execute(request, new TypeReference<WorkflowDef>(this){});
        return resp.getData();
    }

    public List<WorkflowDef> getAllWorkflowsWithLatestVersions() {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/metadata/workflow/latest-versions").build();
        ConductorClientResponse<List<WorkflowDef>> resp = this.client.execute(request, new TypeReference<List<WorkflowDef>>(this){});
        return resp.getData();
    }

    public void unregisterWorkflowDef(String name, Integer version) {
        Validate.notBlank(name, "Name cannot be blank", new Object[0]);
        Validate.notNull(version, "version cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/metadata/workflow/{name}/{version}").addPathParam("name", name).addPathParam("version", Integer.toString(version)).build();
        this.client.execute(request);
    }

    public void registerTaskDefs(List<TaskDef> taskDefs) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/metadata/taskdefs").body(taskDefs).build();
        this.client.execute(request);
    }

    public void updateTaskDef(TaskDef taskDef) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/metadata/taskdefs").body(taskDef).build();
        this.client.execute(request);
    }

    public TaskDef getTaskDef(String taskType) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/metadata/taskdefs/{taskType}").addPathParam("taskType", taskType).build();
        ConductorClientResponse<TaskDef> resp = this.client.execute(request, new TypeReference<TaskDef>(this){});
        return resp.getData();
    }

    public void unregisterTaskDef(String taskType) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/metadata/taskdefs/{taskType}").addPathParam("taskType", taskType).build();
        this.client.execute(request);
    }

    public List<TaskDef> getAllTaskDefs() {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/metadata/taskdefs").build();
        ConductorClientResponse<List<TaskDef>> resp = this.client.execute(request, new TypeReference<List<TaskDef>>(this){});
        return resp.getData();
    }
}

