/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.events.dispatcher.EventDispatcher;
import com.netflix.conductor.client.events.listeners.ListenerRegister;
import com.netflix.conductor.client.events.listeners.TaskClientListener;
import com.netflix.conductor.client.events.task.TaskClientEvent;
import com.netflix.conductor.client.events.task.TaskPayloadUsedEvent;
import com.netflix.conductor.client.events.task.TaskResultPayloadSizeEvent;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.client.http.PayloadStorage;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskClient {
    private static final Logger log = LoggerFactory.getLogger(TaskClient.class);
    private final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private final ConductorClientConfiguration conductorClientConfiguration;
    private final EventDispatcher<TaskClientEvent> eventDispatcher = new EventDispatcher();
    private PayloadStorage payloadStorage;
    private ConductorClient client;

    public TaskClient() {
        this(null, new DefaultConductorClientConfiguration());
    }

    public TaskClient(ConductorClient client) {
        this(client, new DefaultConductorClientConfiguration());
    }

    public TaskClient(ConductorClient client, ConductorClientConfiguration config) {
        this.client = client;
        this.payloadStorage = new PayloadStorage(client);
        this.conductorClientConfiguration = config;
    }

    @Deprecated
    public void setRootURI(String rootUri) {
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = new ConductorClient(rootUri);
        this.payloadStorage = new PayloadStorage(this.client);
    }

    public void registerListener(TaskClientListener listener) {
        ListenerRegister.register(listener, this.eventDispatcher);
    }

    public Task pollTask(String taskType, String workerId, String domain) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        Validate.notBlank(workerId, "Worker id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/poll/{taskType}").addPathParam("taskType", taskType).addQueryParam("workerid", workerId).addQueryParam("domain", domain).build();
        ConductorClientResponse<Task> resp = this.client.execute(request, new TypeReference<Task>(this){});
        Task task = resp.getData();
        this.populateTaskPayloads(task);
        return task;
    }

    public List<Task> batchPollTasksByTaskType(String taskType, String workerId, int count, int timeoutInMillisecond) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        Validate.notBlank(workerId, "Worker id cannot be blank", new Object[0]);
        Validate.isTrue(count > 0, "Count must be greater than 0", new Object[0]);
        List<Task> tasks = this.batchPoll(taskType, workerId, null, count, timeoutInMillisecond);
        tasks.forEach(this::populateTaskPayloads);
        return tasks;
    }

    public List<Task> batchPollTasksInDomain(String taskType, String domain, String workerId, int count, int timeoutInMillisecond) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        Validate.notBlank(workerId, "Worker id cannot be blank", new Object[0]);
        Validate.isTrue(count > 0, "Count must be greater than 0", new Object[0]);
        List<Task> tasks = this.batchPoll(taskType, workerId, domain, count, timeoutInMillisecond);
        tasks.forEach(this::populateTaskPayloads);
        return tasks;
    }

    public void updateTask(TaskResult taskResult) {
        Validate.notNull(taskResult, "Task result cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks").body(taskResult).build();
        this.client.execute(request);
    }

    public Task updateTaskV2(TaskResult taskResult) {
        Validate.notNull(taskResult, "Task result cannot be null", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks/update-v2").body(taskResult).build();
        ConductorClientResponse<Task> response = this.client.execute(request, new TypeReference<Task>(this){});
        return response.getData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> evaluateAndUploadLargePayload(Map<String, Object> taskOutputData, String taskType) {
        if (!this.conductorClientConfiguration.isEnforceThresholds()) {
            return Optional.empty();
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue(byteArrayOutputStream, taskOutputData);
            byte[] taskOutputBytes = byteArrayOutputStream.toByteArray();
            long taskResultSize = taskOutputBytes.length;
            this.eventDispatcher.publish(new TaskResultPayloadSizeEvent(taskType, taskResultSize));
            long payloadSizeThreshold = (long)this.conductorClientConfiguration.getTaskOutputPayloadThresholdKB() * 1024L;
            if (taskResultSize > payloadSizeThreshold) {
                if (this.conductorClientConfiguration.isExternalPayloadStorageEnabled() && taskResultSize <= (long)this.conductorClientConfiguration.getTaskOutputMaxPayloadThresholdKB() * 1024L) {
                    this.eventDispatcher.publish(new TaskPayloadUsedEvent(taskType, ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.TASK_OUTPUT.name()));
                    Optional<String> optional = Optional.of(this.uploadToExternalPayloadStorage(taskOutputBytes, taskResultSize));
                    return optional;
                }
                throw new IllegalArgumentException(String.format("The TaskResult payload size: %d is greater than the permissible %d bytes", taskResultSize, payloadSizeThreshold));
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to update task: %s with task result", taskType);
            log.error(errorMsg, e);
            throw new ConductorClientException(e);
        }
    }

    public Boolean ack(String taskId, String workerId) {
        Validate.notBlank(taskId, "Task id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks/{taskId}/ack").addPathParam("taskId", taskId).addQueryParam("workerid", workerId).build();
        ConductorClientResponse<Boolean> response = this.client.execute(request, new TypeReference<Boolean>(this){});
        return response.getData();
    }

    public void logMessageForTask(String taskId, String logMessage) {
        Validate.notBlank(taskId, "Task id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks/{taskId}/log").addPathParam("taskId", taskId).body(logMessage).build();
        this.client.execute(request);
    }

    public List<TaskExecLog> getTaskLogs(String taskId) {
        Validate.notBlank(taskId, "Task id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/{taskId}/log").addPathParam("taskId", taskId).build();
        ConductorClientResponse<List<TaskExecLog>> resp = this.client.execute(request, new TypeReference<List<TaskExecLog>>(this){});
        return resp.getData();
    }

    public Task getTaskDetails(String taskId) {
        Validate.notBlank(taskId, "Task id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/{taskId}").addPathParam("taskId", taskId).build();
        ConductorClientResponse<Task> resp = this.client.execute(request, new TypeReference<Task>(this){});
        return resp.getData();
    }

    public void removeTaskFromQueue(String taskType, String taskId) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        Validate.notBlank(taskId, "Task id cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/queue/{taskType}/{taskId}").addPathParam("taskType", taskType).addPathParam("taskId", taskId).build();
        this.client.execute(request);
    }

    public int getQueueSizeForTask(String taskType) {
        return this.getQueueSizeForTask(taskType, null, null, null);
    }

    public int getQueueSizeForTask(String taskType, String domain, String isolationGroupId, String executionNamespace) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/queue/size").addQueryParam("taskType", taskType).addQueryParam("domain", domain).addQueryParam("isolationGroupId", isolationGroupId).addQueryParam("executionNamespace", executionNamespace).build();
        ConductorClientResponse<Integer> resp = this.client.execute(request, new TypeReference<Integer>(this){});
        Integer queueSize = resp.getData();
        return queueSize != null ? queueSize : 0;
    }

    public List<PollData> getPollData(String taskType) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/queue/polldata").addQueryParam("taskType", taskType).build();
        ConductorClientResponse<List<PollData>> resp = this.client.execute(request, new TypeReference<List<PollData>>(this){});
        return resp.getData();
    }

    public List<PollData> getAllPollData() {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/queue/polldata").build();
        ConductorClientResponse<List<PollData>> resp = this.client.execute(request, new TypeReference<List<PollData>>(this){});
        return resp.getData();
    }

    public String requeueAllPendingTasks() {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks/queue/requeue").build();
        ConductorClientResponse<String> resp = this.client.execute(request, new TypeReference<String>(this){});
        return resp.getData();
    }

    public String requeuePendingTasksByTaskType(String taskType) {
        Validate.notBlank(taskType, "Task type cannot be blank", new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/tasks/queue/requeue/{taskType}").addPathParam("taskType", taskType).build();
        ConductorClientResponse<String> resp = this.client.execute(request, new TypeReference<String>(this){});
        return resp.getData();
    }

    public SearchResult<TaskSummary> search(String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/search").addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<TaskSummary>> resp = this.client.execute(request, new TypeReference<SearchResult<TaskSummary>>(this){});
        return resp.getData();
    }

    public SearchResult<Task> searchV2(String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/search-v2").addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<Task>> resp = this.client.execute(request, new TypeReference<SearchResult<Task>>(this){});
        return resp.getData();
    }

    public SearchResult<TaskSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/search").addQueryParam("start", start).addQueryParam("size", size).addQueryParam("sort", sort).addQueryParam("freeText", freeText).addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<TaskSummary>> resp = this.client.execute(request, new TypeReference<SearchResult<TaskSummary>>(this){});
        return resp.getData();
    }

    public SearchResult<Task> searchV2(Integer start, Integer size, String sort, String freeText, String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/search-v2").addQueryParam("start", start).addQueryParam("size", size).addQueryParam("sort", sort).addQueryParam("freeText", freeText).addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<Task>> resp = this.client.execute(request, new TypeReference<SearchResult<Task>>(this){});
        return resp.getData();
    }

    public void populateTaskPayloads(Task task) {
        if (!this.conductorClientConfiguration.isEnforceThresholds()) {
            return;
        }
        if (StringUtils.isNotBlank(task.getExternalInputPayloadStoragePath())) {
            this.eventDispatcher.publish(new TaskPayloadUsedEvent(task.getTaskDefName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.TASK_INPUT.name()));
            task.setInputData(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.TASK_INPUT, task.getExternalInputPayloadStoragePath()));
            task.setExternalInputPayloadStoragePath(null);
        }
        if (StringUtils.isNotBlank(task.getExternalOutputPayloadStoragePath())) {
            this.eventDispatcher.publish(new TaskPayloadUsedEvent(task.getTaskDefName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.TASK_OUTPUT.name()));
            task.setOutputData(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.TASK_OUTPUT, task.getExternalOutputPayloadStoragePath()));
            task.setExternalOutputPayloadStoragePath(null);
        }
    }

    private List<Task> batchPoll(String taskType, String workerid, String domain, Integer count, Integer timeout2) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/tasks/poll/batch/{taskType}").addPathParam("taskType", taskType).addQueryParam("workerid", workerid).addQueryParam("domain", domain).addQueryParam("count", count).addQueryParam("timeout", timeout2).build();
        ConductorClientResponse<List<Task>> resp = this.client.execute(request, new TypeReference<List<Task>>(this){});
        return resp.getData();
    }

    private String uploadToExternalPayloadStorage(byte[] payloadBytes, long payloadSize) {
        ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.WRITE, ExternalPayloadStorage.PayloadType.TASK_OUTPUT, "");
        this.payloadStorage.upload(externalStorageLocation.getUri(), new ByteArrayInputStream(payloadBytes), payloadSize);
        return externalStorageLocation.getPath();
    }

    private Map<String, Object> downloadFromExternalStorage(ExternalPayloadStorage.PayloadType payloadType, String path) {
        Map map;
        block8: {
            Validate.notBlank(path, "uri cannot be blank", new Object[0]);
            ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.READ, payloadType, path);
            InputStream inputStream2 = this.payloadStorage.download(externalStorageLocation.getUri());
            try {
                map = this.objectMapper.readValue(inputStream2, Map.class);
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMsg = String.format("Unable to download payload from external storage location: %s", path);
                    log.error(errorMsg, e);
                    throw new ConductorClientException(e);
                }
            }
            inputStream2.close();
        }
        return map;
    }
}

