/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.StateChangeEvent;
import com.netflix.conductor.common.metadata.workflow.SubWorkflowParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowTask {
    private String name;
    private String taskReferenceName;
    private String description;
    private Map<String, Object> inputParameters = new HashMap<String, Object>();
    private String type = TaskType.SIMPLE.name();
    private String dynamicTaskNameParam;
    @Deprecated
    private String caseValueParam;
    @Deprecated
    private String caseExpression;
    private String scriptExpression;
    private Map<String, List<WorkflowTask>> decisionCases = new LinkedHashMap<String, List<WorkflowTask>>();
    @Deprecated
    private String dynamicForkJoinTasksParam;
    private String dynamicForkTasksParam;
    private String dynamicForkTasksInputParamName;
    private List<WorkflowTask> defaultCase = new LinkedList<WorkflowTask>();
    private List<List<WorkflowTask>> forkTasks = new LinkedList<List<WorkflowTask>>();
    private int startDelay;
    private SubWorkflowParams subWorkflowParam;
    private List<String> joinOn = new LinkedList<String>();
    private String sink;
    private boolean optional = false;
    private TaskDef taskDefinition;
    private Boolean rateLimited;
    private List<String> defaultExclusiveJoinTask = new LinkedList<String>();
    private Boolean asyncComplete = false;
    private String loopCondition;
    private List<WorkflowTask> loopOver = new LinkedList<WorkflowTask>();
    private Integer retryCount;
    private String evaluatorType;
    private String expression;
    private Map<String, List<StateChangeEvent>> onStateChange = new HashMap<String, List<StateChangeEvent>>();
    private String joinStatus;
    private CacheConfig cacheConfig;
    private boolean permissive;

    @Deprecated
    public void setWorkflowTaskType(TaskType type2) {
        this.type = type2.name();
    }

    public Boolean isAsyncComplete() {
        return this.asyncComplete;
    }

    public Boolean isRateLimited() {
        return this.rateLimited != null && this.rateLimited != false;
    }

    private Collection<List<WorkflowTask>> children() {
        LinkedList<List<WorkflowTask>> workflowTaskLists = new LinkedList<List<WorkflowTask>>();
        switch (TaskType.of(this.type)) {
            case DECISION: 
            case SWITCH: {
                workflowTaskLists.addAll(this.decisionCases.values());
                workflowTaskLists.add(this.defaultCase);
                break;
            }
            case FORK_JOIN: {
                workflowTaskLists.addAll(this.forkTasks);
                break;
            }
            case DO_WHILE: {
                workflowTaskLists.add(this.loopOver);
                break;
            }
        }
        return workflowTaskLists;
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        tasks.add(this);
        for (List<WorkflowTask> workflowTaskList : this.children()) {
            for (WorkflowTask workflowTask : workflowTaskList) {
                tasks.addAll(workflowTask.collectTasks());
            }
        }
        return tasks;
    }

    public WorkflowTask next(String taskReferenceName, WorkflowTask parent) {
        TaskType taskType = TaskType.of(this.type);
        switch (taskType) {
            case DECISION: 
            case SWITCH: 
            case DO_WHILE: {
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    WorkflowTask task;
                    Iterator<WorkflowTask> iterator2 = workflowTasks.iterator();
                    while (iterator2.hasNext() && !(task = iterator2.next()).getTaskReferenceName().equals(taskReferenceName)) {
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (!iterator2.hasNext()) continue;
                    return iterator2.next();
                }
                if (taskType != TaskType.DO_WHILE || !this.has(taskReferenceName)) break;
                return this;
            }
            case FORK_JOIN: {
                boolean found = false;
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    Iterator<WorkflowTask> iterator3 = workflowTasks.iterator();
                    while (iterator3.hasNext()) {
                        WorkflowTask task = iterator3.next();
                        if (task.getTaskReferenceName().equals(taskReferenceName)) {
                            found = true;
                            break;
                        }
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (iterator3.hasNext()) {
                        return iterator3.next();
                    }
                    if (!found || parent == null) continue;
                    return parent.next(this.taskReferenceName, parent);
                }
                break;
            }
            case DYNAMIC: 
            case TERMINATE: 
            case SIMPLE: {
                return null;
            }
        }
        return null;
    }

    public boolean has(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        switch (TaskType.of(this.type)) {
            case DECISION: 
            case SWITCH: 
            case FORK_JOIN: 
            case DO_WHILE: {
                for (List<WorkflowTask> childx : this.children()) {
                    for (WorkflowTask child : childx) {
                        if (!child.has(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public WorkflowTask get(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return this;
        }
        for (List<WorkflowTask> childx : this.children()) {
            for (WorkflowTask child : childx) {
                WorkflowTask found = child.get(taskReferenceName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public String toString() {
        return this.name + "/" + this.taskReferenceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTask that = (WorkflowTask)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.taskReferenceName, that.taskReferenceName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.taskReferenceName);
    }

    public static WorkflowTaskBuilder builder() {
        return new WorkflowTaskBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public String getType() {
        return this.type;
    }

    public String getDynamicTaskNameParam() {
        return this.dynamicTaskNameParam;
    }

    @Deprecated
    public String getCaseValueParam() {
        return this.caseValueParam;
    }

    @Deprecated
    public String getCaseExpression() {
        return this.caseExpression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public Map<String, List<WorkflowTask>> getDecisionCases() {
        return this.decisionCases;
    }

    @Deprecated
    public String getDynamicForkJoinTasksParam() {
        return this.dynamicForkJoinTasksParam;
    }

    public String getDynamicForkTasksParam() {
        return this.dynamicForkTasksParam;
    }

    public String getDynamicForkTasksInputParamName() {
        return this.dynamicForkTasksInputParamName;
    }

    public List<WorkflowTask> getDefaultCase() {
        return this.defaultCase;
    }

    public List<List<WorkflowTask>> getForkTasks() {
        return this.forkTasks;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public SubWorkflowParams getSubWorkflowParam() {
        return this.subWorkflowParam;
    }

    public List<String> getJoinOn() {
        return this.joinOn;
    }

    public String getSink() {
        return this.sink;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TaskDef getTaskDefinition() {
        return this.taskDefinition;
    }

    public Boolean getRateLimited() {
        return this.rateLimited;
    }

    public List<String> getDefaultExclusiveJoinTask() {
        return this.defaultExclusiveJoinTask;
    }

    public Boolean getAsyncComplete() {
        return this.asyncComplete;
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public List<WorkflowTask> getLoopOver() {
        return this.loopOver;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public String getEvaluatorType() {
        return this.evaluatorType;
    }

    public String getExpression() {
        return this.expression;
    }

    public Map<String, List<StateChangeEvent>> getOnStateChange() {
        return this.onStateChange;
    }

    public String getJoinStatus() {
        return this.joinStatus;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public boolean isPermissive() {
        return this.permissive;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public void setInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setDynamicTaskNameParam(String dynamicTaskNameParam) {
        this.dynamicTaskNameParam = dynamicTaskNameParam;
    }

    @Deprecated
    public void setCaseValueParam(String caseValueParam) {
        this.caseValueParam = caseValueParam;
    }

    @Deprecated
    public void setCaseExpression(String caseExpression) {
        this.caseExpression = caseExpression;
    }

    public void setScriptExpression(String scriptExpression) {
        this.scriptExpression = scriptExpression;
    }

    public void setDecisionCases(Map<String, List<WorkflowTask>> decisionCases) {
        this.decisionCases = decisionCases;
    }

    @Deprecated
    public void setDynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
    }

    public void setDynamicForkTasksParam(String dynamicForkTasksParam) {
        this.dynamicForkTasksParam = dynamicForkTasksParam;
    }

    public void setDynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
    }

    public void setDefaultCase(List<WorkflowTask> defaultCase) {
        this.defaultCase = defaultCase;
    }

    public void setForkTasks(List<List<WorkflowTask>> forkTasks) {
        this.forkTasks = forkTasks;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public void setSubWorkflowParam(SubWorkflowParams subWorkflowParam) {
        this.subWorkflowParam = subWorkflowParam;
    }

    public void setJoinOn(List<String> joinOn) {
        this.joinOn = joinOn;
    }

    public void setSink(String sink2) {
        this.sink = sink2;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setTaskDefinition(TaskDef taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public void setRateLimited(Boolean rateLimited) {
        this.rateLimited = rateLimited;
    }

    public void setDefaultExclusiveJoinTask(List<String> defaultExclusiveJoinTask) {
        this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
    }

    public void setAsyncComplete(Boolean asyncComplete) {
        this.asyncComplete = asyncComplete;
    }

    public void setLoopCondition(String loopCondition) {
        this.loopCondition = loopCondition;
    }

    public void setLoopOver(List<WorkflowTask> loopOver) {
        this.loopOver = loopOver;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public void setEvaluatorType(String evaluatorType) {
        this.evaluatorType = evaluatorType;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setOnStateChange(Map<String, List<StateChangeEvent>> onStateChange) {
        this.onStateChange = onStateChange;
    }

    public void setJoinStatus(String joinStatus) {
        this.joinStatus = joinStatus;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public void setPermissive(boolean permissive) {
        this.permissive = permissive;
    }

    public WorkflowTask() {
    }

    private WorkflowTask(String name, String taskReferenceName, String description2, Map<String, Object> inputParameters, String type2, String dynamicTaskNameParam, String caseValueParam, String caseExpression, String scriptExpression, Map<String, List<WorkflowTask>> decisionCases, String dynamicForkJoinTasksParam, String dynamicForkTasksParam, String dynamicForkTasksInputParamName, List<WorkflowTask> defaultCase, List<List<WorkflowTask>> forkTasks, int startDelay, SubWorkflowParams subWorkflowParam, List<String> joinOn, String sink2, boolean optional, TaskDef taskDefinition, Boolean rateLimited, List<String> defaultExclusiveJoinTask, Boolean asyncComplete, String loopCondition, List<WorkflowTask> loopOver, Integer retryCount, String evaluatorType, String expression, Map<String, List<StateChangeEvent>> onStateChange, String joinStatus, CacheConfig cacheConfig, boolean permissive) {
        this.name = name;
        this.taskReferenceName = taskReferenceName;
        this.description = description2;
        this.inputParameters = inputParameters;
        this.type = type2;
        this.dynamicTaskNameParam = dynamicTaskNameParam;
        this.caseValueParam = caseValueParam;
        this.caseExpression = caseExpression;
        this.scriptExpression = scriptExpression;
        this.decisionCases = decisionCases;
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
        this.dynamicForkTasksParam = dynamicForkTasksParam;
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
        this.defaultCase = defaultCase;
        this.forkTasks = forkTasks;
        this.startDelay = startDelay;
        this.subWorkflowParam = subWorkflowParam;
        this.joinOn = joinOn;
        this.sink = sink2;
        this.optional = optional;
        this.taskDefinition = taskDefinition;
        this.rateLimited = rateLimited;
        this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
        this.asyncComplete = asyncComplete;
        this.loopCondition = loopCondition;
        this.loopOver = loopOver;
        this.retryCount = retryCount;
        this.evaluatorType = evaluatorType;
        this.expression = expression;
        this.onStateChange = onStateChange;
        this.joinStatus = joinStatus;
        this.cacheConfig = cacheConfig;
        this.permissive = permissive;
    }

    public static class WorkflowTaskBuilder {
        private String name;
        private String taskReferenceName;
        private String description;
        private Map<String, Object> inputParameters;
        private String type;
        private String dynamicTaskNameParam;
        private String caseValueParam;
        private String caseExpression;
        private String scriptExpression;
        private Map<String, List<WorkflowTask>> decisionCases;
        private String dynamicForkJoinTasksParam;
        private String dynamicForkTasksParam;
        private String dynamicForkTasksInputParamName;
        private List<WorkflowTask> defaultCase;
        private List<List<WorkflowTask>> forkTasks;
        private int startDelay;
        private SubWorkflowParams subWorkflowParam;
        private List<String> joinOn;
        private String sink;
        private boolean optional;
        private TaskDef taskDefinition;
        private Boolean rateLimited;
        private List<String> defaultExclusiveJoinTask;
        private Boolean asyncComplete;
        private String loopCondition;
        private List<WorkflowTask> loopOver;
        private Integer retryCount;
        private String evaluatorType;
        private String expression;
        private Map<String, List<StateChangeEvent>> onStateChange;
        private String joinStatus;
        private CacheConfig cacheConfig;
        private boolean permissive;

        WorkflowTaskBuilder() {
        }

        public WorkflowTaskBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkflowTaskBuilder taskReferenceName(String taskReferenceName) {
            this.taskReferenceName = taskReferenceName;
            return this;
        }

        public WorkflowTaskBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        public WorkflowTaskBuilder inputParameters(Map<String, Object> inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public WorkflowTaskBuilder type(String type2) {
            this.type = type2;
            return this;
        }

        public WorkflowTaskBuilder dynamicTaskNameParam(String dynamicTaskNameParam) {
            this.dynamicTaskNameParam = dynamicTaskNameParam;
            return this;
        }

        @Deprecated
        public WorkflowTaskBuilder caseValueParam(String caseValueParam) {
            this.caseValueParam = caseValueParam;
            return this;
        }

        @Deprecated
        public WorkflowTaskBuilder caseExpression(String caseExpression) {
            this.caseExpression = caseExpression;
            return this;
        }

        public WorkflowTaskBuilder scriptExpression(String scriptExpression) {
            this.scriptExpression = scriptExpression;
            return this;
        }

        public WorkflowTaskBuilder decisionCases(Map<String, List<WorkflowTask>> decisionCases) {
            this.decisionCases = decisionCases;
            return this;
        }

        @Deprecated
        public WorkflowTaskBuilder dynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
            this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
            return this;
        }

        public WorkflowTaskBuilder dynamicForkTasksParam(String dynamicForkTasksParam) {
            this.dynamicForkTasksParam = dynamicForkTasksParam;
            return this;
        }

        public WorkflowTaskBuilder dynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
            this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
            return this;
        }

        public WorkflowTaskBuilder defaultCase(List<WorkflowTask> defaultCase) {
            this.defaultCase = defaultCase;
            return this;
        }

        public WorkflowTaskBuilder forkTasks(List<List<WorkflowTask>> forkTasks) {
            this.forkTasks = forkTasks;
            return this;
        }

        public WorkflowTaskBuilder startDelay(int startDelay) {
            this.startDelay = startDelay;
            return this;
        }

        public WorkflowTaskBuilder subWorkflowParam(SubWorkflowParams subWorkflowParam) {
            this.subWorkflowParam = subWorkflowParam;
            return this;
        }

        public WorkflowTaskBuilder joinOn(List<String> joinOn) {
            this.joinOn = joinOn;
            return this;
        }

        public WorkflowTaskBuilder sink(String sink2) {
            this.sink = sink2;
            return this;
        }

        public WorkflowTaskBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public WorkflowTaskBuilder taskDefinition(TaskDef taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public WorkflowTaskBuilder rateLimited(Boolean rateLimited) {
            this.rateLimited = rateLimited;
            return this;
        }

        public WorkflowTaskBuilder defaultExclusiveJoinTask(List<String> defaultExclusiveJoinTask) {
            this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
            return this;
        }

        public WorkflowTaskBuilder asyncComplete(Boolean asyncComplete) {
            this.asyncComplete = asyncComplete;
            return this;
        }

        public WorkflowTaskBuilder loopCondition(String loopCondition) {
            this.loopCondition = loopCondition;
            return this;
        }

        public WorkflowTaskBuilder loopOver(List<WorkflowTask> loopOver) {
            this.loopOver = loopOver;
            return this;
        }

        public WorkflowTaskBuilder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public WorkflowTaskBuilder evaluatorType(String evaluatorType) {
            this.evaluatorType = evaluatorType;
            return this;
        }

        public WorkflowTaskBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public WorkflowTaskBuilder onStateChange(Map<String, List<StateChangeEvent>> onStateChange) {
            this.onStateChange = onStateChange;
            return this;
        }

        public WorkflowTaskBuilder joinStatus(String joinStatus) {
            this.joinStatus = joinStatus;
            return this;
        }

        public WorkflowTaskBuilder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        public WorkflowTaskBuilder permissive(boolean permissive) {
            this.permissive = permissive;
            return this;
        }

        public WorkflowTask build() {
            return new WorkflowTask(this.name, this.taskReferenceName, this.description, this.inputParameters, this.type, this.dynamicTaskNameParam, this.caseValueParam, this.caseExpression, this.scriptExpression, this.decisionCases, this.dynamicForkJoinTasksParam, this.dynamicForkTasksParam, this.dynamicForkTasksInputParamName, this.defaultCase, this.forkTasks, this.startDelay, this.subWorkflowParam, this.joinOn, this.sink, this.optional, this.taskDefinition, this.rateLimited, this.defaultExclusiveJoinTask, this.asyncComplete, this.loopCondition, this.loopOver, this.retryCount, this.evaluatorType, this.expression, this.onStateChange, this.joinStatus, this.cacheConfig, this.permissive);
        }

        public String toString() {
            return "WorkflowTask.WorkflowTaskBuilder(name=" + this.name + ", taskReferenceName=" + this.taskReferenceName + ", description=" + this.description + ", inputParameters=" + String.valueOf(this.inputParameters) + ", type=" + this.type + ", dynamicTaskNameParam=" + this.dynamicTaskNameParam + ", caseValueParam=" + this.caseValueParam + ", caseExpression=" + this.caseExpression + ", scriptExpression=" + this.scriptExpression + ", decisionCases=" + String.valueOf(this.decisionCases) + ", dynamicForkJoinTasksParam=" + this.dynamicForkJoinTasksParam + ", dynamicForkTasksParam=" + this.dynamicForkTasksParam + ", dynamicForkTasksInputParamName=" + this.dynamicForkTasksInputParamName + ", defaultCase=" + String.valueOf(this.defaultCase) + ", forkTasks=" + String.valueOf(this.forkTasks) + ", startDelay=" + this.startDelay + ", subWorkflowParam=" + String.valueOf(this.subWorkflowParam) + ", joinOn=" + String.valueOf(this.joinOn) + ", sink=" + this.sink + ", optional=" + this.optional + ", taskDefinition=" + String.valueOf(this.taskDefinition) + ", rateLimited=" + this.rateLimited + ", defaultExclusiveJoinTask=" + String.valueOf(this.defaultExclusiveJoinTask) + ", asyncComplete=" + this.asyncComplete + ", loopCondition=" + this.loopCondition + ", loopOver=" + String.valueOf(this.loopOver) + ", retryCount=" + this.retryCount + ", evaluatorType=" + this.evaluatorType + ", expression=" + this.expression + ", onStateChange=" + String.valueOf(this.onStateChange) + ", joinStatus=" + this.joinStatus + ", cacheConfig=" + String.valueOf(this.cacheConfig) + ", permissive=" + this.permissive + ")";
        }
    }

    public static class CacheConfig {
        private String key;
        private int ttlInSecond;

        public String getKey() {
            return this.key;
        }

        public int getTtlInSecond() {
            return this.ttlInSecond;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setTtlInSecond(int ttlInSecond) {
            this.ttlInSecond = ttlInSecond;
        }
    }

    public static class WorkflowTaskList {
        private List<WorkflowTask> tasks;
    }
}

