/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.automator;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.automator.TaskRunner;
import com.netflix.conductor.client.automator.filters.PollFilter;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.events.dispatcher.EventDispatcher;
import com.netflix.conductor.client.events.listeners.ListenerRegister;
import com.netflix.conductor.client.events.taskrunner.TaskRunnerEvent;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.metrics.MetricsCollector;
import com.netflix.conductor.client.worker.Worker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnerConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRunnerConfigurer.class);
    private final TaskClient taskClient;
    private final List<Worker> workers;
    private final int sleepWhenRetry;
    private final int updateRetryCount;
    private final int shutdownGracePeriodSeconds;
    private final String workerNamePrefix;
    private final Map<String, String> taskToDomain;
    private final Map<String, Integer> taskToThreadCount;
    private final Map<String, Integer> taskPollTimeout;
    private final Map<String, Integer> taskPollCount;
    private final Integer defaultPollTimeout;
    private final int threadCount;
    private final List<TaskRunner> taskRunners;
    private ExecutorService scheduledExecutorService;
    private final List<PollFilter> pollFilters;
    private final EventDispatcher<TaskRunnerEvent> eventDispatcher;
    private final boolean useVirtualThreads;

    private TaskRunnerConfigurer(Builder builder) {
        this.taskClient = builder.taskClient;
        this.sleepWhenRetry = builder.sleepWhenRetry;
        this.updateRetryCount = builder.updateRetryCount;
        this.workerNamePrefix = builder.workerNamePrefix;
        this.taskToDomain = builder.taskToDomain;
        this.taskToThreadCount = builder.taskToThreadCount;
        this.taskPollTimeout = builder.taskPollTimeout;
        this.taskPollCount = builder.taskPollCount;
        this.defaultPollTimeout = builder.defaultPollTimeout;
        this.shutdownGracePeriodSeconds = builder.shutdownGracePeriodSeconds;
        this.workers = new LinkedList<Worker>();
        this.threadCount = builder.threadCount;
        this.pollFilters = builder.pollFilters;
        this.eventDispatcher = builder.eventDispatcher;
        this.useVirtualThreads = builder.useVirtualThreads;
        builder.workers.forEach(this.workers::add);
        this.taskRunners = new LinkedList<TaskRunner>();
    }

    @Deprecated
    public int getThreadCount() {
        return this.threadCount;
    }

    public int getWorkerCount() {
        return this.workers.size();
    }

    public Map<String, Integer> getTaskThreadCount() {
        return this.taskToThreadCount;
    }

    public int getShutdownGracePeriodSeconds() {
        return this.shutdownGracePeriodSeconds;
    }

    public int getSleepWhenRetry() {
        return this.sleepWhenRetry;
    }

    public int getUpdateRetryCount() {
        return this.updateRetryCount;
    }

    public String getWorkerNamePrefix() {
        return this.workerNamePrefix;
    }

    public boolean isUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    public synchronized void init() {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(this.workers.size(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("TaskRunner %d").build());
        this.workers.forEach(worker -> this.scheduledExecutorService.submit(() -> this.startWorker((Worker)worker)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.taskRunners != null) {
            List<TaskRunner> list = this.taskRunners;
            synchronized (list) {
                this.taskRunners.forEach(taskRunner -> taskRunner.shutdown(this.shutdownGracePeriodSeconds));
            }
        }
        this.scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(Worker worker) {
        Integer threadCountForTask = this.taskToThreadCount.getOrDefault(worker.getTaskDefName(), this.threadCount);
        Integer taskPollTimeout = this.taskPollTimeout.getOrDefault(worker.getTaskDefName(), this.defaultPollTimeout);
        LOGGER.info("Domain map for tasks = {}", this.taskToDomain);
        TaskRunner taskRunner = new TaskRunner(worker, this.taskClient, this.updateRetryCount, this.taskToDomain, this.workerNamePrefix, threadCountForTask, taskPollTimeout, this.pollFilters, this.eventDispatcher, this.useVirtualThreads);
        List<TaskRunner> list = this.taskRunners;
        synchronized (list) {
            this.taskRunners.add(taskRunner);
        }
        LOGGER.info("Starting worker {}", (Object)worker.getTaskDefName());
        taskRunner.pollAndExecute();
    }

    public static class Builder {
        private String workerNamePrefix = "workflow-worker-%d";
        private int sleepWhenRetry = 500;
        private int updateRetryCount = 3;
        private int threadCount = -1;
        private int shutdownGracePeriodSeconds = 10;
        private int defaultPollTimeout = 100;
        private int defaultPollCount = 20;
        private final Iterable<Worker> workers;
        private final TaskClient taskClient;
        private Map<String, String> taskToDomain = new HashMap<String, String>();
        private Map<String, Integer> taskToThreadCount = new HashMap<String, Integer>();
        private Map<String, Integer> taskPollTimeout = new HashMap<String, Integer>();
        private Map<String, Integer> taskPollCount = new HashMap<String, Integer>();
        private final List<PollFilter> pollFilters = new LinkedList<PollFilter>();
        private final EventDispatcher<TaskRunnerEvent> eventDispatcher = new EventDispatcher();
        private boolean useVirtualThreads;

        public Builder(TaskClient taskClient, Iterable<Worker> workers) {
            Preconditions.checkNotNull((Object)taskClient, (Object)"TaskClient cannot be null");
            Preconditions.checkNotNull(workers, (Object)"Workers cannot be null");
            this.taskClient = taskClient;
            this.workers = workers;
        }

        public Builder withWorkerNamePrefix(String workerNamePrefix) {
            this.workerNamePrefix = workerNamePrefix;
            return this;
        }

        public Builder withSleepWhenRetry(int sleepWhenRetry) {
            this.sleepWhenRetry = sleepWhenRetry;
            return this;
        }

        public Builder withUpdateRetryCount(int updateRetryCount) {
            this.updateRetryCount = updateRetryCount;
            return this;
        }

        public Builder withConductorClientConfiguration(ConductorClientConfiguration conductorClientConfiguration) {
            return this;
        }

        public Builder withShutdownGracePeriodSeconds(int shutdownGracePeriodSeconds) {
            if (shutdownGracePeriodSeconds < 1) {
                throw new IllegalArgumentException("Seconds of shutdownGracePeriod cannot be less than 1");
            }
            this.shutdownGracePeriodSeconds = shutdownGracePeriodSeconds;
            return this;
        }

        public Builder withTaskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
            return this;
        }

        public Builder withTaskThreadCount(Map<String, Integer> taskToThreadCount) {
            this.taskToThreadCount = taskToThreadCount;
            if (taskToThreadCount.values().stream().anyMatch(v -> v < 1)) {
                throw new IllegalArgumentException("No. of threads cannot be less than 1");
            }
            return this;
        }

        public Builder withTaskToThreadCount(Map<String, Integer> taskToThreadCount) {
            this.taskToThreadCount = taskToThreadCount;
            return this;
        }

        public Builder withTaskPollTimeout(Map<String, Integer> taskPollTimeout) {
            this.taskPollTimeout = taskPollTimeout;
            return this;
        }

        public Builder withTaskPollTimeout(Integer taskPollTimeout) {
            this.defaultPollTimeout = taskPollTimeout;
            return this;
        }

        public Builder withTaskPollCount(Map<String, Integer> taskPollCount) {
            this.taskPollCount = taskPollCount;
            return this;
        }

        public Builder withTaskPollCount(int defaultPollCount) {
            this.defaultPollCount = defaultPollCount;
            return this;
        }

        public TaskRunnerConfigurer build() {
            return new TaskRunnerConfigurer(this);
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount < 1) {
                throw new IllegalArgumentException("No. of threads cannot be less than 1");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withPollFilter(PollFilter filter) {
            this.pollFilters.add(filter);
            return this;
        }

        public <T extends TaskRunnerEvent> Builder withListener(Class<T> eventType, Consumer<T> listener) {
            this.eventDispatcher.register(eventType, listener);
            return this;
        }

        public Builder withMetricsCollector(MetricsCollector metricsCollector) {
            ListenerRegister.register(metricsCollector, this.eventDispatcher);
            return this;
        }

        public Builder withUseVirtualThreads(boolean useVirtualThreads) {
            this.useVirtualThreads = useVirtualThreads;
            return this;
        }
    }
}

