/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.common.model.CircuitBreakerTransitionResponse;
import com.netflix.conductor.common.model.ProtoRegistryEntry;
import com.netflix.conductor.common.model.ServiceMethod;
import com.netflix.conductor.common.model.ServiceRegistry;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistryClient.class);
    private final ConductorClientConfiguration conductorClientConfiguration;
    private ConductorClient client;

    public ServiceRegistryClient() {
        this(null, new DefaultConductorClientConfiguration());
    }

    public ServiceRegistryClient(ConductorClient client) {
        this(client, new DefaultConductorClientConfiguration());
    }

    public ServiceRegistryClient(ConductorClient client, ConductorClientConfiguration config) {
        this.client = client;
        this.conductorClientConfiguration = config;
    }

    @Deprecated
    public void setRootURI(String rootUri) {
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = new ConductorClient(rootUri);
    }

    public List<ServiceRegistry> getRegisteredServices() {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service").build();
        ConductorClientResponse<List<ServiceRegistry>> resp = this.client.execute(request, new TypeReference<List<ServiceRegistry>>(this){});
        return resp.getData();
    }

    public ServiceRegistry getService(String name) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service/{name}").addPathParam("name", name).build();
        ConductorClientResponse<ServiceRegistry> resp = this.client.execute(request, new TypeReference<ServiceRegistry>(this){});
        return resp.getData();
    }

    public void addOrUpdateService(ServiceRegistry serviceRegistry) {
        Validate.notNull((Object)serviceRegistry, (String)"Service registry cannot be null", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/registry/service").body(serviceRegistry).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public void removeService(String name) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/registry/service/{name}").addPathParam("name", name).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public CircuitBreakerTransitionResponse openCircuitBreaker(String name) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/registry/service/{name}/circuit-breaker/open").addPathParam("name", name).build();
        ConductorClientResponse<CircuitBreakerTransitionResponse> resp = this.client.execute(request, new TypeReference<CircuitBreakerTransitionResponse>(this){});
        return resp.getData();
    }

    public CircuitBreakerTransitionResponse closeCircuitBreaker(String name) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/registry/service/{name}/circuit-breaker/close").addPathParam("name", name).build();
        ConductorClientResponse<CircuitBreakerTransitionResponse> resp = this.client.execute(request, new TypeReference<CircuitBreakerTransitionResponse>(this){});
        return resp.getData();
    }

    public CircuitBreakerTransitionResponse getCircuitBreakerStatus(String name) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service/{name}/circuit-breaker/status").addPathParam("name", name).build();
        ConductorClientResponse<CircuitBreakerTransitionResponse> resp = this.client.execute(request, new TypeReference<CircuitBreakerTransitionResponse>(this){});
        return resp.getData();
    }

    public void addOrUpdateServiceMethod(String registryName, ServiceMethod method) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)method, (String)"Service method cannot be null", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/registry/service/{registryName}/methods").addPathParam("registryName", registryName).body(method).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public void removeMethod(String registryName, String serviceName, String method, String methodType) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)serviceName, (String)"Service name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)method, (String)"Method name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodType, (String)"Method type cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/registry/service/{registryName}/methods").addPathParam("registryName", registryName).addQueryParam("serviceName", serviceName).addQueryParam("method", method).addQueryParam("methodType", methodType).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public byte[] getProtoData(String registryName, String filename) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)filename, (String)"Filename cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service/protos/{registryName}/{filename}").addPathParam("registryName", registryName).addPathParam("filename", filename).build();
        ConductorClientResponse<byte[]> resp = this.client.execute(request, new TypeReference<byte[]>(this){});
        return resp.getData();
    }

    public void setProtoData(String registryName, String filename, byte[] data) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)filename, (String)"Filename cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)data, (String)"Proto data cannot be null", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/registry/service/protos/{registryName}/{filename}").addPathParam("registryName", registryName).addPathParam("filename", filename).addHeaderParam("Content-Type", "application/octet-stream").body(data).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public void deleteProto(String registryName, String filename) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)filename, (String)"Filename cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/registry/service/protos/{registryName}/{filename}").addPathParam("registryName", registryName).addPathParam("filename", filename).build();
        this.client.execute(request, new TypeReference<Void>(this){});
    }

    public List<ProtoRegistryEntry> getAllProtos(String registryName) {
        Validate.notBlank((CharSequence)registryName, (String)"Registry name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service/protos/{registryName}").addPathParam("registryName", registryName).build();
        ConductorClientResponse<List<ProtoRegistryEntry>> resp = this.client.execute(request, new TypeReference<List<ProtoRegistryEntry>>(this){});
        return resp.getData();
    }

    public List<ServiceMethod> discover(String name, boolean create) {
        Validate.notBlank((CharSequence)name, (String)"Service name cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/registry/service/{name}/discover").addPathParam("name", name).addQueryParam("create", String.valueOf(create)).build();
        ConductorClientResponse<List<ServiceMethod>> resp = this.client.execute(request, new TypeReference<List<ServiceMethod>>(this){});
        return resp.getData();
    }
}

