/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.events.dispatcher.EventDispatcher;
import com.netflix.conductor.client.events.listeners.ListenerRegister;
import com.netflix.conductor.client.events.listeners.WorkflowClientListener;
import com.netflix.conductor.client.events.workflow.WorkflowClientEvent;
import com.netflix.conductor.client.events.workflow.WorkflowInputPayloadSizeEvent;
import com.netflix.conductor.client.events.workflow.WorkflowPayloadUsedEvent;
import com.netflix.conductor.client.events.workflow.WorkflowStartedEvent;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.client.http.PayloadStorage;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.SkipTaskRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.common.run.WorkflowTestRequest;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowClient {
    private static final Logger log = LoggerFactory.getLogger(WorkflowClient.class);
    private final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private final ConductorClientConfiguration conductorClientConfiguration;
    private final EventDispatcher<WorkflowClientEvent> eventDispatcher = new EventDispatcher();
    private ConductorClient client;
    private PayloadStorage payloadStorage;

    public WorkflowClient() {
        this(null, new DefaultConductorClientConfiguration());
    }

    public WorkflowClient(ConductorClient client) {
        this(client, new DefaultConductorClientConfiguration());
    }

    public WorkflowClient(ConductorClient client, ConductorClientConfiguration config) {
        this.client = client;
        this.payloadStorage = new PayloadStorage(client);
        this.conductorClientConfiguration = config;
    }

    @Deprecated
    public void setRootURI(String rootUri) {
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = new ConductorClient(rootUri);
        this.payloadStorage = new PayloadStorage(this.client);
    }

    public void registerListener(WorkflowClientListener listener) {
        ListenerRegister.register(listener, this.eventDispatcher);
    }

    public String startWorkflow(StartWorkflowRequest startWorkflowRequest) {
        Validate.notNull((Object)startWorkflowRequest, (String)"StartWorkflowRequest cannot be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)startWorkflowRequest.getName(), (String)"Workflow name cannot be null or empty", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)startWorkflowRequest.getExternalInputPayloadStoragePath()), (String)"External Storage Path must not be set", (Object[])new Object[0]);
        if (this.conductorClientConfiguration.isEnforceThresholds()) {
            this.checkAndUploadToExternalStorage(startWorkflowRequest);
        }
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow").body(startWorkflowRequest).build();
        ConductorClientResponse<String> resp = this.client.execute(request, new TypeReference<String>(this){});
        this.eventDispatcher.publish(new WorkflowStartedEvent(startWorkflowRequest.getName(), startWorkflowRequest.getVersion()));
        return resp.getData();
    }

    public void checkAndUploadToExternalStorage(StartWorkflowRequest startWorkflowRequest) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, startWorkflowRequest.getInput());
            byte[] workflowInputBytes = byteArrayOutputStream.toByteArray();
            long workflowInputSize = workflowInputBytes.length;
            this.eventDispatcher.publish(new WorkflowInputPayloadSizeEvent(startWorkflowRequest.getName(), startWorkflowRequest.getVersion(), workflowInputSize));
            if (workflowInputSize > (long)this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB() * 1024L) {
                if (!this.conductorClientConfiguration.isExternalPayloadStorageEnabled() || workflowInputSize > (long)this.conductorClientConfiguration.getWorkflowInputMaxPayloadThresholdKB() * 1024L) {
                    String errorMsg = String.format("Input payload larger than the allowed threshold of: %d KB", this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB());
                    throw new ConductorClientException(errorMsg);
                }
                this.eventDispatcher.publish(new WorkflowPayloadUsedEvent(startWorkflowRequest.getName(), startWorkflowRequest.getVersion(), ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT.name()));
                String externalStoragePath = this.uploadToExternalPayloadStorage(workflowInputBytes, workflowInputSize);
                startWorkflowRequest.setExternalInputPayloadStoragePath(externalStoragePath);
                startWorkflowRequest.setInput(null);
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to start workflow:%s, version:%s", startWorkflowRequest.getName(), startWorkflowRequest.getVersion());
            log.error(errorMsg, (Throwable)e);
            this.eventDispatcher.publish(new WorkflowStartedEvent(startWorkflowRequest.getName(), startWorkflowRequest.getVersion(), false, e));
            throw new ConductorClientException(e);
        }
    }

    private String uploadToExternalPayloadStorage(byte[] payloadBytes, long payloadSize) {
        ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.WRITE, ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT, "");
        this.payloadStorage.upload(externalStorageLocation.getUri(), new ByteArrayInputStream(payloadBytes), payloadSize);
        return externalStorageLocation.getPath();
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/{workflowId}").addPathParam("workflowId", workflowId).addQueryParam("includeTasks", includeTasks).build();
        ConductorClientResponse<Workflow> resp = this.client.execute(request, new TypeReference<Workflow>(this){});
        Workflow workflow = resp.getData();
        this.populateWorkflowOutput(workflow);
        return workflow;
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Validate.notBlank((CharSequence)name, (String)"name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)correlationId, (String)"correlationId cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/{name}/correlated/{correlationId}").addPathParam("name", name).addPathParam("correlationId", correlationId).addQueryParam("includeClosed", includeClosed).addQueryParam("includeTasks", includeTasks).build();
        ConductorClientResponse<List<Workflow>> resp = this.client.execute(request, new TypeReference<List<Workflow>>(this){});
        List<Workflow> workflows = resp.getData();
        workflows.forEach(this::populateWorkflowOutput);
        return workflows;
    }

    public void deleteWorkflow(String workflowId, boolean archiveWorkflow) {
        Validate.notBlank((CharSequence)workflowId, (String)"Workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/workflow/{workflowId}/remove").addPathParam("workflowId", workflowId).addQueryParam("archiveWorkflow", archiveWorkflow).build();
        this.client.execute(request);
    }

    public BulkResponse terminateWorkflows(List<String> workflowIds, String reason) {
        Validate.isTrue((!workflowIds.isEmpty() ? 1 : 0) != 0, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/bulk/terminate").addQueryParam("reason", reason).body(workflowIds).build();
        ConductorClientResponse<BulkResponse> resp = this.client.execute(request, new TypeReference<BulkResponse>(this){});
        return resp.getData();
    }

    public List<String> getRunningWorkflow(String workflowName, Integer version) {
        return this.getRunningWorkflow(workflowName, version, null, null);
    }

    public List<String> getWorkflowsByTimePeriod(String workflowName, int version, Long startTime, Long endTime) {
        Validate.notBlank((CharSequence)workflowName, (String)"Workflow name cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)startTime, (String)"Start time cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"End time cannot be null", (Object[])new Object[0]);
        return this.getRunningWorkflow(workflowName, version, startTime, endTime);
    }

    public void runDecider(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/workflow/decide/{workflowId}").addPathParam("workflowId", workflowId).build();
        this.client.execute(request);
    }

    public void pauseWorkflow(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/workflow/{workflowId}/pause").addPathParam("workflowId", workflowId).build();
        this.client.execute(request);
    }

    public void resumeWorkflow(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/workflow/{workflowId}/resume").addPathParam("workflowId", workflowId).build();
        this.client.execute(request);
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskReferenceName, (String)"Task reference name cannot be blank", (Object[])new Object[0]);
        SkipTaskRequest skipTaskRequest = new SkipTaskRequest();
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.PUT).path("/workflow/{workflowId}/skiptask/{taskReferenceName}").addPathParam("workflowId", workflowId).addPathParam("taskReferenceName", taskReferenceName).body(skipTaskRequest).build();
        this.client.execute(request);
    }

    public String rerunWorkflow(String workflowId, RerunWorkflowRequest rerunWorkflowRequest) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)rerunWorkflowRequest, (String)"RerunWorkflowRequest cannot be null", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/{workflowId}/rerun").addPathParam("workflowId", workflowId).body(rerunWorkflowRequest).build();
        ConductorClientResponse<String> resp = this.client.execute(request, new TypeReference<String>(this){});
        return resp.getData();
    }

    public void restart(String workflowId, boolean useLatestDefinitions) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/{workflowId}/restart").addPathParam("workflowId", workflowId).addQueryParam("useLatestDefinitions", useLatestDefinitions).build();
        this.client.execute(request);
    }

    public void retryLastFailedTask(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/{workflowId}/retry").addPathParam("workflowId", workflowId).build();
        this.client.execute(request);
    }

    public void resetCallbacksForInProgressTasks(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/{workflowId}/resetcallbacks").addPathParam("workflowId", workflowId).build();
        this.client.execute(request);
    }

    public void terminateWorkflow(String workflowId, String reason) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.DELETE).path("/workflow/{workflowId}").addPathParam("workflowId", workflowId).addQueryParam("reason", reason).build();
        this.client.execute(request);
    }

    public SearchResult<WorkflowSummary> search(String query) {
        return this.search(null, null, null, "", query);
    }

    public SearchResult<Workflow> searchV2(String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/search-v2").addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<Workflow>> resp = this.client.execute(request, new TypeReference<SearchResult<Workflow>>(this){});
        return resp.getData();
    }

    public SearchResult<WorkflowSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/search").addQueryParam("start", start).addQueryParam("size", size).addQueryParam("sort", sort).addQueryParam("freeText", freeText).addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<WorkflowSummary>> resp = this.client.execute(request, new TypeReference<SearchResult<WorkflowSummary>>(this){});
        return resp.getData();
    }

    public SearchResult<Workflow> searchV2(Integer start, Integer size, String sort, String freeText, String query) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/search-v2").addQueryParam("start", start).addQueryParam("size", size).addQueryParam("sort", sort).addQueryParam("freeText", freeText).addQueryParam("query", query).build();
        ConductorClientResponse<SearchResult<Workflow>> resp = this.client.execute(request, new TypeReference<SearchResult<Workflow>>(this){});
        return resp.getData();
    }

    public Workflow testWorkflow(WorkflowTestRequest testRequest) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.POST).path("/workflow/test").body(testRequest).build();
        ConductorClientResponse<Workflow> resp = this.client.execute(request, new TypeReference<Workflow>(this){});
        return resp.getData();
    }

    public void populateWorkflowOutput(Workflow workflow) {
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalOutputPayloadStoragePath())) {
            this.eventDispatcher.publish(new WorkflowPayloadUsedEvent(workflow.getWorkflowName(), workflow.getWorkflowVersion(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT.name()));
            workflow.setOutput(this.downloadFromExternalStorage(workflow.getExternalOutputPayloadStoragePath()));
        }
    }

    private Map<String, Object> downloadFromExternalStorage(String path) {
        Map map;
        block8: {
            Validate.notBlank((CharSequence)path, (String)"uri cannot be blank", (Object[])new Object[0]);
            ExternalStorageLocation externalStorageLocation = this.payloadStorage.getLocation(ExternalPayloadStorage.Operation.READ, ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT, path);
            InputStream inputStream = this.payloadStorage.download(externalStorageLocation.getUri());
            try {
                map = (Map)this.objectMapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMsg = String.format("Unable to download payload from external storage location: %s", path);
                    log.error(errorMsg, (Throwable)e);
                    throw new ConductorClientException(e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private List<String> getRunningWorkflow(String name, Integer version, Long startTime, Long endTime) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/workflow/running/{name}").addPathParam("name", name).addQueryParam("version", version).addQueryParam("startTime", startTime).addQueryParam("endTime", endTime).build();
        ConductorClientResponse<List<String>> resp = this.client.execute(request, new TypeReference<List<String>>(this){});
        return resp.getData();
    }
}

