/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.events.taskrunner;

import com.netflix.conductor.client.events.taskrunner.TaskRunnerEvent;
import java.time.Duration;

public final class TaskExecutionCompleted
extends TaskRunnerEvent {
    public final String taskId;
    public final String workerId;
    private final Duration duration;

    public TaskExecutionCompleted(String taskType, String taskId, String workerId, long durationInMillis) {
        super(taskType);
        this.taskId = taskId;
        this.workerId = workerId;
        this.duration = Duration.ofMillis(durationInMillis);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public String toString() {
        return "TaskExecutionCompleted(taskId=" + this.getTaskId() + ", workerId=" + this.getWorkerId() + ", duration=" + this.getDuration() + ")";
    }
}

