/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.StateChangeEvent;
import com.netflix.conductor.common.metadata.workflow.SubWorkflowParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowTask {
    private String name;
    private String taskReferenceName;
    private String description;
    private Map<String, Object> inputParameters = new HashMap<String, Object>();
    private String type = TaskType.SIMPLE.name();
    private String dynamicTaskNameParam;
    private String caseValueParam;
    private String caseExpression;
    private String scriptExpression;
    private Map<String, List<WorkflowTask>> decisionCases = new LinkedHashMap<String, List<WorkflowTask>>();
    private String dynamicForkJoinTasksParam;
    private String dynamicForkTasksParam;
    private String dynamicForkTasksInputParamName;
    private List<WorkflowTask> defaultCase = new LinkedList<WorkflowTask>();
    private List<List<WorkflowTask>> forkTasks = new LinkedList<List<WorkflowTask>>();
    private int startDelay;
    private SubWorkflowParams subWorkflowParam;
    private List<String> joinOn = new LinkedList<String>();
    private String sink;
    private boolean optional = false;
    private TaskDef taskDefinition;
    private Boolean rateLimited;
    private List<String> defaultExclusiveJoinTask = new LinkedList<String>();
    private Boolean asyncComplete = false;
    private String loopCondition;
    private List<WorkflowTask> loopOver = new LinkedList<WorkflowTask>();
    private Integer retryCount;
    private String evaluatorType;
    private String expression;
    private Map<String, List<StateChangeEvent>> onStateChange = new HashMap<String, List<StateChangeEvent>>();
    private String joinStatus;
    private CacheConfig cacheConfig;
    private boolean permissive;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public String getType() {
        return this.type;
    }

    public void setWorkflowTaskType(TaskType type2) {
        this.type = type2.name();
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public Map<String, List<WorkflowTask>> getDecisionCases() {
        return this.decisionCases;
    }

    public void setDecisionCases(Map<String, List<WorkflowTask>> decisionCases) {
        this.decisionCases = decisionCases;
    }

    public List<WorkflowTask> getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(List<WorkflowTask> defaultCase) {
        this.defaultCase = defaultCase;
    }

    public List<List<WorkflowTask>> getForkTasks() {
        return this.forkTasks;
    }

    public void setForkTasks(List<List<WorkflowTask>> forkTasks) {
        this.forkTasks = forkTasks;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public String getDynamicTaskNameParam() {
        return this.dynamicTaskNameParam;
    }

    public void setDynamicTaskNameParam(String dynamicTaskNameParam) {
        this.dynamicTaskNameParam = dynamicTaskNameParam;
    }

    @Deprecated
    public String getCaseValueParam() {
        return this.caseValueParam;
    }

    @Deprecated
    public String getDynamicForkJoinTasksParam() {
        return this.dynamicForkJoinTasksParam;
    }

    @Deprecated
    public void setDynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
    }

    public String getDynamicForkTasksParam() {
        return this.dynamicForkTasksParam;
    }

    public void setDynamicForkTasksParam(String dynamicForkTasksParam) {
        this.dynamicForkTasksParam = dynamicForkTasksParam;
    }

    public String getDynamicForkTasksInputParamName() {
        return this.dynamicForkTasksInputParamName;
    }

    public void setDynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
    }

    @Deprecated
    public void setCaseValueParam(String caseValueParam) {
        this.caseValueParam = caseValueParam;
    }

    @Deprecated
    public String getCaseExpression() {
        return this.caseExpression;
    }

    @Deprecated
    public void setCaseExpression(String caseExpression) {
        this.caseExpression = caseExpression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public void setScriptExpression(String expression) {
        this.scriptExpression = expression;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public SubWorkflowParams getSubWorkflowParam() {
        return this.subWorkflowParam;
    }

    public void setSubWorkflowParam(SubWorkflowParams subWorkflow) {
        this.subWorkflowParam = subWorkflow;
    }

    public List<String> getJoinOn() {
        return this.joinOn;
    }

    public void setJoinOn(List<String> joinOn) {
        this.joinOn = joinOn;
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public void setLoopCondition(String loopCondition) {
        this.loopCondition = loopCondition;
    }

    public List<WorkflowTask> getLoopOver() {
        return this.loopOver;
    }

    public void setLoopOver(List<WorkflowTask> loopOver) {
        this.loopOver = loopOver;
    }

    public String getSink() {
        return this.sink;
    }

    public void setSink(String sink2) {
        this.sink = sink2;
    }

    public Boolean isAsyncComplete() {
        return this.asyncComplete;
    }

    public void setAsyncComplete(Boolean asyncComplete) {
        this.asyncComplete = asyncComplete;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TaskDef getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDef taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Boolean getRateLimited() {
        return this.rateLimited;
    }

    public void setRateLimited(Boolean rateLimited) {
        this.rateLimited = rateLimited;
    }

    public Boolean isRateLimited() {
        return this.rateLimited != null && this.rateLimited != false;
    }

    public List<String> getDefaultExclusiveJoinTask() {
        return this.defaultExclusiveJoinTask;
    }

    public void setDefaultExclusiveJoinTask(List<String> defaultExclusiveJoinTask) {
        this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
    }

    public String getEvaluatorType() {
        return this.evaluatorType;
    }

    public void setEvaluatorType(String evaluatorType) {
        this.evaluatorType = evaluatorType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getJoinStatus() {
        return this.joinStatus;
    }

    public void setJoinStatus(String joinStatus) {
        this.joinStatus = joinStatus;
    }

    public boolean isPermissive() {
        return this.permissive;
    }

    public void setPermissive(boolean permissive) {
        this.permissive = permissive;
    }

    private Collection<List<WorkflowTask>> children() {
        LinkedList<List<WorkflowTask>> workflowTaskLists = new LinkedList<List<WorkflowTask>>();
        switch (TaskType.of(this.type)) {
            case DECISION: 
            case SWITCH: {
                workflowTaskLists.addAll(this.decisionCases.values());
                workflowTaskLists.add(this.defaultCase);
                break;
            }
            case FORK_JOIN: {
                workflowTaskLists.addAll(this.forkTasks);
                break;
            }
            case DO_WHILE: {
                workflowTaskLists.add(this.loopOver);
                break;
            }
        }
        return workflowTaskLists;
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        tasks.add(this);
        for (List<WorkflowTask> workflowTaskList : this.children()) {
            for (WorkflowTask workflowTask : workflowTaskList) {
                tasks.addAll(workflowTask.collectTasks());
            }
        }
        return tasks;
    }

    public WorkflowTask next(String taskReferenceName, WorkflowTask parent) {
        TaskType taskType = TaskType.of(this.type);
        switch (taskType) {
            case DECISION: 
            case SWITCH: 
            case DO_WHILE: {
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    WorkflowTask task;
                    Iterator<WorkflowTask> iterator2 = workflowTasks.iterator();
                    while (iterator2.hasNext() && !(task = iterator2.next()).getTaskReferenceName().equals(taskReferenceName)) {
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (!iterator2.hasNext()) continue;
                    return iterator2.next();
                }
                if (taskType != TaskType.DO_WHILE || !this.has(taskReferenceName)) break;
                return this;
            }
            case FORK_JOIN: {
                boolean found = false;
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    Iterator<WorkflowTask> iterator3 = workflowTasks.iterator();
                    while (iterator3.hasNext()) {
                        WorkflowTask task = iterator3.next();
                        if (task.getTaskReferenceName().equals(taskReferenceName)) {
                            found = true;
                            break;
                        }
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (iterator3.hasNext()) {
                        return iterator3.next();
                    }
                    if (!found || parent == null) continue;
                    return parent.next(this.taskReferenceName, parent);
                }
                break;
            }
            case DYNAMIC: 
            case TERMINATE: 
            case SIMPLE: {
                return null;
            }
        }
        return null;
    }

    public boolean has(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        switch (TaskType.of(this.type)) {
            case DECISION: 
            case SWITCH: 
            case FORK_JOIN: 
            case DO_WHILE: {
                for (List<WorkflowTask> childx : this.children()) {
                    for (WorkflowTask child : childx) {
                        if (!child.has(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public WorkflowTask get(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return this;
        }
        for (List<WorkflowTask> childx : this.children()) {
            for (WorkflowTask child : childx) {
                WorkflowTask found = child.get(taskReferenceName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public Map<String, List<StateChangeEvent>> getOnStateChange() {
        return this.onStateChange;
    }

    public void setOnStateChange(Map<String, List<StateChangeEvent>> onStateChange) {
        this.onStateChange = onStateChange;
    }

    public String toString() {
        return this.name + "/" + this.taskReferenceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTask that = (WorkflowTask)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.taskReferenceName, that.taskReferenceName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.taskReferenceName);
    }

    public static class CacheConfig {
        private String key;
        private int ttlInSecond;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getTtlInSecond() {
            return this.ttlInSecond;
        }

        public void setTtlInSecond(int ttlInSecond) {
            this.ttlInSecond = ttlInSecond;
        }
    }

    public static class WorkflowTaskList {
        private List<WorkflowTask> tasks;

        public List<WorkflowTask> getTasks() {
            return this.tasks;
        }

        public void setTasks(List<WorkflowTask> tasks) {
            this.tasks = tasks;
        }
    }
}

