/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public class TaskResult {
    private String workflowInstanceId;
    private String taskId;
    private String reasonForIncompletion;
    private long callbackAfterSeconds;
    private String workerId;
    private Status status;
    private Map<String, Object> outputData = new HashMap<String, Object>();
    private List<TaskExecLog> logs = new CopyOnWriteArrayList<TaskExecLog>();
    private String externalOutputPayloadStoragePath;
    private String subWorkflowId;
    private boolean extendLease;

    public TaskResult(Task task) {
        this.workflowInstanceId = task.getWorkflowInstanceId();
        this.taskId = task.getTaskId();
        this.reasonForIncompletion = task.getReasonForIncompletion();
        this.callbackAfterSeconds = task.getCallbackAfterSeconds();
        this.workerId = task.getWorkerId();
        this.outputData = task.getOutputData();
        this.externalOutputPayloadStoragePath = task.getExternalOutputPayloadStoragePath();
        this.subWorkflowId = task.getSubWorkflowId();
        switch (task.getStatus()) {
            case CANCELED: 
            case COMPLETED_WITH_ERRORS: 
            case TIMED_OUT: 
            case SKIPPED: {
                this.status = Status.FAILED;
                break;
            }
            case SCHEDULED: {
                this.status = Status.IN_PROGRESS;
                break;
            }
            default: {
                this.status = Status.valueOf(task.getStatus().name());
            }
        }
    }

    public TaskResult() {
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = StringUtils.substring((String)reasonForIncompletion, (int)0, (int)500);
    }

    public long getCallbackAfterSeconds() {
        return this.callbackAfterSeconds;
    }

    public void setCallbackAfterSeconds(long callbackAfterSeconds) {
        this.callbackAfterSeconds = callbackAfterSeconds;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(Map<String, Object> outputData) {
        this.outputData = outputData;
    }

    public TaskResult addOutputData(String key, Object value) {
        this.outputData.put(key, value);
        return this;
    }

    public List<TaskExecLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<TaskExecLog> logs) {
        this.logs = logs;
    }

    public TaskResult log(String log) {
        this.logs.add(new TaskExecLog(log));
        return this;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public String getSubWorkflowId() {
        return this.subWorkflowId;
    }

    public void setSubWorkflowId(String subWorkflowId) {
        this.subWorkflowId = subWorkflowId;
    }

    public boolean isExtendLease() {
        return this.extendLease;
    }

    public void setExtendLease(boolean extendLease) {
        this.extendLease = extendLease;
    }

    public String toString() {
        return "TaskResult{workflowInstanceId='" + this.workflowInstanceId + "', taskId='" + this.taskId + "', reasonForIncompletion='" + this.reasonForIncompletion + "', callbackAfterSeconds=" + this.callbackAfterSeconds + ", workerId='" + this.workerId + "', status=" + this.status + ", outputData=" + this.outputData + ", logs=" + this.logs + ", externalOutputPayloadStoragePath='" + this.externalOutputPayloadStoragePath + "', subWorkflowId='" + this.subWorkflowId + "', extendLease='" + this.extendLease + "'}";
    }

    public static TaskResult complete() {
        return TaskResult.newTaskResult(Status.COMPLETED);
    }

    public static TaskResult failed() {
        return TaskResult.newTaskResult(Status.FAILED);
    }

    public static TaskResult failed(String failureReason) {
        TaskResult result = TaskResult.newTaskResult(Status.FAILED);
        result.setReasonForIncompletion(failureReason);
        return result;
    }

    public static TaskResult inProgress() {
        return TaskResult.newTaskResult(Status.IN_PROGRESS);
    }

    public static TaskResult newTaskResult(Status status) {
        TaskResult result = new TaskResult();
        result.setStatus(status);
        return result;
    }

    public static enum Status {
        IN_PROGRESS,
        FAILED,
        FAILED_WITH_TERMINAL_ERROR,
        COMPLETED;

    }
}

