/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.exception;

import com.netflix.conductor.common.validation.ValidationError;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConductorClientException
extends RuntimeException {
    private int status;
    private String instance;
    private String code;
    private boolean retryable;
    private List<ValidationError> validationErrors;
    private Map<String, List<String>> responseHeaders;
    private String responseBody;

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public ConductorClientException() {
    }

    public ConductorClientException(Throwable throwable) {
        super(throwable.getMessage(), throwable);
    }

    public ConductorClientException(String message) {
        super(message);
    }

    public ConductorClientException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.setCode(String.valueOf(code));
        this.setStatus(code);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ConductorClientException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
        this.setCode(String.valueOf(code));
        this.setStatus(code);
    }

    public ConductorClientException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
        this.setCode(String.valueOf(code));
        this.setStatus(code);
    }

    public ConductorClientException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
        this.setCode(String.valueOf(code));
        this.setStatus(code);
    }

    public ConductorClientException(int code, String message) {
        super(message);
        this.setCode(String.valueOf(code));
        this.setStatus(code);
    }

    public ConductorClientException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.setCode(String.valueOf(code));
        this.setStatus(code);
    }

    public boolean isClientError() {
        return this.getStatus() > 399 && this.getStatus() < 499;
    }

    public int getStatusCode() {
        return this.getStatus();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String getMessage() {
        return this.getStatusCode() + ": " + (StringUtils.isBlank(this.responseBody) ? super.getMessage() : this.responseBody);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(": ");
        if (this.getMessage() != null) {
            builder.append(this.getMessage());
        }
        if (this.status > 0) {
            builder.append(" {status=").append(this.status);
            if (this.code != null) {
                builder.append(", code='").append(this.code).append("'");
            }
            builder.append(", retryable: ").append(this.retryable);
        }
        if (this.instance != null) {
            builder.append(", instance: ").append(this.instance);
        }
        if (this.validationErrors != null) {
            builder.append(", validationErrors: ").append(this.validationErrors);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public void setRetryable(boolean retryable) {
        this.retryable = retryable;
    }

    public int getStatus() {
        return this.status;
    }
}

