/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.client.http.ConnectionPoolConfig;
import com.netflix.conductor.client.http.HeaderSupplier;
import com.netflix.conductor.client.http.Param;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConductorClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConductorClient.class);
    protected final OkHttpClient okHttpClient;
    protected final String basePath;
    protected final ObjectMapper objectMapper;
    private final boolean verifyingSsl;
    private final InputStream sslCaCert;
    private final KeyManager[] keyManagers;
    private final List<HeaderSupplier> headerSuppliers;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected ConductorClient(Builder<?> builder) {
        ConnectionPoolConfig connectionPoolConfig;
        builder.validateAndAssignDefaults();
        OkHttpClient.Builder okHttpBuilder = builder.okHttpClientBuilder;
        this.objectMapper = builder.objectMapperSupplier.get();
        this.basePath = builder.basePath;
        this.verifyingSsl = builder.verifyingSsl;
        this.sslCaCert = builder.sslCaCert;
        this.keyManagers = builder.keyManagers;
        this.headerSuppliers = builder.headerSupplier();
        if (builder.connectTimeout > -1L) {
            okHttpBuilder.connectTimeout(builder.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (builder.readTimeout > -1L) {
            okHttpBuilder.readTimeout(builder.readTimeout, TimeUnit.MILLISECONDS);
        }
        if (builder.writeTimeout > -1L) {
            okHttpBuilder.writeTimeout(builder.writeTimeout, TimeUnit.MILLISECONDS);
        }
        if (builder.callTimeout > -1L) {
            okHttpBuilder.callTimeout(builder.callTimeout, TimeUnit.MILLISECONDS);
        }
        if (builder.proxy != null) {
            okHttpBuilder.proxy(builder.proxy);
        }
        if ((connectionPoolConfig = builder.connectionPoolConfig) != null) {
            okHttpBuilder.connectionPool(new ConnectionPool(connectionPoolConfig.getMaxIdleConnections(), connectionPoolConfig.getKeepAliveDuration(), connectionPoolConfig.getTimeUnit()));
        }
        if (!this.verifyingSsl) {
            ConductorClient.unsafeClient(okHttpBuilder);
        } else if (this.sslCaCert != null) {
            this.trustCertificates(okHttpBuilder);
        }
        this.okHttpClient = okHttpBuilder.build();
        this.headerSuppliers.forEach(it -> it.init(this));
    }

    public ConductorClient() {
        this(new Builder());
    }

    public ConductorClient(String basePath) {
        this((Builder<?>)new Builder().basePath(basePath));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        if (this.okHttpClient.cache() != null) {
            try {
                this.okHttpClient.cache().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ConductorClientResponse<Void> execute(ConductorClientRequest req) {
        return this.execute(req, null);
    }

    public <T> ConductorClientResponse<T> execute(ConductorClientRequest req, TypeReference<T> typeReference) {
        HashMap<String, String> headerParams = req.getHeaderParams() == null ? new HashMap<String, String>() : new HashMap<String, String>(req.getHeaderParams());
        ArrayList<Param> pathParams = req.getPathParams() == null ? new ArrayList<Param>() : new ArrayList<Param>(req.getPathParams());
        ArrayList<Param> queryParams = req.getQueryParams() == null ? new ArrayList<Param>() : new ArrayList<Param>(req.getQueryParams());
        Request request = this.buildRequest(req.getMethod().toString(), req.getPath(), pathParams, queryParams, headerParams, req.getBody());
        Call call = this.okHttpClient.newCall(request);
        if (typeReference == null) {
            this.execute(call, null);
            return null;
        }
        return this.execute(call, typeReference.getType());
    }

    private String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(o);
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    private boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    private String urlEncode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    private <T> T deserialize(Response response, Type returnType) {
        if (returnType == null) {
            return null;
        }
        String body = this.bodyAsString(response);
        if (body == null || "".equals(body)) {
            return null;
        }
        String contentType = response.header("Content-Type");
        if (contentType == null || this.isJsonMime(contentType)) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(returnType);
            return this.objectMapper.readValue(body, javaType);
        }
        if (returnType.equals(String.class)) {
            return (T)body;
        }
        throw new ConductorClientException("Content type \"" + contentType + "\" is not supported for type: " + String.valueOf(returnType), response.code(), response.headers().toMultimap(), body);
    }

    @Nullable
    private String bodyAsString(Response response) {
        if (response.body() == null) {
            return null;
        }
        try {
            return response.body().string();
        }
        catch (IOException e) {
            throw new ConductorClientException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
        }
    }

    private RequestBody serialize(String contentType, @NotNull Object body) {
        if (!this.isJsonMime(contentType)) {
            throw new ConductorClientException("Content type \"" + contentType + "\" is not supported");
        }
        String content = body instanceof String ? (String)body : this.objectMapper.writeValueAsString(body);
        return RequestBody.create(content, MediaType.parse(contentType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T handleResponse(Response response, Type returnType) {
        if (!response.isSuccessful()) {
            String respBody = this.bodyAsString(response);
            throw new ConductorClientException(response.message(), response.code(), response.headers().toMultimap(), respBody);
        }
        try {
            if (returnType == null || response.code() == 204) {
                T t2 = null;
                return t2;
            }
            T t3 = this.deserialize(response, returnType);
            return t3;
        }
        finally {
            if (response.body() != null) {
                response.body().close();
            }
        }
    }

    protected Request buildRequest(String method, String path, List<Param> pathParams, List<Param> queryParams, Map<String, String> headers, Object body) {
        HttpUrl url = this.buildUrl(this.replacePathParams(path, pathParams), queryParams);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        this.processHeaderParams(requestBuilder, this.addHeadersFromProviders(method, path, headers));
        RequestBody reqBody = this.requestBody(method, ConductorClient.getContentType(headers), body);
        return requestBuilder.method(method, reqBody).build();
    }

    private Map<String, String> addHeadersFromProviders(String method, String path, Map<String, String> headers) {
        if (this.headerSuppliers.isEmpty()) {
            return headers;
        }
        HashMap<String, String> all = new HashMap<String, String>();
        for (HeaderSupplier supplier : this.headerSuppliers) {
            all.putAll(supplier.get(method, path));
        }
        all.putAll(headers);
        return all;
    }

    @NotNull
    private static String getContentType(Map<String, String> headerParams) {
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        return contentType;
    }

    private String replacePathParams(String path, List<Param> pathParams) {
        for (Param param : pathParams) {
            path = path.replace("{" + param.name() + "}", this.urlEncode(param.value()));
        }
        return path;
    }

    @Nullable
    private RequestBody requestBody(String method, String contentType, Object body) {
        if (!HttpMethod.permitsRequestBody(method)) {
            return null;
        }
        if (body == null && "DELETE".equals(method)) {
            return null;
        }
        if (body == null) {
            return RequestBody.create("", MediaType.parse(contentType));
        }
        return this.serialize(contentType, body);
    }

    private HttpUrl buildUrl(String path, List<Param> queryParams) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse(this.basePath + path)).newBuilder();
        for (Param param : queryParams) {
            urlBuilder.addQueryParameter(param.name(), param.value());
        }
        return urlBuilder.build();
    }

    private void processHeaderParams(Request.Builder requestBuilder, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            requestBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    private static void unsafeClient(OkHttpClient.Builder okhttpClientBuilder) {
        LOGGER.warn("Unsafe client - Disabling SSL certificate validation is dangerous and should only be used in development environments");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        okhttpClientBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        okhttpClientBuilder.hostnameVerifier((hostname, session) -> true);
    }

    private void trustCertificates(OkHttpClient.Builder okhttpClientBuilder) throws GeneralSecurityException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty set of trusted certificates");
        }
        KeyStore caKeyStore = this.newEmptyKeyStore(null);
        int index = 0;
        for (Certificate certificate : certificates) {
            String certificateAlias = "ca" + index++;
            caKeyStore.setCertificateEntry(certificateAlias, certificate);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers, trustManagerArray, new SecureRandom());
        okhttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagerArray[0]);
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> ConductorClientResponse<T> execute(Call call, Type returnType) {
        try {
            Response response = call.execute();
            T data2 = this.handleResponse(response, returnType);
            return new ConductorClientResponse<T>(response.code(), response.headers().toMultimap(), data2);
        }
        catch (IOException e) {
            throw new ConductorClientException(e);
        }
    }

    public static class Builder<T extends Builder<T>> {
        private final OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        private String basePath = "http://localhost:8080/api";
        private boolean verifyingSsl = true;
        private InputStream sslCaCert;
        private KeyManager[] keyManagers;
        private long connectTimeout = -1L;
        private long readTimeout = -1L;
        private long writeTimeout = -1L;
        private long callTimeout = -1L;
        private Proxy proxy;
        private ConnectionPoolConfig connectionPoolConfig;
        private Supplier<ObjectMapper> objectMapperSupplier = () -> new ObjectMapperProvider().getObjectMapper();
        private final List<HeaderSupplier> headerSuppliers = new ArrayList<HeaderSupplier>();
        private boolean useEnvVariables = false;

        protected T self() {
            return (T)this;
        }

        public T basePath(String basePath) {
            this.basePath = basePath;
            return this.self();
        }

        public T verifyingSsl(boolean verifyingSsl) {
            this.verifyingSsl = verifyingSsl;
            return this.self();
        }

        public T sslCaCert(InputStream sslCaCert) {
            this.sslCaCert = sslCaCert;
            return this.self();
        }

        public T keyManagers(KeyManager[] keyManagers) {
            this.keyManagers = keyManagers;
            return this.self();
        }

        public T connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public T readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        public T writeTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this.self();
        }

        public T callTimeout(long callTimeout) {
            this.callTimeout = callTimeout;
            return this.self();
        }

        public T proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.self();
        }

        public T connectionPoolConfig(ConnectionPoolConfig config) {
            this.connectionPoolConfig = config;
            return this.self();
        }

        public T configureOkHttp(Consumer<OkHttpClient.Builder> configurer) {
            configurer.accept(this.okHttpClientBuilder);
            return this.self();
        }

        public T objectMapperSupplier(Supplier<ObjectMapper> objectMapperSupplier) {
            this.objectMapperSupplier = objectMapperSupplier;
            return this.self();
        }

        public T addHeaderSupplier(HeaderSupplier headerSupplier) {
            this.headerSuppliers.add(headerSupplier);
            return this.self();
        }

        protected List<HeaderSupplier> headerSupplier() {
            return this.headerSuppliers;
        }

        public T useEnvVariables(boolean useEnvVariables) {
            this.useEnvVariables = useEnvVariables;
            return this.self();
        }

        protected boolean isUseEnvVariables() {
            return this.useEnvVariables;
        }

        public ConductorClient build() {
            if (this.useEnvVariables) {
                this.applyEnvVariables();
            }
            return new ConductorClient(this);
        }

        protected void validateAndAssignDefaults() {
            if (StringUtils.isBlank(this.basePath)) {
                throw new IllegalArgumentException("basePath cannot be blank");
            }
            if (this.basePath.endsWith("/")) {
                this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
            }
        }

        protected void applyEnvVariables() {
            String conductorServerUrl = System.getenv("CONDUCTOR_SERVER_URL");
            if (conductorServerUrl == null) {
                throw new RuntimeException("env variable CONDUCTOR_SERVER_URL is not set");
            }
            this.basePath(conductorServerUrl);
        }
    }
}

