/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkResponse<T> {
    private final Map<String, String> bulkErrorResults;
    private final List<T> bulkSuccessfulResults = new ArrayList<T>();
    private final String message = "Bulk Request has been processed.";

    public BulkResponse() {
        this.bulkErrorResults = new HashMap<String, String>();
    }

    public List<T> getBulkSuccessfulResults() {
        return this.bulkSuccessfulResults;
    }

    public Map<String, String> getBulkErrorResults() {
        return this.bulkErrorResults;
    }

    public void appendSuccessResponse(T result2) {
        this.bulkSuccessfulResults.add(result2);
    }

    public void appendFailedResponse(String id, String errorMessage2) {
        this.bulkErrorResults.put(id, errorMessage2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkResponse)) {
            return false;
        }
        BulkResponse that = (BulkResponse)o;
        return Objects.equals(this.bulkSuccessfulResults, that.bulkSuccessfulResults) && Objects.equals(this.bulkErrorResults, that.bulkErrorResults);
    }

    public int hashCode() {
        return Objects.hash(this.bulkSuccessfulResults, this.bulkErrorResults, "Bulk Request has been processed.");
    }

    public String toString() {
        return "BulkResponse{bulkSuccessfulResults=" + String.valueOf(this.bulkSuccessfulResults) + ", bulkErrorResults=" + String.valueOf(this.bulkErrorResults) + ", message='Bulk Request has been processed.'}";
    }
}

