/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.events.dispatcher;

import com.netflix.conductor.client.events.ConductorClientEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventDispatcher<T extends ConductorClientEvent> {
    private final Map<Class<? extends T>, List<Consumer<? extends T>>> listeners = new ConcurrentHashMap<Class<? extends T>, List<Consumer<? extends T>>>();

    public <U extends T> void register(Class<U> clazz, Consumer<U> listener) {
        this.listeners.computeIfAbsent(clazz, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public <U extends T> void unregister(Class<U> clazz, Consumer<U> listener) {
        List<Consumer<T>> consumers = this.listeners.get(clazz);
        if (consumers != null) {
            consumers.remove(listener);
            if (consumers.isEmpty()) {
                this.listeners.remove(clazz);
            }
        }
    }

    public void publish(T event) {
        if (this.noListeners(event)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            List<Consumer<ConductorClientEvent>> eventListeners = this.getEventListeners(event);
            for (Consumer<ConductorClientEvent> listener : eventListeners) {
                listener.accept((ConductorClientEvent)event);
            }
        });
    }

    private boolean noListeners(T event) {
        if (this.listeners.isEmpty()) {
            return true;
        }
        List<Consumer<T>> specificEventListeners = this.listeners.get(event.getClass());
        List<Consumer<T>> promiscuousListeners = this.listeners.get(ConductorClientEvent.class);
        return !(specificEventListeners != null && !specificEventListeners.isEmpty() || promiscuousListeners != null && !promiscuousListeners.isEmpty());
    }

    private List<Consumer<? extends T>> getEventListeners(T event) {
        List<Consumer<T>> specificEventListeners = this.listeners.get(event.getClass());
        List<Consumer<T>> promiscuousListeners = this.listeners.get(ConductorClientEvent.class);
        if (promiscuousListeners == null || promiscuousListeners.isEmpty()) {
            return specificEventListeners;
        }
        if (specificEventListeners == null || specificEventListeners.isEmpty()) {
            return promiscuousListeners;
        }
        return Stream.concat(specificEventListeners.stream(), promiscuousListeners.stream()).collect(Collectors.toList());
    }
}

