/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Arrays;
import jdk.dynalink.CallSiteDescriptor;
import jdk.dynalink.NamedOperation;
import jdk.dynalink.Operation;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.dynalink.linker.support.Guards;
import org.openjdk.nashorn.internal.runtime.linker.BoundCallable;

final class BoundCallableLinker
implements TypeBasedGuardingDynamicLinker {
    BoundCallableLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type2) {
        return type2 == BoundCallable.class;
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        int firstArgIndex;
        boolean isCall;
        Object objBoundCallable = linkRequest.getReceiver();
        if (!(objBoundCallable instanceof BoundCallable)) {
            return null;
        }
        CallSiteDescriptor descriptor2 = linkRequest.getCallSiteDescriptor();
        Operation operation = NamedOperation.getBaseOperation(descriptor2.getOperation());
        if (operation == StandardOperation.NEW) {
            isCall = false;
        } else if (operation == StandardOperation.CALL) {
            isCall = true;
        } else {
            return null;
        }
        BoundCallable boundCallable = (BoundCallable)objBoundCallable;
        Object callable = boundCallable.getCallable();
        Object boundThis = boundCallable.getBoundThis();
        Object[] args2 = linkRequest.getArguments();
        Object[] boundArgs = boundCallable.getBoundArgs();
        int argsLen = args2.length;
        int boundArgsLen = boundArgs.length;
        Object[] newArgs2 = new Object[argsLen + boundArgsLen];
        newArgs2[0] = callable;
        if (isCall) {
            newArgs2[1] = boundThis;
            firstArgIndex = 2;
        } else {
            firstArgIndex = 1;
        }
        System.arraycopy(boundArgs, 0, newArgs2, firstArgIndex, boundArgsLen);
        System.arraycopy(args2, firstArgIndex, newArgs2, firstArgIndex + boundArgsLen, argsLen - firstArgIndex);
        MethodType type2 = descriptor2.getMethodType();
        MethodType newMethodType = descriptor2.getMethodType().changeParameterType(0, callable.getClass());
        if (isCall) {
            newMethodType = newMethodType.changeParameterType(1, boundThis == null ? Object.class : boundThis.getClass());
        }
        int i = boundArgs.length;
        while (i-- > 0) {
            newMethodType = newMethodType.insertParameterTypes(firstArgIndex, boundArgs[i] == null ? Object.class : boundArgs[i].getClass());
        }
        CallSiteDescriptor newDescriptor = descriptor2.changeMethodType(newMethodType);
        GuardedInvocation inv = linkerServices.getGuardedInvocation(linkRequest.replaceArguments(newDescriptor, newArgs2));
        if (inv == null) {
            return null;
        }
        MethodHandle boundHandle = MethodHandles.insertArguments(inv.getInvocation(), 0, Arrays.copyOf(newArgs2, firstArgIndex + boundArgs.length));
        TypeDescriptor.OfField p0Type = type2.parameterType(0);
        MethodHandle droppingHandle = isCall ? MethodHandles.dropArguments(boundHandle, 0, new Class[]{p0Type, type2.parameterType(1)}) : MethodHandles.dropArguments(boundHandle, 0, new Class[]{p0Type});
        MethodHandle newGuard = Guards.getIdentityGuard(boundCallable);
        return inv.replaceMethods(droppingHandle, newGuard.asType(newGuard.type().changeParameterType(0, (Class<?>)p0Type)));
    }
}

