/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;

@ProtoMessage
public class StartWorkflowRequest {
    @ProtoField(id=1)
    @NotNull(message="Workflow name cannot be null or empty")
    private @NotNull(message="Workflow name cannot be null or empty") String name;
    @ProtoField(id=2)
    private Integer version;
    @ProtoField(id=3)
    private String correlationId;
    @ProtoField(id=4)
    private Map<String, Object> input = new HashMap<String, Object>();
    @ProtoField(id=5)
    private Map<String, String> taskToDomain = new HashMap<String, String>();
    @ProtoField(id=6)
    @Valid
    private WorkflowDef workflowDef;
    @ProtoField(id=7)
    private String externalInputPayloadStoragePath;
    @ProtoField(id=8)
    @Min(value=0L, message="priority: ${validatedValue} should be minimum {value}")
    @Max(value=99L, message="priority: ${validatedValue} should be maximum {value}")
    private @Min(value=0L, message="priority: ${validatedValue} should be minimum {value}") @Max(value=99L, message="priority: ${validatedValue} should be maximum {value}") Integer priority = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StartWorkflowRequest withName(String name) {
        this.name = name;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public StartWorkflowRequest withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public StartWorkflowRequest withCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public StartWorkflowRequest withExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public StartWorkflowRequest withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public StartWorkflowRequest withInput(Map<String, Object> input) {
        this.input = input;
        return this;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public StartWorkflowRequest withTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
        return this;
    }

    public WorkflowDef getWorkflowDef() {
        return this.workflowDef;
    }

    public void setWorkflowDef(WorkflowDef workflowDef) {
        this.workflowDef = workflowDef;
    }

    public StartWorkflowRequest withWorkflowDef(WorkflowDef workflowDef) {
        this.workflowDef = workflowDef;
        return this;
    }
}

