/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SummaryUtil {
    private static final Logger logger = LoggerFactory.getLogger(SummaryUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private static boolean isSummaryInputOutputJsonSerializationEnabled;
    @Value(value="${conductor.app.summary-input-output-json-serialization.enabled:false}")
    private boolean isJsonSerializationEnabled;

    @PostConstruct
    public void init() {
        isSummaryInputOutputJsonSerializationEnabled = this.isJsonSerializationEnabled;
    }

    public static String serializeInputOutput(Map<String, Object> object) {
        if (!isSummaryInputOutputJsonSerializationEnabled) {
            return object.toString();
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("The provided value ({}) could not be serialized as Json", (Object)object.toString(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

