/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.run;

import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.utils.SummaryUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@ProtoMessage
public class WorkflowSummary {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    @ProtoField(id=1)
    private String workflowType;
    @ProtoField(id=2)
    private int version;
    @ProtoField(id=3)
    private String workflowId;
    @ProtoField(id=4)
    private String correlationId;
    @ProtoField(id=5)
    private String startTime;
    @ProtoField(id=6)
    private String updateTime;
    @ProtoField(id=7)
    private String endTime;
    @ProtoField(id=8)
    private Workflow.WorkflowStatus status;
    @ProtoField(id=9)
    private String input;
    @ProtoField(id=10)
    private String output;
    @ProtoField(id=11)
    private String reasonForIncompletion;
    @ProtoField(id=12)
    private long executionTime;
    @ProtoField(id=13)
    private String event;
    @ProtoField(id=14)
    private String failedReferenceTaskNames = "";
    @ProtoField(id=15)
    private String externalInputPayloadStoragePath;
    @ProtoField(id=16)
    private String externalOutputPayloadStoragePath;
    @ProtoField(id=17)
    private int priority;
    @ProtoField(id=18)
    private Set<String> failedTaskNames = new HashSet<String>();
    @ProtoField(id=19)
    private String createdBy;
    @ProtoField(id=20)
    private Map<String, String> taskToDomain = new HashMap<String, String>();

    public WorkflowSummary() {
    }

    public WorkflowSummary(Workflow workflow) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(GMT);
        this.workflowType = workflow.getWorkflowName();
        this.version = workflow.getWorkflowVersion();
        this.workflowId = workflow.getWorkflowId();
        this.priority = workflow.getPriority();
        this.correlationId = workflow.getCorrelationId();
        if (workflow.getCreateTime() != null) {
            this.startTime = sdf.format(new Date(workflow.getCreateTime()));
        }
        if (workflow.getEndTime() > 0L) {
            this.endTime = sdf.format(new Date(workflow.getEndTime()));
        }
        if (workflow.getUpdateTime() != null) {
            this.updateTime = sdf.format(new Date(workflow.getUpdateTime()));
        }
        this.status = workflow.getStatus();
        if (workflow.getInput() != null) {
            this.input = SummaryUtil.serializeInputOutput(workflow.getInput());
        }
        if (workflow.getOutput() != null) {
            this.output = SummaryUtil.serializeInputOutput(workflow.getOutput());
        }
        this.reasonForIncompletion = workflow.getReasonForIncompletion();
        if (workflow.getEndTime() > 0L) {
            this.executionTime = workflow.getEndTime() - workflow.getStartTime();
        }
        this.event = workflow.getEvent();
        this.failedReferenceTaskNames = workflow.getFailedReferenceTaskNames().stream().collect(Collectors.joining(","));
        this.failedTaskNames = workflow.getFailedTaskNames();
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalInputPayloadStoragePath())) {
            this.externalInputPayloadStoragePath = workflow.getExternalInputPayloadStoragePath();
        }
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalOutputPayloadStoragePath())) {
            this.externalOutputPayloadStoragePath = workflow.getExternalOutputPayloadStoragePath();
        }
        if (workflow.getTaskToDomain() != null) {
            this.taskToDomain = workflow.getTaskToDomain();
        }
        this.createdBy = workflow.getCreatedBy();
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Workflow.WorkflowStatus getStatus() {
        return this.status;
    }

    public String getInput() {
        return this.input;
    }

    public long getInputSize() {
        return this.input != null ? (long)this.input.length() : 0L;
    }

    public String getOutput() {
        return this.output;
    }

    public long getOutputSize() {
        return this.output != null ? (long)this.output.length() : 0L;
    }

    public String getReasonForIncompletion() {
        return this.reasonForIncompletion;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getFailedReferenceTaskNames() {
        return this.failedReferenceTaskNames;
    }

    public void setFailedReferenceTaskNames(String failedReferenceTaskNames) {
        this.failedReferenceTaskNames = failedReferenceTaskNames;
    }

    public Set<String> getFailedTaskNames() {
        return this.failedTaskNames;
    }

    public void setFailedTaskNames(Set<String> failedTaskNames) {
        this.failedTaskNames = failedTaskNames;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Workflow.WorkflowStatus status) {
        this.status = status;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setReasonForIncompletion(String reasonForIncompletion) {
        this.reasonForIncompletion = reasonForIncompletion;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public String getExternalInputPayloadStoragePath() {
        return this.externalInputPayloadStoragePath;
    }

    public void setExternalInputPayloadStoragePath(String externalInputPayloadStoragePath) {
        this.externalInputPayloadStoragePath = externalInputPayloadStoragePath;
    }

    public String getExternalOutputPayloadStoragePath() {
        return this.externalOutputPayloadStoragePath;
    }

    public void setExternalOutputPayloadStoragePath(String externalOutputPayloadStoragePath) {
        this.externalOutputPayloadStoragePath = externalOutputPayloadStoragePath;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSummary that = (WorkflowSummary)o;
        return this.getVersion() == that.getVersion() && this.getExecutionTime() == that.getExecutionTime() && this.getPriority() == that.getPriority() && this.getWorkflowType().equals(that.getWorkflowType()) && this.getWorkflowId().equals(that.getWorkflowId()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && StringUtils.equals((CharSequence)this.getStartTime(), (CharSequence)that.getStartTime()) && StringUtils.equals((CharSequence)this.getUpdateTime(), (CharSequence)that.getUpdateTime()) && StringUtils.equals((CharSequence)this.getEndTime(), (CharSequence)that.getEndTime()) && this.getStatus() == that.getStatus() && Objects.equals(this.getReasonForIncompletion(), that.getReasonForIncompletion()) && Objects.equals(this.getEvent(), that.getEvent()) && Objects.equals(this.getCreatedBy(), that.getCreatedBy()) && Objects.equals(this.getTaskToDomain(), that.getTaskToDomain());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getWorkflowType(), this.getVersion(), this.getWorkflowId(), this.getCorrelationId(), this.getStartTime(), this.getUpdateTime(), this.getEndTime(), this.getStatus(), this.getReasonForIncompletion(), this.getExecutionTime(), this.getEvent(), this.getPriority(), this.getCreatedBy(), this.getTaskToDomain()});
    }
}

