/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.events;

import com.google.protobuf.Any;
import com.netflix.conductor.annotations.protogen.ProtoEnum;
import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@ProtoMessage
public class EventHandler {
    @ProtoField(id=1)
    @NotEmpty(message="Missing event handler name")
    private @NotEmpty(message="Missing event handler name") String name;
    @ProtoField(id=2)
    @NotEmpty(message="Missing event location")
    private @NotEmpty(message="Missing event location") String event;
    @ProtoField(id=3)
    private String condition;
    @ProtoField(id=4)
    @NotNull
    @NotEmpty(message="No actions specified. Please specify at-least one action")
    private @NotNull @NotEmpty(message="No actions specified. Please specify at-least one action") List<@Valid Action> actions = new LinkedList<Action>();
    @ProtoField(id=5)
    private boolean active;
    @ProtoField(id=6)
    private String evaluatorType;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getEvaluatorType() {
        return this.evaluatorType;
    }

    public void setEvaluatorType(String evaluatorType) {
        this.evaluatorType = evaluatorType;
    }

    @ProtoMessage
    public static class UpdateWorkflowVariables {
        @ProtoField(id=1)
        private String workflowId;
        @ProtoField(id=2)
        private Map<String, Object> variables;
        @ProtoField(id=3)
        private Boolean appendArray;

        public String getWorkflowId() {
            return this.workflowId;
        }

        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public Boolean isAppendArray() {
            return this.appendArray;
        }

        public void setAppendArray(Boolean appendArray) {
            this.appendArray = appendArray;
        }
    }

    @ProtoMessage
    public static class TerminateWorkflow {
        @ProtoField(id=1)
        private String workflowId;
        @ProtoField(id=2)
        private String terminationReason;

        public String getWorkflowId() {
            return this.workflowId;
        }

        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public String getTerminationReason() {
            return this.terminationReason;
        }

        public void setTerminationReason(String terminationReason) {
            this.terminationReason = terminationReason;
        }
    }

    @ProtoMessage
    public static class StartWorkflow {
        @ProtoField(id=1)
        private String name;
        @ProtoField(id=2)
        private Integer version;
        @ProtoField(id=3)
        private String correlationId;
        @ProtoField(id=4)
        private Map<String, Object> input = new HashMap<String, Object>();
        @ProtoField(id=5)
        @Hidden
        private Any inputMessage;
        @ProtoField(id=6)
        private Map<String, String> taskToDomain;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        public Map<String, Object> getInput() {
            return this.input;
        }

        public void setInput(Map<String, Object> input) {
            this.input = input;
        }

        public Any getInputMessage() {
            return this.inputMessage;
        }

        public void setInputMessage(Any inputMessage) {
            this.inputMessage = inputMessage;
        }

        public Map<String, String> getTaskToDomain() {
            return this.taskToDomain;
        }

        public void setTaskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
        }
    }

    @ProtoMessage
    public static class TaskDetails {
        @ProtoField(id=1)
        private String workflowId;
        @ProtoField(id=2)
        private String taskRefName;
        @ProtoField(id=3)
        private Map<String, Object> output = new HashMap<String, Object>();
        @ProtoField(id=4)
        @Hidden
        private Any outputMessage;
        @ProtoField(id=5)
        private String taskId;

        public String getWorkflowId() {
            return this.workflowId;
        }

        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public String getTaskRefName() {
            return this.taskRefName;
        }

        public void setTaskRefName(String taskRefName) {
            this.taskRefName = taskRefName;
        }

        public Map<String, Object> getOutput() {
            return this.output;
        }

        public void setOutput(Map<String, Object> output) {
            this.output = output;
        }

        public Any getOutputMessage() {
            return this.outputMessage;
        }

        public void setOutputMessage(Any outputMessage) {
            this.outputMessage = outputMessage;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    @ProtoMessage
    public static class Action {
        @ProtoField(id=1)
        private Type action;
        @ProtoField(id=2)
        private StartWorkflow start_workflow;
        @ProtoField(id=3)
        private TaskDetails complete_task;
        @ProtoField(id=4)
        private TaskDetails fail_task;
        @ProtoField(id=5)
        private boolean expandInlineJSON;
        @ProtoField(id=6)
        private TerminateWorkflow terminate_workflow;
        @ProtoField(id=7)
        private UpdateWorkflowVariables update_workflow_variables;

        public Type getAction() {
            return this.action;
        }

        public void setAction(Type action) {
            this.action = action;
        }

        public StartWorkflow getStart_workflow() {
            return this.start_workflow;
        }

        public void setStart_workflow(StartWorkflow start_workflow) {
            this.start_workflow = start_workflow;
        }

        public TaskDetails getComplete_task() {
            return this.complete_task;
        }

        public void setComplete_task(TaskDetails complete_task) {
            this.complete_task = complete_task;
        }

        public TaskDetails getFail_task() {
            return this.fail_task;
        }

        public void setFail_task(TaskDetails fail_task) {
            this.fail_task = fail_task;
        }

        public void setExpandInlineJSON(boolean expandInlineJSON) {
            this.expandInlineJSON = expandInlineJSON;
        }

        public boolean isExpandInlineJSON() {
            return this.expandInlineJSON;
        }

        public TerminateWorkflow getTerminate_workflow() {
            return this.terminate_workflow;
        }

        public void setTerminate_workflow(TerminateWorkflow terminate_workflow) {
            this.terminate_workflow = terminate_workflow;
        }

        public UpdateWorkflowVariables getUpdate_workflow_variables() {
            return this.update_workflow_variables;
        }

        public void setUpdate_workflow_variables(UpdateWorkflowVariables update_workflow_variables) {
            this.update_workflow_variables = update_workflow_variables;
        }

        @ProtoEnum
        public static enum Type {
            start_workflow,
            complete_task,
            fail_task,
            terminate_workflow,
            update_workflow_variables;

        }
    }
}

