/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Constraint(validatedBy={TaskTimeoutValidator.class})
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TaskTimeoutConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class TaskTimeoutValidator
    implements ConstraintValidator<TaskTimeoutConstraint, TaskDef> {
        public void initialize(TaskTimeoutConstraint constraintAnnotation) {
        }

        public boolean isValid(TaskDef taskDef, ConstraintValidatorContext context) {
            String message;
            context.disableDefaultConstraintViolation();
            boolean valid = true;
            if (taskDef.getTimeoutSeconds() > 0L && taskDef.getResponseTimeoutSeconds() > taskDef.getTimeoutSeconds()) {
                valid = false;
                message = String.format("TaskDef: %s responseTimeoutSeconds: %d must be less than timeoutSeconds: %d", taskDef.getName(), taskDef.getResponseTimeoutSeconds(), taskDef.getTimeoutSeconds());
                context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
            }
            if (taskDef.getTimeoutSeconds() > 0L && taskDef.getTotalTimeoutSeconds() > 0L && taskDef.getTimeoutSeconds() > taskDef.getTotalTimeoutSeconds()) {
                valid = false;
                message = String.format("TaskDef: %s timeoutSeconds: %d must be less than or equal to totalTimeoutSeconds: %d", taskDef.getName(), taskDef.getTimeoutSeconds(), taskDef.getTotalTimeoutSeconds());
                context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
            }
            return valid;
        }
    }
}

