/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component(value="ConductorJsonProtoModule")
public class JsonProtoModule
extends SimpleModule {
    public static final String NAME = "ConductorJsonProtoModule";
    private static final String JSON_TYPE = "@type";
    private static final String JSON_VALUE = "@value";

    public JsonProtoModule() {
        super(NAME);
        this.addSerializer(Any.class, new AnySerializer());
        this.addDeserializer(Any.class, new AnyDeserializer());
    }

    protected class AnySerializer
    extends JsonSerializer<Any> {
        protected AnySerializer() {
        }

        public void serialize(Any value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(JsonProtoModule.JSON_TYPE, value.getTypeUrl());
            jgen.writeBinaryField(JsonProtoModule.JSON_VALUE, value.getValue().toByteArray());
            jgen.writeEndObject();
        }
    }

    protected class AnyDeserializer
    extends JsonDeserializer<Any> {
        protected AnyDeserializer() {
        }

        public Any deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode root = (JsonNode)p.getCodec().readTree(p);
            JsonNode type = root.get(JsonProtoModule.JSON_TYPE);
            JsonNode value = root.get(JsonProtoModule.JSON_VALUE);
            if (type == null || !type.isTextual()) {
                ctxt.reportBadDefinition(type.getClass(), "invalid '@type' field when deserializing ProtoBuf Any object");
            }
            if (value == null || !value.isTextual()) {
                ctxt.reportBadDefinition(type.getClass(), "invalid '@value' field when deserializing ProtoBuf Any object");
            }
            return Any.newBuilder().setTypeUrl(type.textValue()).setValue(ByteString.copyFrom((byte[])value.binaryValue())).build();
        }
    }
}

