/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.constraints;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Value;

@Documented
@Constraint(validatedBy={NameValidator.class})
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ValidNameConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class NameValidator
    implements ConstraintValidator<ValidNameConstraint, String> {
        private static final String NAME_PATTERN = "^[A-Za-z0-9_<>{}#\\s-]+$";
        public static final String INVALID_NAME_MESSAGE = "Allowed characters are alphanumeric, underscores, spaces, hyphens, and special characters like <, >, {, }, #";
        @Value(value="${conductor.app.workflow.name-validation.enabled}")
        private boolean nameValidationEnabled;

        public void initialize(ValidNameConstraint constraintAnnotation) {
        }

        public boolean isValid(String name, ConstraintValidatorContext context) {
            boolean valid;
            boolean bl = valid = name == null || !this.nameValidationEnabled || name.matches(NAME_PATTERN);
            if (!valid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("Invalid name '" + name + "'. Allowed characters are alphanumeric, underscores, spaces, hyphens, and special characters like <, >, {, }, #").addConstraintViolation();
            }
            return valid;
        }
    }
}

