/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.annotations.protogen.ProtoField;
import com.netflix.conductor.annotations.protogen.ProtoMessage;
import java.util.HashMap;
import java.util.Map;

@ProtoMessage
public class ExecutionMetadata {
    @ProtoField(id=1)
    private Long serverSendTime;
    @ProtoField(id=2)
    private Long clientReceiveTime;
    @ProtoField(id=3)
    private Long executionStartTime;
    @ProtoField(id=4)
    private Long executionEndTime;
    @ProtoField(id=5)
    private Long clientSendTime;
    @ProtoField(id=6)
    private Long pollNetworkLatency;
    @ProtoField(id=7)
    private Long updateNetworkLatency;
    @ProtoField(id=8)
    private Map<String, Object> additionalContext = new HashMap<String, Object>();

    public void setServerSendTime(long timestamp) {
        this.serverSendTime = timestamp;
    }

    public void setClientReceiveTime(long timestamp) {
        this.clientReceiveTime = timestamp;
    }

    public void setExecutionStartTime(long timestamp) {
        this.executionStartTime = timestamp;
    }

    public void setExecutionEndTime(long timestamp) {
        this.executionEndTime = timestamp;
    }

    public void setClientSendTime(long timestamp) {
        this.clientSendTime = timestamp;
    }

    public void setPollNetworkLatency(long latencyMs) {
        this.pollNetworkLatency = latencyMs;
    }

    public void setUpdateNetworkLatency(long latencyMs) {
        this.updateNetworkLatency = latencyMs;
    }

    public Long getServerSendTime() {
        return this.serverSendTime;
    }

    public Long getClientReceiveTime() {
        return this.clientReceiveTime;
    }

    public Long getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Long getExecutionEndTime() {
        return this.executionEndTime;
    }

    public Long getClientSendTime() {
        return this.clientSendTime;
    }

    public Long getPollNetworkLatency() {
        return this.pollNetworkLatency;
    }

    public Long getUpdateNetworkLatency() {
        return this.updateNetworkLatency;
    }

    public Long getExecutionDuration() {
        if (this.executionStartTime != null && this.executionEndTime != null) {
            return this.executionEndTime - this.executionStartTime;
        }
        return null;
    }

    public void setAdditionalContext(String key, Object value) {
        this.additionalContext.put(key, value);
    }

    public Object getAdditionalContext(String key) {
        return this.additionalContext.get(key);
    }

    public Map<String, Object> getAdditionalContext() {
        return this.additionalContext;
    }

    public void setServerSendTime(Long serverSendTime) {
        this.serverSendTime = serverSendTime;
    }

    public void setClientReceiveTime(Long clientReceiveTime) {
        this.clientReceiveTime = clientReceiveTime;
    }

    public void setExecutionStartTime(Long executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public void setExecutionEndTime(Long executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public void setClientSendTime(Long clientSendTime) {
        this.clientSendTime = clientSendTime;
    }

    public void setPollNetworkLatency(Long pollNetworkLatency) {
        this.pollNetworkLatency = pollNetworkLatency;
    }

    public void setUpdateNetworkLatency(Long updateNetworkLatency) {
        this.updateNetworkLatency = updateNetworkLatency;
    }

    public Map<String, Object> getAdditionalContextMap() {
        return this.additionalContext;
    }

    public void setAdditionalContextMap(Map<String, Object> additionalContext) {
        this.additionalContext = additionalContext != null ? additionalContext : new HashMap();
    }

    public void setAdditionalContext(Map<String, Object> additionalContext) {
        this.additionalContext = additionalContext != null ? additionalContext : new HashMap();
    }

    public boolean hasData() {
        return this.serverSendTime != null || this.clientReceiveTime != null || this.executionStartTime != null || this.executionEndTime != null || this.clientSendTime != null || this.pollNetworkLatency != null || this.updateNetworkLatency != null || this.additionalContext != null && !this.additionalContext.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasData();
    }

    public String toString() {
        return "ExecutionMetadata{serverSendTime=" + this.serverSendTime + ", clientReceiveTime=" + this.clientReceiveTime + ", executionStartTime=" + this.executionStartTime + ", executionEndTime=" + this.executionEndTime + ", clientSendTime=" + this.clientSendTime + ", pollNetworkLatency=" + this.pollNetworkLatency + ", updateNetworkLatency=" + this.updateNetworkLatency + ", additionalContext=" + String.valueOf(this.additionalContext) + "}";
    }
}

