/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.grpc;

import com.google.common.base.Preconditions;
import com.netflix.conductor.client.grpc.ClientBase;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.grpc.MetadataServiceGrpc;
import com.netflix.conductor.grpc.MetadataServicePb;
import com.netflix.conductor.grpc.ProtoMapper;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import jakarta.annotation.Nullable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MetadataClient
extends ClientBase {
    private final MetadataServiceGrpc.MetadataServiceBlockingStub stub;

    public MetadataClient(String address, int port) {
        super(address, port);
        this.stub = MetadataServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public MetadataClient(ManagedChannelBuilder<?> builder) {
        super(builder);
        this.stub = MetadataServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void registerWorkflowDef(WorkflowDef workflowDef) {
        Preconditions.checkNotNull((Object)workflowDef, (Object)"Worfklow definition cannot be null");
        this.stub.createWorkflow(MetadataServicePb.CreateWorkflowRequest.newBuilder().setWorkflow(protoMapper.toProto(workflowDef)).build());
    }

    public void updateWorkflowDefs(List<WorkflowDef> workflowDefs) {
        Preconditions.checkNotNull(workflowDefs, (Object)"Workflow defs list cannot be null");
        this.stub.updateWorkflows(MetadataServicePb.UpdateWorkflowsRequest.newBuilder().addAllDefs(workflowDefs.stream().map(arg_0 -> ((ProtoMapper)protoMapper).toProto(arg_0))::iterator).build());
    }

    public WorkflowDef getWorkflowDef(String name, @Nullable Integer version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be blank");
        MetadataServicePb.GetWorkflowRequest.Builder request = MetadataServicePb.GetWorkflowRequest.newBuilder().setName(name);
        if (version != null) {
            request.setVersion(version.intValue());
        }
        return protoMapper.fromProto(this.stub.getWorkflow(request.build()).getWorkflow());
    }

    public void registerTaskDefs(List<TaskDef> taskDefs) {
        Preconditions.checkNotNull(taskDefs, (Object)"Task defs list cannot be null");
        this.stub.createTasks(MetadataServicePb.CreateTasksRequest.newBuilder().addAllDefs(taskDefs.stream().map(arg_0 -> ((ProtoMapper)protoMapper).toProto(arg_0))::iterator).build());
    }

    public void updateTaskDef(TaskDef taskDef) {
        Preconditions.checkNotNull((Object)taskDef, (Object)"Task definition cannot be null");
        this.stub.updateTask(MetadataServicePb.UpdateTaskRequest.newBuilder().setTask(protoMapper.toProto(taskDef)).build());
    }

    public TaskDef getTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskType), (Object)"Task type cannot be blank");
        return protoMapper.fromProto(this.stub.getTask(MetadataServicePb.GetTaskRequest.newBuilder().setTaskType(taskType).build()).getTask());
    }

    public void unregisterTaskDef(String taskType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskType), (Object)"Task type cannot be blank");
        this.stub.deleteTask(MetadataServicePb.DeleteTaskRequest.newBuilder().setTaskType(taskType).build());
    }
}

