/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.grpc;

import com.google.protobuf.Any;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.grpc.AbstractProtoMapper;
import com.netflix.conductor.proto.WorkflowTaskPb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ProtoMapper
extends AbstractProtoMapper {
    public static final ProtoMapper INSTANCE = new ProtoMapper();
    private static final int NO_RETRY_VALUE = -1;

    private ProtoMapper() {
    }

    @Override
    public Value toProto(Object val) {
        Value.Builder builder = Value.newBuilder();
        if (val == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (val instanceof Boolean) {
            builder.setBoolValue(((Boolean)val).booleanValue());
        } else if (val instanceof Double) {
            builder.setNumberValue(((Double)val).doubleValue());
        } else if (val instanceof String) {
            builder.setStringValue((String)val);
        } else if (val instanceof Map) {
            Map map = (Map)val;
            Struct.Builder struct = Struct.newBuilder();
            for (Map.Entry pair : map.entrySet()) {
                struct.putFields((String)pair.getKey(), this.toProto(pair.getValue()));
            }
            builder.setStructValue(struct.build());
        } else if (val instanceof List) {
            ListValue.Builder list = ListValue.newBuilder();
            for (Object obj : (List)val) {
                list.addValues(this.toProto(obj));
            }
            builder.setListValue(list.build());
        } else {
            throw new ClassCastException("cannot map to Value type: " + String.valueOf(val));
        }
        return builder.build();
    }

    @Override
    public Object fromProto(Value any) {
        switch (any.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case BOOL_VALUE: {
                return any.getBoolValue();
            }
            case NUMBER_VALUE: {
                return any.getNumberValue();
            }
            case STRING_VALUE: {
                return any.getStringValue();
            }
            case STRUCT_VALUE: {
                Struct struct = any.getStructValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry pair : struct.getFieldsMap().entrySet()) {
                    map.put((String)pair.getKey(), this.fromProto((Value)pair.getValue()));
                }
                return map;
            }
            case LIST_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Value val : any.getListValue().getValuesList()) {
                    list.add(this.fromProto(val));
                }
                return list;
            }
        }
        throw new ClassCastException("unset Value element: " + String.valueOf(any));
    }

    @Override
    public List<WorkflowTask> fromProto(WorkflowTaskPb.WorkflowTask.WorkflowTaskList list) {
        return list.getTasksList().stream().map(this::fromProto).collect(Collectors.toList());
    }

    @Override
    public WorkflowTaskPb.WorkflowTask toProto(WorkflowTask from) {
        WorkflowTaskPb.WorkflowTask.Builder to = WorkflowTaskPb.WorkflowTask.newBuilder(super.toProto(from));
        if (from.getRetryCount() == null) {
            to.setRetryCount(-1);
        }
        return to.build();
    }

    @Override
    public WorkflowTask fromProto(WorkflowTaskPb.WorkflowTask from) {
        WorkflowTask workflowTask = super.fromProto(from);
        if (from.getRetryCount() == -1) {
            workflowTask.setRetryCount(null);
        }
        return workflowTask;
    }

    @Override
    public WorkflowTaskPb.WorkflowTask.WorkflowTaskList toProto(List<WorkflowTask> list) {
        return WorkflowTaskPb.WorkflowTask.WorkflowTaskList.newBuilder().addAllTasks(list.stream().map(this::toProto)::iterator).build();
    }

    @Override
    public Any toProto(Any in) {
        return in;
    }

    @Override
    public Any fromProto(Any in) {
        return in;
    }
}

