/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.nats;

import io.nats.client.Connection;
import io.nats.client.ErrorListener;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNatsErrorListener
implements ErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingNatsErrorListener.class);

    public void errorOccurred(Connection conn, String error) {
        LOG.error("Nats connection error occurred: {}", (Object)error);
    }

    public void exceptionOccurred(Connection conn, Exception exp) {
        LOG.error("Nats connection exception occurred", (Throwable)exp);
    }

    public void messageDiscarded(Connection conn, Message msg) {
        LOG.error("Nats message discarded, SID={}, ", (Object)msg.getSID());
    }

    public void heartbeatAlarm(Connection conn, JetStreamSubscription sub, long lastStreamSequence, long lastConsumerSequence) {
        LOG.warn("Heartbit missed, subject={}", (Object)sub.getSubject());
    }
}

